<x-user>
    <div class="content flex-grow lg:px-12">
        <!--:Page Header:-->
        <div class="px-4 lg:px-8 pt-4 pb-4 flex flex-col sm:flex-row sm:items-center">
            <div class="flex-grow mb-3 sm:mb-0">
                <h2 class="text-2xl font-semibold mb-1 text-black dark:text-white">📈 Investment Details</h2>
                <p>Investment performance and transactions</p>
            </div>
        </div>

        <div class="content flex flex-col flex-grow px-2 lg:px-8">
            <div class="rounded-xl bg-white dark:bg-zinc-900 border border-zinc-200 dark:border-zinc-700 shadow-card">
                <div class="px-4 pt-4 rounded-t-md border border-zinc-200 dark:border-zinc-700">
                    <!-- Plan name and status badge -->
                    <div class="flex items-center justify-between">
                        <h5 class="text-lg flex items-center gap-2">
                            {{ $invest->plan->name }}
                            <span
                                class="badge
                        @if ($invest->status === 'active') bg-green-500/10 text-green-500
                        @elseif($invest->status === 'completed') bg-blue-500/10 text-blue-500
                        @elseif($invest->status === 'pending') bg-amber-500/10 text-amber-500
                        @else bg-red-500/10 text-red-500 @endif">
                                <div
                                    class="w-1.5 h-1.5 rounded-full mr-1.5
                            @if ($invest->status === 'active') bg-green-500
                            @elseif($invest->status === 'completed') bg-blue-500
                            @elseif($invest->status === 'pending') bg-amber-500
                            @else bg-red-500 @endif">
                                </div>
                                {{ ucfirst($invest->status) }}
                            </span>
                        </h5>

                    </div>

                    <!-- ✅ Interest rate & duration under plan name -->
                    <p class="text-sm text-zinc-500 mb-3 mt-1">
                        {{ $invest->plan->interest_rate }}% {{ ucfirst($invest->plan->interest_type) }} for
                        {{ $invest->plan->duration_in_days }} days
                    </p>
                </div>

                <div class="p-3">
                    <div class="p-2 rounded-md bg-white dark:bg-zinc-900 shadow-card overflow-hidden">
                        <div class="mb-2.5 flex items-center justify-between">
                            <h5 class="text-lg">Financial Overview</h5>
                        </div>
                        <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                            <!-- ROI Card -->
                            <div
                                class="flex items-center border border-zinc-200 dark:border-zinc-700 gap-4 p-4 bg-zinc-50 dark:bg-white/3 rounded-md">
                                <!-- Icon -->
                                <div
                                    class="flex items-center justify-center size-12 rounded-full shrink-0 bg-primary text-white">
                                    <span class="icon-[lucide--refresh-ccw-dot] text-xl"></span>
                                </div>

                                <!-- Texts -->
                                <div>
                                    <p class="mb-1 text-sm text-zinc-500">Investment Amount</p>
                                    <h5 class="text-xl font-semibold mb-1">${{ number_format($invest->amount, 2) }}</h5>
                                    {{-- <span class="text-xs text-muted flex items-center gap-1">
                                    <span class="text-green-500">+2.3%</span> vs last year
                                </span> --}}
                                </div>
                            </div>

                            <!-- Conversion Rates Card -->
                            <div
                                class="flex items-center  border border-zinc-200 dark:border-zinc-700 gap-4 p-4 bg-zinc-50 dark:bg-white/3 rounded-md">
                                <div
                                    class="flex items-center justify-center size-12 rounded-full shrink-0 bg-blue-500 text-white">
                                    <span class="icon-[lucide--percent] text-xl"></span>
                                </div>
                                <div>
                                    <p class="mb-1 text-sm text-zinc-500">Profit Earned</p>
                                    <h5 class="text-xl font-semibold mb-1">${{ number_format($invest->profit, 2) }}</h5>
                                    {{-- <span class="text-xs text-muted flex items-center gap-1">
                                    <span class="text-green-500">+0.8%</span> vs last year
                                </span> --}}
                                </div>
                            </div>

                            <!-- Total Leads Card -->
                            <div
                                class="flex items-center border border-zinc-200 dark:border-zinc-700 gap-4 p-4 bg-zinc-50 dark:bg-white/3 rounded-md">
                                <div
                                    class="flex items-center justify-center size-12 rounded-full shrink-0 bg-red-500 text-white">
                                    <span class="icon-[lucide--magnet] text-xl"></span>
                                </div>
                                <div>
                                    <p class="mb-1 text-sm text-zinc-500">Total Return</p>
                                    <h5 class="text-xl font-semibold mb-1">
                                        ${{ number_format($invest->expected_return, 2) }}
                                    </h5>
                                    {{-- <span class="text-xs text-muted flex items-center gap-1">
                                    <span class="text-green-500">+1.3%</span> vs last year
                                </span> --}}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <hr class="border-zinc-200 dark:border-zinc-700 border my-3">

                <div class="mb-4 p-4 rounded-xl bg-white dark:bg-zinc-900 shadow-card overflow-hidden">
                    <div class="mb-2.5 flex items-center justify-between">
                        <h5 class="text-lg">Plan Details</h5>
                    </div>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <!--:Card:-->
                        <div class="overflow-hidden rounded-md">
                            <ul class="divide-y divide-zinc-500/10 dark:divide-zinc-800">
                                <!--:List item:-->
                                <li class="py-3 flex items-center gap-3.5">
                                    <a href="index-education.html#!" class="shrink-0">
                                        <div
                                            class="shrink-0 flex items-center justify-center size-10 rounded-lg bg-sky-500/10 text-sky-500">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48"
                                                viewBox="0 0 48 48">
                                                <g fill="currentColor">
                                                    <path fill-rule="evenodd"
                                                        d="M17 25h-2v2h2zm-2-2a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2v-2a2 2 0 0 0-2-2zm10 2h-2v2h2zm-2-2a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2v-2a2 2 0 0 0-2-2zm10 2h-2v2h2zm-2-2a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2v-2a2 2 0 0 0-2-2zM17 33h-2v2h2zm-2-2a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2v-2a2 2 0 0 0-2-2zm10 2h-2v2h2zm-2-2a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2v-2a2 2 0 0 0-2-2zm10 2h-2v2h2zm-2-2a2 2 0 0 0-2 2v2a2 2 0 0 0 2 2h2a2 2 0 0 0 2-2v-2a2 2 0 0 0-2-2z"
                                                        clip-rule="evenodd" />
                                                    <path fill-rule="evenodd"
                                                        d="M10 11a1 1 0 0 0-1 1v27a1 1 0 0 0 1 1h28c.55 0 1-.449 1-1.002V12.002c0-.554-.45-1.002-1-1.002h-3V9h3c1.658 0 3 1.347 3 3.002v26.996A3 3 0 0 1 38 42H10a3 3 0 0 1-3-3V12a3 3 0 0 1 3-3h5v2zm21 0H19V9h12z"
                                                        clip-rule="evenodd" />
                                                    <path fill-rule="evenodd" d="M39 20H9v-2h30z" clip-rule="evenodd" />
                                                    <path
                                                        d="M15 7a1 1 0 1 1 2 0v7a1 1 0 1 1-2 0zm16 0a1 1 0 1 1 2 0v7a1 1 0 1 1-2 0z" />
                                                </g>
                                            </svg>
                                        </div>
                                    </a>
                                    <div class="flex-grow">
                                        <p class="text-muted">Duration</p>
                                        <p class="flex text-md font-semibold items-center gap-1">
                                            {{ $invest->plan->duration_in_days }}
                                            days
                                        </p>
                                    </div>
                                </li>
                                <!--:List item:-->
                                <li class="py-3 flex items-center gap-3.5">
                                    <a href="index-education.html#!" class="shrink-0">
                                        <div
                                            class="shrink-0 flex items-center justify-center size-10 rounded-lg bg-green-500/10 text-green-500">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 32 32">
                                                <path fill="currentColor"
                                                    d="M9 5v1H5v22h22V6h-4V5h-2v1H11V5zM7 8h2v1h2V8h10v1h2V8h2v2H7zm0 4h18v14H7zm8 2v4h-4v2h4v4h2v-4h4v-2h-4v-4z" />
                                            </svg>
                                        </div>
                                    </a>
                                    <div class="flex-grow">
                                        <p class="text-muted">Start Date</p>
                                        <p class="flex text-md font-semibold items-center gap-1">
                                            {{ \Carbon\Carbon::parse($invest->start_date)->format('D, M d, Y') }}
                                        </p>
                                    </div>
                                </li>
                                <!--:List item:-->
                                <li class="py-3 flex items-center gap-3.5">
                                    <a href="index-education.html#!" class="shrink-0">
                                        <div
                                            class="shrink-0 flex items-center justify-center size-10 rounded-lg bg-red-500/10 text-red-500">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24">
                                                <path fill="currentColor"
                                                    d="M5.616 21q-.691 0-1.153-.462T4 19.385V6.615q0-.69.463-1.152T5.616 5h1.769V3.308q0-.233.153-.386t.385-.153t.386.153t.153.386V5h7.154V3.27q0-.214.143-.358t.357-.143t.356.143t.144.357V5h1.769q.69 0 1.153.463T20 6.616v6.586q0 .214-.143.357t-.357.143t-.357-.143t-.143-.357v-2.586H5v8.769q0 .23.192.423t.423.192h5.976q.213 0 .353.143q.14.144.14.357t-.143.357t-.357.143zM5 9.615h14v-3q0-.23-.192-.423T18.384 6H5.616q-.231 0-.424.192T5 6.616zm0 0V6zm11.467 10.483l3.704-3.704q.146-.146.345-.155t.363.155t.165.357t-.165.357l-3.84 3.826q-.243.243-.569.243t-.568-.242l-1.818-1.798q-.165-.147-.165-.348t.165-.366q.166-.165.357-.165q.192 0 .357.165z" />
                                            </svg>
                                        </div>
                                    </a>
                                    <div class="flex-grow">
                                        <p class="text-muted">End Date</p>
                                        <p class="flex text-md font-semibold items-center gap-1">
                                            {{ \Carbon\Carbon::parse($invest->end_date)->format('D, M d, Y') }}
                                        </p>
                                    </div>
                                </li>
                            </ul>
                        </div>
                        <!--:Card:-->
                        <div class="overflow-hidden rounded-md">
                            <ul class="divide-y divide-zinc-500/10 dark:divide-zinc-800">
                                <!--:List item:-->
                                <li class="py-3 flex items-center gap-3.5">
                                    <a href="index-education.html#!" class="shrink-0">
                                        <div
                                            class="shrink-0 flex items-center justify-center size-10 rounded-lg bg-amber-500/10 text-amber-500">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24">
                                                <path fill="none" stroke="currentColor" stroke-linecap="round"
                                                    stroke-width="2" d="M17 5v15m-5-9v9m-5-6v6" />
                                            </svg>
                                        </div>
                                    </a>
                                    <div class="flex-grow">
                                        <h6 class="mb-0.5"><a href="index-education.html#!">ROI Interval</a></h6>
                                        <p class="flex text-md font-semibold items-center gap-1">
                                            {{ $invest->plan->interest_rate }}%
                                            {{ ucfirst($invest->plan->interest_type) }} for
                                            {{ $invest->plan->duration_in_days }} days
                                        </p>
                                    </div>
                                </li>
                                <!--:List item:-->
                                <li class="py-3 flex items-center gap-3.5">
                                    <a href="index-education.html#!" class="shrink-0">
                                        <div
                                            class="shrink-0 flex items-center justify-center size-10 rounded-lg bg-green-500/10 text-green-500">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                                viewBox="0 0 24 24">
                                                <path fill="none" stroke="currentColor" stroke-width="2"
                                                    d="m1 16l7-7l5 5L23 4M0 22h23.999M16 4h7v7" />
                                            </svg>
                                        </div>
                                    </a>

                                    <div class="flex-grow">
                                        <h6 class="mb-0.5"><a href="index-education.html#!">Minimum Return</a></h6>
                                        <p class="flex text-md font-semibold items-center gap-1">
                                            {{ $invest->plan->min_amount_percentage }}%
                                        </p>
                                    </div>
                                </li>
                                <!--:List item:-->
                                <li class="py-3 flex items-center gap-3.5">
                                    <a href="index-education.html#!" class="shrink-0">
                                        <div
                                            class="shrink-0 flex items-center justify-center size-10 rounded-lg bg-primary-subtle text-blue-500">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                                viewBox="0 0 24 24">
                                                <path fill="none" stroke="currentColor" stroke-width="2"
                                                    d="m1 16l7-7l5 5L23 4M0 22h23.999M16 4h7v7" />
                                            </svg>
                                        </div>
                                    </a>
                                    <div class="flex-grow">
                                        <h6 class="mb-0.5"><a href="index-education.html#!">Maximum Return</a></h6>
                                        <p class="flex text-md font-semibold items-center gap-1">
                                            {{ $invest->plan->max_amount_percentage }}%
                                        </p>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>

            {{-- <div class="mt-6">
            <h4 class="text-lg font-semibold text-white mb-3 flex items-center gap-2">
                <span class="icon-[lucide--list-checks] text-primary"></span>
                Investment Logs
            </h4>

            @if ($invest->logs->count() > 0)
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm text-zinc-300 border border-zinc-700 rounded-lg">
                    <thead class="bg-zinc-800/60 text-zinc-400 text-xs uppercase tracking-wide">
                        <tr>
                            <th class="px-4 py-3 text-left">Date</th>
                            <th class="px-4 py-3 text-left">Type</th>
                            <th class="px-4 py-3 text-left">Amount</th>
                            <th class="px-4 py-3 text-left">Note</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y divide-zinc-800">
                        @foreach ($invest->logs->sortByDesc('created_at') as $log)
                        <tr class="hover:bg-zinc-800/40 transition">
                            <td class="px-4 py-2">
                                {{ \Carbon\Carbon::parse($log->created_at)->format('D, M d, Y g:i A') }}
                            </td>
                            <td class="px-4 py-2">
                                @if ($log->type === 'profit_progress')
                                <span class="text-green-400 font-semibold">Profit</span>
                                @elseif($log->type === 'completed')
                                <span class="text-blue-400 font-semibold">Completed</span>
                                @else
                                <span class="text-yellow-400 font-semibold">{{ ucfirst($log->type) }}</span>
                                @endif
                            </td>
                            <td class="px-4 py-2">
                                ${{ number_format($log->amount, 2) }}
                            </td>
                            <td class="px-4 py-2 text-zinc-400">
                                {{ $log->note ?? '—' }}
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            @else
            <div class="flex flex-col items-center justify-center p-6 text-center text-gray-500 dark:text-gray-400">
                <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 48 48" class="mb-3">
                    <g fill="none">
                        <path fill="url(#SVGHyoaDcJJ)"
                            d="M23.5 13a1.5 1.5 0 0 1 1.5 1.5V23h5.5a1.5 1.5 0 0 1 0 3h-7a1.5 1.5 0 0 1-1.5-1.5v-10a1.5 1.5 0 0 1 1.5-1.5" />
                        <path fill="url(#SVGGRTsNbtc)"
                            d="M24 9c8.284 0 15 6.716 15 15s-6.716 15-15 15S9 32.284 9 24q.002-1.162.171-2.275a1.5 1.5 0 0 0-2.966-.45Q6.001 22.61 6 24c0 9.941 8.059 18 18 18s18-8.059 18-18S33.941 6 24 6c-4.61 0-8.816 1.734-12 4.584V7.5a1.5 1.5 0 0 0-3 0v7a1.5 1.5 0 0 0 1.5 1.5h7a1.5 1.5 0 0 0 0-3h-3.698A14.94 14.94 0 0 1 24 9" />
                        <defs>
                            <linearGradient id="SVGHyoaDcJJ" x1="20.313" x2="44.734" y1="37.809" y2="28.299"
                                gradientUnits="userSpaceOnUse">
                                <stop stop-color="#d373fc" />
                                <stop offset="1" stop-color="#6d37cd" />
                            </linearGradient>
                            <linearGradient id="SVGGRTsNbtc" x1="6" x2="15.663" y1="8.118" y2="48.577"
                                gradientUnits="userSpaceOnUse">
                                <stop stop-color="#0fafff" />
                                <stop offset="1" stop-color="#0067bf" />
                            </linearGradient>
                        </defs>
                    </g>
                </svg>

                <p class="text-xl font-semibold">No open trades yet.</p>
            </div>
            @endif
        </div> --}}

            <div
                class="rounded-xl bg-white dark:bg-zinc-900 shadow-card mt-3 border-zinc-200 dark:border-zinc-700 border  overflow-hidden">
                <div class="px-4 py-4 flex items-center justify-between">
                    <h5 class="text-lg">Transaction History</h5>
                </div>
                @if ($invest->logs->count() > 0)
                    <div class="overflow-x-auto px-4 hidden lg:block">
                        <table class="table-default whitespace-nowrap my-3">
                            <thead class="border-t border-zinc-500/10 dark:border-zinc-800">
                                <tr>
                                    <th class="whitespace-nowrap">Type</th>
                                    <th class="whitespace-nowrap">Date</th>
                                    <th class="whitespace-nowrap">Amount</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach ($invest->logs->sortByDesc('created_at') as $log)
                                    <tr>
                                        <td>
                                            <h5 class="font-semibold">{{ ucfirst($log->type) }}</h5>
                                        </td>
                                        <td>{{ \Carbon\Carbon::parse($log->created_at)->format('D, M d, Y g:i A') }}
                                        </td>
                                        <td>${{ number_format($log->amount, 2) }}</td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>

                    <!-- Mobile Table -->
                    <div class="block lg:hidden space-y-4 my-5">
                        @foreach ($invest->logs->sortByDesc('created_at') as $log)
                            <div class="overflow-x-auto px-2">
                                <div
                                    class="rounded-md p-4 border-zinc-200 dark:border-zinc-800 border transition-colors duration-300">
                                    <div class="flex items-start justify-between">
                                        <!-- Logo and Amount Section -->
                                        <div class="flex items-center space-x-5">
                                            <!-- Gateway Logo -->
                                            <div class="flex items-center gap-2">
                                                <div>
                                                    <h6 class="leading-tight">
                                                        ${{ number_format($log->amount, 2) }}
                                                    </h6>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Status Badge -->
                                        <span
                                            class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium">
                                            @if ($log->type === 'profit_progress')
                                                <span class="text-green-500 font-semibold">Profit</span>
                                            @elseif($log->type === 'completed')
                                                <span
                                                    class="badge bg-primary-subtle text-primary font-semibold">Completed</span>
                                            @else
                                                <span
                                                    class="badge bg-amber-500/10 text-amber-500 font-semibold">{{ ucfirst($log->type) }}</span>
                                            @endif
                                        </span>
                                    </div>

                                    <!-- Payment Mode -->
                                    <div class="flex justify-between items-center text-sm">
                                        <span
                                            class="text-slate-400 text-muted">{{ \Carbon\Carbon::parse($log->created_at)->format('D, M d, Y g:i A') }}</span>
                                    </div>

                                    <!-- Date -->
                                    <div class="mt-2 text-md text-muted text-slate-500">
                                        {{ $log->note ?? '—' }}
                                    </div>
                                </div>
                            </div>
                        @endforeach

                    </div>
                @else
                    <div
                        class="flex flex-col items-center justify-center p-4 text-center text-gray-500 dark:text-gray-400">
                        <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 48 48"
                            class="mb-3">
                            <g fill="none">
                                <path fill="url(#SVGHyoaDcJJ)"
                                    d="M23.5 13a1.5 1.5 0 0 1 1.5 1.5V23h5.5a1.5 1.5 0 0 1 0 3h-7a1.5 1.5 0 0 1-1.5-1.5v-10a1.5 1.5 0 0 1 1.5-1.5" />
                                <path fill="url(#SVGGRTsNbtc)"
                                    d="M24 9c8.284 0 15 6.716 15 15s-6.716 15-15 15S9 32.284 9 24q.002-1.162.171-2.275a1.5 1.5 0 0 0-2.966-.45Q6.001 22.61 6 24c0 9.941 8.059 18 18 18s18-8.059 18-18S33.941 6 24 6c-4.61 0-8.816 1.734-12 4.584V7.5a1.5 1.5 0 0 0-3 0v7a1.5 1.5 0 0 0 1.5 1.5h7a1.5 1.5 0 0 0 0-3h-3.698A14.94 14.94 0 0 1 24 9" />
                                <defs>
                                    <linearGradient id="SVGHyoaDcJJ" x1="20.313" x2="44.734" y1="37.809"
                                        y2="28.299" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#d373fc" />
                                        <stop offset="1" stop-color="#6d37cd" />
                                    </linearGradient>
                                    <linearGradient id="SVGGRTsNbtc" x1="6" x2="15.663" y1="8.118"
                                        y2="48.577" gradientUnits="userSpaceOnUse">
                                        <stop stop-color="#0fafff" />
                                        <stop offset="1" stop-color="#0067bf" />
                                    </linearGradient>
                                </defs>
                            </g>
                        </svg>
                        <p class="text-xl font-semibold">No Transaction Log yet.</p>
                    </div>
                @endif
            </div>

        </div>
    </div>

</x-user>
