<x-user :title="$pageTitle">
    {{--
    <script defer src="https://www.livecoinwatch.com/static/lcw-widget.js"></script>
    <div class="livecoinwatch-widget-5" lcw-base="USD" lcw-color-tx="#999999" lcw-marquee-1="coins"
        lcw-marquee-2="movers" lcw-marquee-items="10"></div> --}}
    <!--:Page Header:-->
    <div class="px-4 lg:px-8 pt-4 pb-4 flex flex-col sm:flex-row sm:items-center">
        <div class="flex-grow mb-3 sm:mb-0">
            <h2 class="text-xl font-semibold text-black dark:text-white">Trading Markets</h2>
            <p>Choose from thousands of trading instruments across multiple asset classes</p>
        </div>
        <div class="flex flex-col">
            <!--:Search:-->
            <div class="pt-4 pb-2 px-3">
                <div class="relative">
                    <span class="absolute left-0 top-0 w-8 flex items-center justify-center h-full">
                        <span class="icon-[lucide--search]"></span>
                    </span>

                    <input id="instrumentSearch" type="text" placeholder="Search Instruments"
                        class="input input-sm !pl-7">

                    <!-- RESULTS -->
                    <div id="searchResults"
                        class="absolute left-0 right-0 mt-1 bg-white dark:bg-gray-800 shadow-lg rounded-lg max-h-60 overflow-y-auto hidden z-50">
                    </div>
                </div>
            </div>

        </div>
    </div>

    <div class="content flex flex-col flex-grow px-2 lg:px-8 w-full">
        <!--:Card:-->
        <div class="mb-4 w-full">
            <div class="w-full">
                <div class="w-full">
                    <!--:Card:-->
                    <div
                        class="rounded-xl border border-zinc-200 dark:border-zinc-700 bg-white dark:bg-zinc-900 shadow-card w-full">
                        <div class="px-2 pt-4 flex flex-col lg:flex-row lg:items-center lg:justify-between">
                            <!-- Nav tabs -->
                            <div class="flex flex-wrap gap-2 lg:gap-1" id="myTab" role="tablist">
                                <button
                                    class="flex gap-1 items-center text-sm cursor-pointer px-2 py-1 rounded-md hover:bg-primary-subtle hover:text-primary active [.active]:bg-primary-subtle [.active]:text-primary"
                                    id="revenue-tab" data-bs-toggle="tab" data-bs-target="#revenue" type="button"
                                    role="tab" aria-controls="revenue" aria-selected="true">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24">
                                        <g fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="1">
                                            <circle cx="17" cy="7" r="3" />
                                            <circle cx="7" cy="17" r="3" />
                                            <path
                                                d="M14 14h6v5a1 1 0 0 1-1 1h-4a1 1 0 0 1-1-1zM4 4h6v5a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1z" />
                                        </g>
                                    </svg> All Market</button>
                                <button
                                    class="flex gap-1 items-center text-sm cursor-pointer px-2 py-1 rounded-md hover:bg-primary-subtle hover:text-primary [.active]:bg-primary-subtle [.active]:text-primary"
                                    id="sales-tab" data-bs-toggle="tab" data-bs-target="#sales" type="button" role="tab"
                                    aria-controls="sales" aria-selected="false">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24">
                                        <g fill="none" stroke="currentColor" stroke-width="1">
                                            <path
                                                d="M10.521 7.95v2.927c1.21.076 3.737.067 3.737-1.43S12.132 7.95 10.521 7.95Z" />
                                            <path
                                                d="M13.425 6.432c1.983.19 3.538.778 3.71 2.528c.117 1.276-.438 2.035-1.355 2.463c1.481.359 2.382 1.202 2.196 3.072c-.227 2.343-2.035 2.952-4.62 3.08l.004 2.42l-1.522.002l-.004-2.42c-.389-.005-.819.015-1.25.002l.004 2.42l-1.52.001l-.004-2.42l-3.044-.058l.256-1.768s.724.012 1.129.012c.423-.002.549-.293.58-.485l-.008-3.878l.012-2.76c-.046-.288-.248-.634-.87-.644c.033-.03-1.115.001-1.115.001L6 6.38l3.12-.005l-.004-2.37l1.571-.002l.004 2.37c.403-.01.8-.003 1.205-.001l-.004-2.37L13.422 4z" />
                                            <path
                                                d="M10.5 15.637c.991.036 4.506.247 4.49-1.418c.016-1.713-3.512-1.483-4.49-1.491z" />
                                        </g>
                                    </svg> Cryptocurrency</button>
                                <button
                                    class="flex gap-1 items-center text-sm cursor-pointer px-2 py-1 rounded-md hover:bg-primary-subtle hover:text-primary [.active]:bg-primary-subtle [.active]:text-primary"
                                    id="profit-tab" data-bs-toggle="tab" data-bs-target="#profit" type="button"
                                    role="tab" aria-controls="profit" aria-selected="false">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24">
                                        <g fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="1.5">
                                            <path d="M20 13V8h-5" />
                                            <path
                                                d="m20 8l-5 5c-.883.883-1.324 1.324-1.865 1.373q-.135.012-.27 0c-.541-.05-.982-.49-1.865-1.373s-1.324-1.324-1.865-1.373a1.5 1.5 0 0 0-.27 0c-.541.05-.982.49-1.865 1.373l-3 3" />
                                        </g>
                                    </svg> Stocks</button>
                                <button
                                    class="flex gap-1 items-center text-sm cursor-pointer px-2 py-1 rounded-md hover:bg-primary-subtle hover:text-primary [.active]:bg-primary-subtle [.active]:text-primary"
                                    id="forex-tab" data-bs-toggle="tab" data-bs-target="#forex" type="button" role="tab"
                                    aria-controls="profit" aria-selected="false">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="15" height="15" viewBox="0 0 24 24">
                                        <path fill="currentColor"
                                            d="M14.632 6.898q-.103.132-.323.28l-1.932-.919c.23-.07.563-.115.9-.126c.377-.025.755.024 1.113.146c.27.113.444.349.242.619M9.68 5.414l1.695.803q-.527.167-1.078.204c-.304 0-.793-.09-.945-.394c-.116-.24.106-.458.329-.613" />
                                        <path fill="currentColor" fill-rule="evenodd"
                                            d="M9.948 3.452L5.124 5.656a.725.725 0 0 0-.017 1.316l4.745 2.282a5.04 5.04 0 0 0 4.385-.01l4.661-2.278a.721.721 0 0 0-.017-1.31l-4.733-2.192a5.04 5.04 0 0 0-4.2-.012m4.998 4.459l-.544-.258c-.715.313-1.634.398-2.234.41l-.224-.377l.145-.005c.597-.017 1.251-.037 1.803-.27l-2.046-.97c-.591.196-1.193.358-1.82.323c-.432-.034-1.057-.191-1.293-.602c-.14-.253-.022-.489.169-.686q.157-.156.333-.273l-.609-.289l.45-.225l.596.283c.613-.251 1.322-.283 1.973-.283l.04.298h-.061c-.36 0-1.048-.002-1.524.19l1.807.86a6.6 6.6 0 0 1 1.262-.235c.59-.045 1.192 0 1.647.203c.383.168.703.55.45.972a1.6 1.6 0 0 1-.445.446l.552.263zM3.005 15.556V8.94c0-.804.843-1.338 1.585-1.001l4.886 2.238a3.35 3.35 0 0 1 1.962 3.041v6.657c0 .81-.85 1.344-1.591 1l-4.891-2.282a3.35 3.35 0 0 1-1.951-3.036m5.858 2.434c-.225.141-.45.192-.776.192c-.973 0-2.013-.877-2.519-2.103a5.1 5.1 0 0 1-.348-1.546l-.529-.225l.27-.534l.236.101c.006-.27.028-.545.056-.815l-.562-.242l.27-.529l.388.17l.011-.08c.186-.933.59-1.506 1.462-1.506c.692 0 1.44.506 2.018 1.27a3 3 0 0 1-.309.731c-.348-.73-.877-1.237-1.484-1.237c-.652 0-.973.4-1.13 1.063l2.322.995l-.27.534l-2.159-.928c-.034.265-.056.54-.056.816l1.996.86l-.27.528l-1.681-.725c.045.337.123.675.253.978c.393.973 1.18 1.681 1.95 1.681c.231 0 .411-.045.546-.123c.084.14.197.37.315.674M19.41 7.956c.742-.338 1.585.196 1.585 1.006v6.617a3.35 3.35 0 0 1-1.95 3.036l-4.892 2.277a1.114 1.114 0 0 1-1.591-1v-6.657a3.35 3.35 0 0 1 1.962-3.036zM17.87 10.9l.64-.219l-1.45 4.037v.354l1.124-.562v.562l-1.124.562v.714l1.124-.556v.562l-1.124.562v.962l-.563.303v-.99l-1.124.563v-.562l1.124-.562v-.72l-1.124.562v-.562l1.124-.557v-.281l-1.636-2.704l.619-.36l1.248 2.137z"
                                            clip-rule="evenodd" />
                                    </svg> Forex</button>
                                <button
                                    class="flex gap-1 items-center text-sm cursor-pointer px-2 py-1 rounded-md hover:bg-primary-subtle hover:text-primary [.active]:bg-primary-subtle [.active]:text-primary"
                                    id="commo-tab" data-bs-toggle="tab" data-bs-target="#commo" type="button" role="tab"
                                    aria-controls="profit" aria-selected="false"><svg xmlns="http://www.w3.org/2000/svg"
                                        width="15" height="15" viewBox="0 0 24 24">
                                        <path fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="1.5"
                                            d="m5.226 11.33l6.998-8.983c.547-.703 1.573-.266 1.573.67V9.97c0 .56.402 1.015.899 1.015H18.1c.773 0 1.185 1.03.674 1.686l-6.998 8.983c-.547.702-1.573.265-1.573-.671V14.03c0-.56-.403-1.015-.899-1.015H5.9c-.773 0-1.185-1.03-.674-1.686" />
                                    </svg> Commodities</button>
                                <button
                                    class="flex gap-1 items-center text-sm cursor-pointer px-2 py-1 rounded-md hover:bg-primary-subtle hover:text-primary [.active]:bg-primary-subtle [.active]:text-primary"
                                    id="bond-tab" data-bs-toggle="tab" data-bs-target="#bond" type="button" role="tab"
                                    aria-controls="profit" aria-selected="false">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="14" height="15" viewBox="0 0 24 24">
                                        <path fill="currentColor"
                                            d="M19.505 17.943v-7.581a1.49 1.49 0 0 0 1.39-1.12a1.47 1.47 0 0 0-.7-1.68l-7.45-4.3a1.52 1.52 0 0 0-1.49 0l-7.45 4.3a1.47 1.47 0 0 0-.7 1.68a1.49 1.49 0 0 0 1.45 1.12h.13v7.57h-.12a1.5 1.5 0 0 0 0 3h14.87a1.5 1.5 0 0 0 .07-2.989M4.555 9.362a.505.505 0 0 1-.25-.94l7.45-4.289a.47.47 0 0 1 .49 0L19.7 8.422a.5.5 0 0 1-.25.94Zm13.95 1v7.57H14.9v-7.57Zm-4.61 0v7.57h-3.61v-7.57Zm-4.61 0v7.57h-3.6v-7.57Zm10.15 9.57H4.565a.5.5 0 0 1-.5-.5a.5.5 0 0 1 .5-.5h14.87a.5.5 0 0 1 .5.5a.5.5 0 0 1-.5.5" />
                                    </svg> Bonds</button>
                            </div>
                        </div>
                        <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-3">
                        <!-- Tab panes -->
                        <div class="tab-content">
                            <div class="tab-pane fade show active" id="revenue" role="tabpanel"
                                aria-labelledby="revenue-tab" tabindex="0">
                                <div class="w-full mb-4 mt-4">
                                    <h5 class="text-lg mb-1 mt-3 p-4">Cryptocurrencies</h5>
                                    <div
                                        class=" bg-white dark:bg-zinc-900 shadow-card overflow-hidden hidden lg:block  w-full">
                                        <div class="overflow-x-auto border border-zinc-200 dark:border-zinc-700">
                                            <table class="min-w-full divide-y divide-zinc-200 dark:divide-zinc-700">
                                                <thead
                                                    class="bg-zinc-50 dark:bg-zinc-800 border-b border-zinc-200 dark:border-zinc-700">
                                                    <tr>
                                                        <th
                                                            class="text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Name
                                                        </th>
                                                        <th
                                                            class="md:table-cell text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Price
                                                        </th>
                                                        <th
                                                            class="md:table-cell px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            24h Change
                                                        </th>
                                                        <th
                                                            class="md:table-cell px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Volume
                                                        </th>
                                                        <th
                                                            class="px-4 py-3 text-right text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Action
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody
                                                    class="bg-white dark:bg-zinc-900 divide-y divide-zinc-200 dark:divide-zinc-700">
                                                    @foreach ($crypto as $index => $a)
                                                                                                        <tr
                                                                                                            class="{{ $loop->index % 2 === 0 ? 'bg-white dark:bg-zinc-900' : 'bg-zinc-50 dark:bg-zinc-800' }} hover:bg-zinc-100 dark:hover:bg-zinc-700 transition">
                                                                                                            <!-- Name -->
                                                                                                            <td class="px-4 py-3 whitespace-nowrap">
                                                                                                                <div class="flex items-center gap-3">
                                                                                                                    @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                                                        <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                                            class="w-8 h-8 rounded-full object-cover border border-zinc-200 dark:border-zinc-700">
                                                                                                                    @else
                                                                                                                        <div
                                                                                                                            class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                                                                                                            {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                                                        </div>
                                                                                                                    @endif
                                                                                                                    <div>
                                                                                                                        <div
                                                                                                                            class="font-medium text-zinc-900 dark:text-white">
                                                                                                                            {{ $a['name'] }}
                                                                                                                        </div>
                                                                                                                        <div
                                                                                                                            class="text-xs text-zinc-500 dark:text-zinc-400">
                                                                                                                            {{ $a['pair'] ?? $a['symbol'] }}
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                </div>
                                                                                                            </td>

                                                                                                            <!-- Price -->
                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap font-mono text-sm dark:text-zinc-100">
                                                                                                                {{ isset($a['price']) ? '$' . number_format($a['price'], 2) : '-' }}
                                                                                                            </td>

                                                                                                            <!-- 24h Change -->
                                                                                                            <td class="md:table-cell px-4 py-3 whitespace-nowrap">
                                                                                                                @if (isset($a['change_24h']))
                                                                                                                    <span
                                                                                                                        class="inline-flex items-center font-medium text-sm {{ $a['change_24h'] >= 0 ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                                                                                                                        {{ $a['change_24h'] >= 0 ? '+' : '' }}{{ number_format($a['change_24h'], 2) }}%
                                                                                                                    </span>
                                                                                                                @else
                                                                                                                    <span
                                                                                                                        class="text-zinc-400 dark:text-zinc-500 text-sm">-</span>
                                                                                                                @endif
                                                                                                            </td>

                                                                                                            <!-- Volume -->
                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap text-sm text-zinc-600 dark:text-zinc-300">
                                                                                                                {{ isset($a['volume_24h']) ? number_format($a['volume_24h']) : '-' }}
                                                                                                            </td>

                                                                                                            <!-- Action -->
                                                                                                            <td class="px-4 py-3 text-right whitespace-nowrap">
                                                                                                                <a href="{{ route('user.trade', [
                                                            'symbol' => $a['symbol'],
                                                            'type' => 'crypto',
                                                            'name' => $a['name'],
                                                            'pair' => $a['pair'],
                                                            'price' => $a['price'],
                                                            'logo' => $a['logo'],
                                                            'change_24h' => $a['change_24h'],
                                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-xs font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                                                    <span
                                                                                                                        class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                                                    Trade
                                                                                                                </a>
                                                                                                            </td>
                                                                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- Crypto Mobile Table -->
                                <div class="block lg:hidden space-y-2">
                                    @foreach ($crypto as $index => $a)
                                                                        <div class="overflow-x-auto px-2">
                                                                            <div
                                                                                class="rounded-xl p-4 border border-zinc-200 dark:border-zinc-800 transition-colors duration-300">
                                                                                <!-- Header row: Logo, Name/Price, and Trade button -->
                                                                                <div class="flex items-center justify-between mb-3">
                                                                                    <div class="flex items-center gap-3">
                                                                                        @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                            <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                class="w-10 h-10 object-contain rounded-md border border-gray-200 dark:border-zinc-700">
                                                                                        @else
                                                                                            <div
                                                                                                class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                                                                                {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                            </div>
                                                                                        @endif

                                                                                        <div>
                                                                                            <h6
                                                                                                class="leading-tight font-medium text-gray-800 dark:text-gray-100">
                                                                                                {{ $a['name'] }}
                                                                                                <span class="text-sm text-gray-500">
                                                                                                    -
                                                                                                    {{ isset($a['price']) ? '$' . number_format($a['price'], 2) : '-' }}
                                                                                                </span>
                                                                                            </h6>
                                                                                            <p class="text-xs text-gray-400">
                                                                                                {{ $a['pair'] ?? $a['symbol'] }}
                                                                                            </p>
                                                                                        </div>
                                                                                    </div>

                                                                                    <!-- Trade button -->
                                                                                    <a href="{{ route('user.trade', [
                                            'symbol' => $a['symbol'],
                                            'type' => 'crypto',
                                            'name' => $a['name'],
                                            'pair' => $a['pair'],
                                            'price' => $a['price'],
                                            'logo' => $a['logo'],
                                            'change_24h' => $a['change_24h'],
                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-md font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                        <span class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                        Trade
                                                                                    </a>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                    @endforeach
                                </div>


                                <div class="w-full mb-4 mt-4">
                                    <h5 class="text-lg mt-3 p-4">Stocks</h5>
                                    <div
                                        class=" bg-white dark:bg-zinc-900 shadow-card overflow-hidden hidden lg:block  w-full">
                                        <div class="overflow-x-auto border border-zinc-200 dark:border-zinc-700">
                                            <table class="min-w-full divide-y divide-zinc-200 dark:divide-zinc-700">
                                                <thead
                                                    class="bg-zinc-50 dark:bg-zinc-800 border-b border-zinc-200 dark:border-zinc-700">
                                                    <tr>
                                                        <th
                                                            class="text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Name
                                                        </th>
                                                        <th
                                                            class="md:table-cell text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Price
                                                        </th>
                                                        <th
                                                            class="md:table-cell px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            24h Change
                                                        </th>
                                                        <th
                                                            class="md:table-cell px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Volume
                                                        </th>
                                                        <th
                                                            class="px-4 py-3 text-right text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Action
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody
                                                    class="bg-white dark:bg-zinc-900 divide-y divide-zinc-200 dark:divide-zinc-700">
                                                    @foreach ($stocks as $index => $a)
                                                                                                        @php
                                                                                                            $price = isset($a['price']) ? (float) $a['price'] : null;
                                                                                                            $change = isset($a['change_24h'])
                                                                                                                ? (float) str_replace('%', '', $a['change_24h'])
                                                                                                                : null;
                                                                                                        @endphp

                                                                                                        <tr
                                                                                                            class="{{ $loop->index % 2 === 0 ? 'bg-white dark:bg-zinc-900' : 'bg-zinc-50 dark:bg-zinc-800' }} hover:bg-zinc-100 dark:hover:bg-zinc-700 transition">

                                                                                                            <!-- Name -->
                                                                                                            <td class="px-4 py-3 whitespace-nowrap">
                                                                                                                <div class="flex items-center gap-3">
                                                                                                                    @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                                                        <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                                            class="w-8 h-8 rounded-full object-cover border border-zinc-200 dark:border-zinc-700">
                                                                                                                    @else
                                                                                                                        <div
                                                                                                                            class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                                                                                                            {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                                                        </div>
                                                                                                                    @endif
                                                                                                                    <div>
                                                                                                                        <div
                                                                                                                            class="font-medium text-zinc-900 dark:text-white">
                                                                                                                            {{ $a['name'] }}
                                                                                                                        </div>
                                                                                                                        <div
                                                                                                                            class="text-xs text-zinc-500 dark:text-zinc-400">
                                                                                                                            {{ $a['pair'] ?? $a['symbol'] }}
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                </div>
                                                                                                            </td>
                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap font-mono text-sm dark:text-zinc-100">
                                                                                                                {{ isset($a['price']) ? '$' . number_format((float) $a['price'], 2) : '-' }}
                                                                                                            </td>

                                                                                                            <td class="md:table-cell px-4 py-3 whitespace-nowrap">
                                                                                                                @if (isset($a['change_24h']))
                                                                                                                    <span
                                                                                                                        class="inline-flex items-center font-medium text-sm {{ (float) $a['change_24h'] >= 0 ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                                                                                                                        {{ (float) $a['change_24h'] >= 0 ? '+' : '' }}{{ number_format((float) $a['change_24h'], 2) }}%
                                                                                                                    </span>
                                                                                                                @else
                                                                                                                    <span
                                                                                                                        class="text-zinc-400 dark:text-zinc-500 text-sm">-</span>
                                                                                                                @endif
                                                                                                            </td>

                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap text-sm text-zinc-600 dark:text-zinc-300">
                                                                                                                {{ isset($a['volume_24h']) ? number_format((float) $a['volume_24h']) : '-' }}
                                                                                                            </td>


                                                                                                            <!-- Action -->
                                                                                                            <td class="px-4 py-3 text-right whitespace-nowrap">
                                                                                                                <a href="{{ route('user.trade', [
                                                            'symbol' => $a['symbol'],
                                                            'type' => 'stock',
                                                            'name' => $a['name'],
                                                            'price' => $price,
                                                            'pair' => $a['pair'],
                                                            'logo' => $a['logo'],
                                                            'change_24h' => $change,
                                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-xs font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                                                    <span
                                                                                                                        class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                                                    Trade
                                                                                                                </a>
                                                                                                            </td>
                                                                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- Stock Mobile Table -->
                                <div class="block lg:hidden space-y-2">
                                    @foreach ($stocks as $index => $a)
                                                                        @php
                                                                            $price = isset($a['price']) ? (float) $a['price'] : null;
                                                                            $change = isset($a['change_24h'])
                                                                                ? (float) str_replace('%', '', $a['change_24h'])
                                                                                : null;
                                                                        @endphp
                                                                        <div class="overflow-x-auto px-2">
                                                                            <div
                                                                                class="rounded-xl p-4 border border-zinc-200 dark:border-zinc-800 transition-colors duration-300">
                                                                                <!-- Header row: Logo, Name/Price, and Trade button -->
                                                                                <div class="flex items-center justify-between mb-3">
                                                                                    <div class="flex items-center gap-3">
                                                                                        @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                            <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                class="w-10 h-10 object-contain rounded-md border border-gray-200 dark:border-zinc-700">
                                                                                        @else
                                                                                            <div
                                                                                                class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                                                                                {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                            </div>
                                                                                        @endif

                                                                                        <div>
                                                                                            <h6
                                                                                                class="leading-tight font-medium text-gray-800 dark:text-gray-100">
                                                                                                {{ $a['name'] }}
                                                                                                <span class="text-sm text-gray-500">
                                                                                                    -
                                                                                                    {{ isset($a['price']) ? '$' . number_format((float) $a['price'], 2) : '-' }}
                                                                                                </span>
                                                                                            </h6>
                                                                                            <p class="text-xs text-gray-400">
                                                                                                {{ $a['pair'] ?? $a['symbol'] }}
                                                                                            </p>
                                                                                        </div>
                                                                                    </div>

                                                                                    <!-- Trade button -->
                                                                                    <a href="{{ route('user.trade', [
                                            'symbol' => $a['symbol'],
                                            'type' => 'stock',
                                            'name' => $a['name'],
                                            'price' => $price,
                                            'pair' => $a['pair'],
                                            'logo' => $a['logo'],
                                            'change_24h' => $change,
                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-md font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                        <span class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                        Trade
                                                                                    </a>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                    @endforeach
                                </div>

                                <div class="w-full mb-4 mt-4">
                                    <h5 class="text-lg mt-3 p-4">Forex</h5>
                                    <div
                                        class=" bg-white dark:bg-zinc-900 shadow-card overflow-hidden hidden lg:block  w-full">
                                        <div class="overflow-x-auto border border-zinc-200 dark:border-zinc-700">
                                            <table class="min-w-full divide-y divide-zinc-200 dark:divide-zinc-700">
                                                <thead
                                                    class="bg-zinc-50 dark:bg-zinc-800 border-b border-zinc-200 dark:border-zinc-700">
                                                    <tr>
                                                        <th
                                                            class="text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Name
                                                        </th>
                                                        <th
                                                            class="md:table-cell text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Price
                                                        </th>
                                                        <th
                                                            class="md:table-cell px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            24h Change
                                                        </th>
                                                        <th
                                                            class="md:table-cell px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Volume
                                                        </th>
                                                        <th
                                                            class="px-4 py-3 text-right text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Action
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody
                                                    class="bg-white dark:bg-zinc-900 divide-y divide-zinc-200 dark:divide-zinc-700">
                                                    @foreach ($forex as $index => $a)
                                                                                                        @php
                                                                                                            $price = isset($a['price']) ? (float) $a['price'] : null;
                                                                                                            $change = isset($a['change_24h'])
                                                                                                                ? (float) str_replace('%', '', $a['change_24h'])
                                                                                                                : null;
                                                                                                        @endphp

                                                                                                        <tr
                                                                                                            class="{{ $loop->index % 2 === 0 ? 'bg-white dark:bg-zinc-900' : 'bg-zinc-50 dark:bg-zinc-800' }} hover:bg-zinc-100 dark:hover:bg-zinc-700 transition">

                                                                                                            <!-- Name -->
                                                                                                            <td class="px-4 py-3 whitespace-nowrap">
                                                                                                                <div class="flex items-center gap-3">
                                                                                                                    @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                                                        <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                                            class="w-8 h-8 rounded-full object-cover border border-zinc-200 dark:border-zinc-700">
                                                                                                                    @else
                                                                                                                        <div
                                                                                                                            class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                                                                                                            {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                                                        </div>
                                                                                                                    @endif
                                                                                                                    <div>
                                                                                                                        <div
                                                                                                                            class="font-medium text-zinc-900 dark:text-white">
                                                                                                                            {{ $a['name'] }}
                                                                                                                        </div>
                                                                                                                        <div
                                                                                                                            class="text-xs text-zinc-500 dark:text-zinc-400">
                                                                                                                            {{ $a['pair'] ?? $a['symbol'] }}
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                </div>
                                                                                                            </td>
                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap font-mono text-sm dark:text-zinc-100">
                                                                                                                {{ isset($a['price']) ? '$' . number_format((float) $a['price'], 2) : '-' }}
                                                                                                            </td>

                                                                                                            <td class="md:table-cell px-4 py-3 whitespace-nowrap">
                                                                                                                @if (isset($a['change_24h']))
                                                                                                                    <span
                                                                                                                        class="inline-flex items-center font-medium text-sm {{ (float) $a['change_24h'] >= 0 ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                                                                                                                        {{ (float) $a['change_24h'] >= 0 ? '+' : '' }}{{ number_format((float) $a['change_24h'], 2) }}%
                                                                                                                    </span>
                                                                                                                @else
                                                                                                                    <span
                                                                                                                        class="text-zinc-400 dark:text-zinc-500 text-sm">-</span>
                                                                                                                @endif
                                                                                                            </td>

                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap text-sm text-zinc-600 dark:text-zinc-300">
                                                                                                                {{ isset($a['volume_24h']) ? number_format((float) $a['volume_24h']) : '-' }}
                                                                                                            </td>


                                                                                                            <!-- Action -->
                                                                                                            <td class="px-4 py-3 text-right whitespace-nowrap">
                                                                                                                <a href="{{ route('user.trade', [
                                                            'symbol' => $a['symbol'],
                                                            'type' => 'forex',
                                                            'name' => $a['name'],
                                                            'price' => $price,
                                                            'pair' => $a['pair'],
                                                            'logo' => $a['logo'],
                                                            'change_24h' => $change,
                                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-xs font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                                                    <span
                                                                                                                        class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                                                    Trade
                                                                                                                </a>
                                                                                                            </td>
                                                                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- Forex Mobile Table -->
                                <div class="block lg:hidden space-y-2">
                                    @foreach ($forex as $index => $a)
                                                                        @php
                                                                            $price = isset($a['price']) ? (float) $a['price'] : null;
                                                                            $change = isset($a['change_24h'])
                                                                                ? (float) str_replace('%', '', $a['change_24h'])
                                                                                : null;
                                                                        @endphp
                                                                        <div class="overflow-x-auto px-2">
                                                                            <div
                                                                                class="rounded-xl p-4 border border-zinc-200 dark:border-zinc-800 transition-colors duration-300">
                                                                                <!-- Header row: Logo, Name/Price, and Trade button -->
                                                                                <div class="flex items-center justify-between mb-3">
                                                                                    <div class="flex items-center gap-3">
                                                                                        @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                            <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                class="w-10 h-10 object-contain rounded-md border border-gray-200 dark:border-zinc-700">
                                                                                        @else
                                                                                            <div
                                                                                                class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                                                                                {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                            </div>
                                                                                        @endif

                                                                                        <div>
                                                                                            <h6
                                                                                                class="leading-tight font-medium text-gray-800 dark:text-gray-100">
                                                                                                {{ $a['name'] }}
                                                                                                <span class="text-sm text-gray-500">
                                                                                                    -
                                                                                                    {{ isset($a['price']) ? '$' . number_format((float) $a['price'], 2) : '-' }}
                                                                                                </span>
                                                                                            </h6>
                                                                                            <p class="text-xs text-gray-400">
                                                                                                {{ $a['pair'] ?? $a['symbol'] }}
                                                                                            </p>
                                                                                        </div>
                                                                                    </div>

                                                                                    <!-- Trade button -->
                                                                                    <a href="{{ route('user.trade', [
                                            'symbol' => $a['symbol'],
                                            'type' => 'forex',
                                            'name' => $a['name'],
                                            'price' => $price,
                                            'pair' => $a['pair'],
                                            'logo' => $a['logo'],
                                            'change_24h' => $change,
                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-md font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                        <span class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                        Trade
                                                                                    </a>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                    @endforeach
                                </div>

                                <div class="w-full mb-4 mt-4">
                                    <h5 class="text-lg mt-3 p-4">Commodities</h5>
                                    <div
                                        class=" bg-white dark:bg-zinc-900 shadow-card overflow-hidden hidden lg:block  w-full">
                                        <div class="overflow-x-auto border border-zinc-200 dark:border-zinc-700">
                                            <table class="min-w-full divide-y divide-zinc-200 dark:divide-zinc-700">
                                                <thead
                                                    class="bg-zinc-50 dark:bg-zinc-800 border-b border-zinc-200 dark:border-zinc-700">
                                                    <tr>
                                                        <th
                                                            class="text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Name
                                                        </th>
                                                        <th
                                                            class="md:table-cell text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Price
                                                        </th>
                                                        <th
                                                            class="md:table-cell px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            24h Change
                                                        </th>
                                                        <th
                                                            class="md:table-cell px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Volume
                                                        </th>
                                                        <th
                                                            class="px-4 py-3 text-right text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Action
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody
                                                    class="bg-white dark:bg-zinc-900 divide-y divide-zinc-200 dark:divide-zinc-700">
                                                    @foreach ($commodities as $index => $a)
                                                                                                        @php
                                                                                                            $price = isset($a['price']) ? (float) $a['price'] : null;
                                                                                                            $change = isset($a['change_24h'])
                                                                                                                ? (float) str_replace('%', '', $a['change_24h'])
                                                                                                                : null;
                                                                                                        @endphp

                                                                                                        <tr
                                                                                                            class="{{ $loop->index % 2 === 0 ? 'bg-white dark:bg-zinc-900' : 'bg-zinc-50 dark:bg-zinc-800' }} hover:bg-zinc-100 dark:hover:bg-zinc-700 transition">

                                                                                                            <!-- Name -->
                                                                                                            <td class="px-4 py-3 whitespace-nowrap">
                                                                                                                <div class="flex items-center gap-3">
                                                                                                                    @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                                                        <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                                            class="w-8 h-8 rounded-full object-cover border border-zinc-200 dark:border-zinc-700">
                                                                                                                    @else
                                                                                                                        <div
                                                                                                                            class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                                                                                                            {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                                                        </div>
                                                                                                                    @endif
                                                                                                                    <div>
                                                                                                                        <div
                                                                                                                            class="font-medium text-zinc-900 dark:text-white">
                                                                                                                            {{ $a['name'] }}
                                                                                                                        </div>
                                                                                                                        <div
                                                                                                                            class="text-xs text-zinc-500 dark:text-zinc-400">
                                                                                                                            {{ $a['pair'] ?? $a['symbol'] }}
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                </div>
                                                                                                            </td>
                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap font-mono text-sm dark:text-zinc-100">
                                                                                                                {{ isset($a['price']) ? '$' . number_format((float) $a['price'], 2) : '-' }}
                                                                                                            </td>

                                                                                                            <td class="md:table-cell px-4 py-3 whitespace-nowrap">
                                                                                                                @if (isset($a['change_24h']))
                                                                                                                    <span
                                                                                                                        class="inline-flex items-center font-medium text-sm {{ (float) $a['change_24h'] >= 0 ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                                                                                                                        {{ (float) $a['change_24h'] >= 0 ? '+' : '' }}{{ number_format((float) $a['change_24h'], 2) }}%
                                                                                                                    </span>
                                                                                                                @else
                                                                                                                    <span
                                                                                                                        class="text-zinc-400 dark:text-zinc-500 text-sm">-</span>
                                                                                                                @endif
                                                                                                            </td>

                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap text-sm text-zinc-600 dark:text-zinc-300">
                                                                                                                {{ isset($a['volume_24h']) ? number_format((float) $a['volume_24h']) : '-' }}
                                                                                                            </td>


                                                                                                            <!-- Action -->
                                                                                                            <td class="px-4 py-3 text-right whitespace-nowrap">
                                                                                                                <a href="{{ route('user.trade', [
                                                            'symbol' => $a['symbol'],
                                                            'type' => 'commodity',
                                                            'name' => $a['name'],
                                                            'price' => $price,
                                                            'pair' => $a['pair'],
                                                            'logo' => $a['logo'],
                                                            'change_24h' => $change,
                                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-xs font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                                                    <span
                                                                                                                        class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                                                    Trade
                                                                                                                </a>
                                                                                                            </td>
                                                                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- Commodities Mobile Table -->
                                <div class="block lg:hidden space-y-2">
                                    @foreach ($commodities as $index => $a)
                                                                        @php
                                                                            $price = isset($a['price']) ? (float) $a['price'] : null;
                                                                            $change = isset($a['change_24h'])
                                                                                ? (float) str_replace('%', '', $a['change_24h'])
                                                                                : null;
                                                                        @endphp
                                                                        <div class="overflow-x-auto px-2">
                                                                            <div
                                                                                class="rounded-xl p-4 border border-zinc-200 dark:border-zinc-800 transition-colors duration-300">
                                                                                <!-- Header row: Logo, Name/Price, and Trade button -->
                                                                                <div class="flex items-center justify-between mb-3">
                                                                                    <div class="flex items-center gap-3">
                                                                                        @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                            <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                class="w-10 h-10 object-contain rounded-md border border-gray-200 dark:border-zinc-700">
                                                                                        @else
                                                                                            <div
                                                                                                class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                                                                                {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                            </div>
                                                                                        @endif

                                                                                        <div>
                                                                                            <h6
                                                                                                class="leading-tight font-medium text-gray-800 dark:text-gray-100">
                                                                                                {{ $a['name'] }}
                                                                                                <span class="text-sm text-gray-500">
                                                                                                    -
                                                                                                    {{ isset($a['price']) ? '$' . number_format((float) $a['price'], 2) : '-' }}
                                                                                                </span>
                                                                                            </h6>
                                                                                            <p class="text-xs text-gray-400">
                                                                                                {{ $a['pair'] ?? $a['symbol'] }}
                                                                                            </p>
                                                                                        </div>
                                                                                    </div>

                                                                                    <!-- Trade button -->
                                                                                    <a href="{{ route('user.trade', [
                                            'symbol' => $a['symbol'],
                                            'type' => 'commodity',
                                            'name' => $a['name'],
                                            'price' => $price,
                                            'pair' => $a['pair'],
                                            'logo' => $a['logo'],
                                            'change_24h' => $change,
                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-md font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                        <span class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                        Trade
                                                                                    </a>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                    @endforeach
                                </div>

                                <div class="w-full mb-4 mt-4">
                                    <h5 class="text-lg mt-3 p-4">Bonds</h5>
                                    <div
                                        class=" bg-white dark:bg-zinc-900 shadow-card overflow-hidden hidden lg:block  w-full">
                                        <div class="overflow-x-auto border border-zinc-200 dark:border-zinc-700">
                                            <table class="min-w-full divide-y divide-zinc-200 dark:divide-zinc-700">
                                                <thead
                                                    class="bg-zinc-50 dark:bg-zinc-800 border-b border-zinc-200 dark:border-zinc-700">
                                                    <tr>
                                                        <th
                                                            class="text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Name
                                                        </th>
                                                        <th
                                                            class="md:table-cell text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Price
                                                        </th>
                                                        <th
                                                            class="md:table-cell px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            24h Change
                                                        </th>
                                                        <th
                                                            class="px-4 py-3 text-right text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Action
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody
                                                    class="bg-white dark:bg-zinc-900 divide-y divide-zinc-200 dark:divide-zinc-700">
                                                    @foreach ($bonds as $index => $a)
                                                                                                        <tr
                                                                                                            class="{{ $loop->index % 2 === 0 ? 'bg-white dark:bg-zinc-900' : 'bg-zinc-50 dark:bg-zinc-800' }} hover:bg-zinc-100 dark:hover:bg-zinc-700 transition">
                                                                                                            <!-- Name -->
                                                                                                            <td class="px-4 py-3 whitespace-nowrap">
                                                                                                                <div class="flex items-center gap-3">
                                                                                                                    @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                                                        <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                                            class="w-8 h-8 rounded-full object-cover border border-zinc-200 dark:border-zinc-700">
                                                                                                                    @else
                                                                                                                        <span
                                                                                                                            class="inline-flex w-8 h-8 rounded-full items-center justify-center bg-gradient-to-br from-indigo-500 to-purple-600 text-white text-xs font-bold border border-zinc-200 dark:border-zinc-700">
                                                                                                                            {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                                                        </span>
                                                                                                                    @endif

                                                                                                                    <div>
                                                                                                                        <div
                                                                                                                            class="font-medium text-zinc-900 dark:text-white">
                                                                                                                            {{ $a['name'] }}
                                                                                                                        </div>
                                                                                                                        <div
                                                                                                                            class="text-xs text-zinc-500 dark:text-zinc-400">
                                                                                                                            {{ $a['pair'] ?? $a['symbol'] }}
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                </div>
                                                                                                            </td>

                                                                                                            <!-- Price -->
                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap font-mono text-sm dark:text-zinc-100">
                                                                                                                {{ isset($a['price']) ? '$' . number_format($a['price'], 2) : '-' }}
                                                                                                            </td>

                                                                                                            <!-- 24h Change -->
                                                                                                            {{-- <td class="md:table-cell px-4 py-3 whitespace-nowrap">
                                                                                                                @if (isset($a['change_24h']))
                                                                                                                <span
                                                                                                                    class="inline-flex items-center font-medium text-sm {{ $a['change_24h'] >= 0 ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                                                                                                                    {{ $a['change_24h'] >= 0 ? '+' : '' }}{{
                                                                                                                    number_format($a['change_24h'], 2) }}%
                                                                                                                </span>
                                                                                                                @else
                                                                                                                <span
                                                                                                                    class="text-zinc-400 dark:text-zinc-500 text-sm">-</span>
                                                                                                                @endif
                                                                                                            </td> --}}

                                                                                                            <!-- Volume -->
                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap text-sm text-zinc-600 dark:text-zinc-300">
                                                                                                                {{ isset($a['volume_24h']) ? number_format($a['volume_24h']) : '-' }}
                                                                                                            </td>

                                                                                                            <!-- Action -->
                                                                                                            <td class="px-4 py-3 text-right whitespace-nowrap">
                                                                                                                <a href="{{ route('user.trade', [
                                                            'symbol' => $a['symbol'],
                                                            'type' => 'bond',
                                                            'name' => $a['name'],
                                                            'price' => $a['price'],
                                                            'pair' => $a['pair'],
                                                            'logo' => $a['logo'],
                                                            'change_24h' => $a['change_24h'],
                                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-xs font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                                                    <span
                                                                                                                        class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                                                    Trade
                                                                                                                </a>
                                                                                                            </td>
                                                                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- Bonds Mobile Table -->
                                <div class="block lg:hidden space-y-2">
                                    @foreach ($bonds as $index => $a)
                                                                        @php
                                                                            $price = isset($a['price']) ? (float) $a['price'] : null;
                                                                            $change = isset($a['change_24h'])
                                                                                ? (float) str_replace('%', '', $a['change_24h'])
                                                                                : null;
                                                                        @endphp
                                                                        <div class="overflow-x-auto px-2">
                                                                            <div
                                                                                class="rounded-xl p-4 border border-zinc-200 dark:border-zinc-800 transition-colors duration-300">
                                                                                <!-- Header row: Logo, Name/Price, and Trade button -->
                                                                                <div class="flex items-center justify-between mb-3">
                                                                                    <div class="flex items-center gap-3">
                                                                                        @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                            <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                class="w-10 h-10 object-contain rounded-md border border-gray-200 dark:border-zinc-700">
                                                                                        @else
                                                                                            <div
                                                                                                class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                                                                                {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                            </div>
                                                                                        @endif

                                                                                        <div>
                                                                                            <h6
                                                                                                class="leading-tight font-medium text-gray-800 dark:text-gray-100">
                                                                                                {{ $a['name'] }}
                                                                                                <span class="text-sm text-gray-500">
                                                                                                    -
                                                                                                    {{ isset($a['price']) ? '$' . number_format((float) $a['price'], 2) : '-' }}
                                                                                                </span>
                                                                                            </h6>
                                                                                            <p class="text-xs text-gray-400">
                                                                                                {{ $a['pair'] ?? $a['symbol'] }}
                                                                                            </p>
                                                                                        </div>
                                                                                    </div>

                                                                                    <!-- Trade button -->
                                                                                    <a href="{{ route('user.trade', [
                                            'symbol' => $a['symbol'],
                                            'type' => 'bond',
                                            'name' => $a['name'],
                                            'price' => $a['price'],
                                            'pair' => $a['pair'],
                                            'logo' => $a['logo'],
                                            'change_24h' => $a['change_24h'],
                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-md font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                        <span class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                        Trade
                                                                                    </a>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                    @endforeach
                                </div>
                            </div>

                            <div class="tab-pane fade" id="sales" role="tabpanel" aria-labelledby="sales-tab"
                                tabindex="0">
                                <div class="w-full mb-4 mt-4">
                                    <h5 class="text-lg mb-1 mt-3 p-4">Cryptocurrencies</h5>
                                    <div
                                        class=" bg-white dark:bg-zinc-900 shadow-card overflow-hidden hidden lg:block  w-full">
                                        <div class="overflow-x-auto border border-zinc-200 dark:border-zinc-700">
                                            <table class="min-w-full divide-y divide-zinc-200 dark:divide-zinc-700">
                                                <thead
                                                    class="bg-zinc-50 dark:bg-zinc-800 border-b border-zinc-200 dark:border-zinc-700">
                                                    <tr>
                                                        <th
                                                            class="text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Name
                                                        </th>
                                                        <th
                                                            class="md:table-cell text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Price
                                                        </th>
                                                        <th
                                                            class="md:table-cell px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            24h Change
                                                        </th>
                                                        <th
                                                            class="md:table-cell px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Volume
                                                        </th>
                                                        <th
                                                            class="px-4 py-3 text-right text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Action
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody
                                                    class="bg-white dark:bg-zinc-900 divide-y divide-zinc-200 dark:divide-zinc-700">
                                                    @foreach ($crypto as $index => $a)
                                                                                                        <tr
                                                                                                            class="{{ $loop->index % 2 === 0 ? 'bg-white dark:bg-zinc-900' : 'bg-zinc-50 dark:bg-zinc-800' }} hover:bg-zinc-100 dark:hover:bg-zinc-700 transition">
                                                                                                            <!-- Name -->
                                                                                                            <td class="px-4 py-3 whitespace-nowrap">
                                                                                                                <div class="flex items-center gap-3">
                                                                                                                    @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                                                        <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                                            class="w-8 h-8 rounded-full object-cover border border-zinc-200 dark:border-zinc-700">
                                                                                                                    @else
                                                                                                                        <div
                                                                                                                            class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                                                                                                            {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                                                        </div>
                                                                                                                    @endif
                                                                                                                    <div>
                                                                                                                        <div
                                                                                                                            class="font-medium text-zinc-900 dark:text-white">
                                                                                                                            {{ $a['name'] }}
                                                                                                                        </div>
                                                                                                                        <div
                                                                                                                            class="text-xs text-zinc-500 dark:text-zinc-400">
                                                                                                                            {{ $a['pair'] ?? $a['symbol'] }}
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                </div>
                                                                                                            </td>

                                                                                                            <!-- Price -->
                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap font-mono text-sm dark:text-zinc-100">
                                                                                                                {{ isset($a['price']) ? '$' . number_format($a['price'], 2) : '-' }}
                                                                                                            </td>

                                                                                                            <!-- 24h Change -->
                                                                                                            <td class="md:table-cell px-4 py-3 whitespace-nowrap">
                                                                                                                @if (isset($a['change_24h']))
                                                                                                                    <span
                                                                                                                        class="inline-flex items-center font-medium text-sm {{ $a['change_24h'] >= 0 ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                                                                                                                        {{ $a['change_24h'] >= 0 ? '+' : '' }}{{ number_format($a['change_24h'], 2) }}%
                                                                                                                    </span>
                                                                                                                @else
                                                                                                                    <span
                                                                                                                        class="text-zinc-400 dark:text-zinc-500 text-sm">-</span>
                                                                                                                @endif
                                                                                                            </td>

                                                                                                            <!-- Volume -->
                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap text-sm text-zinc-600 dark:text-zinc-300">
                                                                                                                {{ isset($a['volume_24h']) ? number_format($a['volume_24h']) : '-' }}
                                                                                                            </td>

                                                                                                            <!-- Action -->
                                                                                                            <td class="px-4 py-3 text-right whitespace-nowrap">
                                                                                                                <a href="{{ route('user.trade', [
                                                            'symbol' => $a['symbol'],
                                                            'type' => 'crypto',
                                                            'name' => $a['name'],
                                                            'pair' => $a['pair'],
                                                            'price' => $a['price'],
                                                            'logo' => $a['logo'],
                                                            'change_24h' => $a['change_24h'],
                                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-xs font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                                                    <span
                                                                                                                        class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                                                    Trade
                                                                                                                </a>
                                                                                                            </td>
                                                                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- Crypto Mobile Table -->
                                <div class="block lg:hidden space-y-2">
                                    @foreach ($crypto as $index => $a)
                                                                        <div class="overflow-x-auto px-2">
                                                                            <div
                                                                                class="rounded-xl p-4 border border-zinc-200 dark:border-zinc-800 transition-colors duration-300">
                                                                                <!-- Header row: Logo, Name/Price, and Trade button -->
                                                                                <div class="flex items-center justify-between mb-3">
                                                                                    <div class="flex items-center gap-3">
                                                                                        @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                            <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                class="w-10 h-10 object-contain rounded-md border border-gray-200 dark:border-zinc-700">
                                                                                        @else
                                                                                            <div
                                                                                                class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                                                                                {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                            </div>
                                                                                        @endif

                                                                                        <div>
                                                                                            <h6
                                                                                                class="leading-tight font-medium text-gray-800 dark:text-gray-100">
                                                                                                {{ $a['name'] }}
                                                                                                <span class="text-sm text-gray-500">
                                                                                                    -
                                                                                                    {{ isset($a['price']) ? '$' . number_format($a['price'], 2) : '-' }}
                                                                                                </span>
                                                                                            </h6>
                                                                                            <p class="text-xs text-gray-400">
                                                                                                {{ $a['pair'] ?? $a['symbol'] }}
                                                                                            </p>
                                                                                        </div>
                                                                                    </div>

                                                                                    <!-- Trade button -->
                                                                                    <a href="{{ route('user.trade', [
                                            'symbol' => $a['symbol'],
                                            'type' => 'crypto',
                                            'name' => $a['name'],
                                            'pair' => $a['pair'],
                                            'price' => $a['price'],
                                            'logo' => $a['logo'],
                                            'change_24h' => $a['change_24h'],
                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-md font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                        <span class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                        Trade
                                                                                    </a>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                    @endforeach
                                </div>
                            </div>

                            <div class="tab-pane fade" id="profit" role="tabpanel" aria-labelledby="profit-tab"
                                tabindex="0">
                                <div class="w-full mb-4 mt-4">
                                    <h5 class="text-lg mt-3 p-4">Stocks</h5>
                                    <div
                                        class=" bg-white dark:bg-zinc-900 shadow-card overflow-hidden hidden lg:block  w-full">
                                        <div class="overflow-x-auto border border-zinc-200 dark:border-zinc-700">
                                            <table class="min-w-full divide-y divide-zinc-200 dark:divide-zinc-700">
                                                <thead
                                                    class="bg-zinc-50 dark:bg-zinc-800 border-b border-zinc-200 dark:border-zinc-700">
                                                    <tr>
                                                        <th
                                                            class="text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Name
                                                        </th>
                                                        <th
                                                            class="md:table-cell text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Price
                                                        </th>
                                                        <th
                                                            class="md:table-cell px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            24h Change
                                                        </th>
                                                        <th
                                                            class="md:table-cell px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Volume
                                                        </th>
                                                        <th
                                                            class="px-4 py-3 text-right text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Action
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody
                                                    class="bg-white dark:bg-zinc-900 divide-y divide-zinc-200 dark:divide-zinc-700">
                                                    @foreach ($stocks as $index => $a)
                                                                                                        @php
                                                                                                            $price = isset($a['price']) ? (float) $a['price'] : null;
                                                                                                            $change = isset($a['change_24h'])
                                                                                                                ? (float) str_replace('%', '', $a['change_24h'])
                                                                                                                : null;
                                                                                                        @endphp

                                                                                                        <tr
                                                                                                            class="{{ $loop->index % 2 === 0 ? 'bg-white dark:bg-zinc-900' : 'bg-zinc-50 dark:bg-zinc-800' }} hover:bg-zinc-100 dark:hover:bg-zinc-700 transition">

                                                                                                            <!-- Name -->
                                                                                                            <td class="px-4 py-3 whitespace-nowrap">
                                                                                                                <div class="flex items-center gap-3">
                                                                                                                    @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                                                        <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                                            class="w-8 h-8 rounded-full object-cover border border-zinc-200 dark:border-zinc-700">
                                                                                                                    @else
                                                                                                                        <div
                                                                                                                            class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                                                                                                            {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                                                        </div>
                                                                                                                    @endif
                                                                                                                    <div>
                                                                                                                        <div
                                                                                                                            class="font-medium text-zinc-900 dark:text-white">
                                                                                                                            {{ $a['name'] }}
                                                                                                                        </div>
                                                                                                                        <div
                                                                                                                            class="text-xs text-zinc-500 dark:text-zinc-400">
                                                                                                                            {{ $a['pair'] ?? $a['symbol'] }}
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                </div>
                                                                                                            </td>
                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap font-mono text-sm dark:text-zinc-100">
                                                                                                                {{ isset($a['price']) ? '$' . number_format((float) $a['price'], 2) : '-' }}
                                                                                                            </td>

                                                                                                            <td class="md:table-cell px-4 py-3 whitespace-nowrap">
                                                                                                                @if (isset($a['change_24h']))
                                                                                                                    <span
                                                                                                                        class="inline-flex items-center font-medium text-sm {{ (float) $a['change_24h'] >= 0 ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                                                                                                                        {{ (float) $a['change_24h'] >= 0 ? '+' : '' }}{{ number_format((float) $a['change_24h'], 2) }}%
                                                                                                                    </span>
                                                                                                                @else
                                                                                                                    <span
                                                                                                                        class="text-zinc-400 dark:text-zinc-500 text-sm">-</span>
                                                                                                                @endif
                                                                                                            </td>

                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap text-sm text-zinc-600 dark:text-zinc-300">
                                                                                                                {{ isset($a['volume_24h']) ? number_format((float) $a['volume_24h']) : '-' }}
                                                                                                            </td>


                                                                                                            <!-- Action -->
                                                                                                            <td class="px-4 py-3 text-right whitespace-nowrap">
                                                                                                                <a href="{{ route('user.trade', [
                                                            'symbol' => $a['symbol'],
                                                            'type' => 'stock',
                                                            'name' => $a['name'],
                                                            'price' => $price,
                                                            'pair' => $a['pair'],
                                                            'logo' => $a['logo'],
                                                            'change_24h' => $change,
                                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-xs font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                                                    <span
                                                                                                                        class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                                                    Trade
                                                                                                                </a>
                                                                                                            </td>
                                                                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- Stock Mobile Table -->
                                <div class="block lg:hidden space-y-2">
                                    @foreach ($stocks as $index => $a)
                                                                        @php
                                                                            $price = isset($a['price']) ? (float) $a['price'] : null;
                                                                            $change = isset($a['change_24h'])
                                                                                ? (float) str_replace('%', '', $a['change_24h'])
                                                                                : null;
                                                                        @endphp
                                                                        <div class="overflow-x-auto px-2">
                                                                            <div
                                                                                class="rounded-xl p-4 border border-zinc-200 dark:border-zinc-800 transition-colors duration-300">
                                                                                <!-- Header row: Logo, Name/Price, and Trade button -->
                                                                                <div class="flex items-center justify-between mb-3">
                                                                                    <div class="flex items-center gap-3">
                                                                                        @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                            <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                class="w-10 h-10 object-contain rounded-md border border-gray-200 dark:border-zinc-700">
                                                                                        @else
                                                                                            <div
                                                                                                class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                                                                                {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                            </div>
                                                                                        @endif

                                                                                        <div>
                                                                                            <h6
                                                                                                class="leading-tight font-medium text-gray-800 dark:text-gray-100">
                                                                                                {{ $a['name'] }}
                                                                                                <span class="text-sm text-gray-500">
                                                                                                    -
                                                                                                    {{ isset($a['price']) ? '$' . number_format((float) $a['price'], 2) : '-' }}
                                                                                                </span>
                                                                                            </h6>
                                                                                            <p class="text-xs text-gray-400">
                                                                                                {{ $a['pair'] ?? $a['symbol'] }}
                                                                                            </p>
                                                                                        </div>
                                                                                    </div>

                                                                                    <!-- Trade button -->
                                                                                    <a href="{{ route('user.trade', [
                                            'symbol' => $a['symbol'],
                                            'type' => 'stock',
                                            'name' => $a['name'],
                                            'price' => $price,
                                            'pair' => $a['pair'],
                                            'logo' => $a['logo'],
                                            'change_24h' => $change,
                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-md font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                        <span class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                        Trade
                                                                                    </a>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                    @endforeach
                                </div>
                            </div>

                            <div class="tab-pane fade" id="forex" role="tabpanel" aria-labelledby="forex-tab"
                                tabindex="0">
                                <div class="w-full mb-4 mt-4">
                                    <h5 class="text-lg mt-3 p-4">Forex</h5>
                                    <div
                                        class=" bg-white dark:bg-zinc-900 shadow-card overflow-hidden hidden lg:block  w-full">
                                        <div class="overflow-x-auto border border-zinc-200 dark:border-zinc-700">
                                            <table class="min-w-full divide-y divide-zinc-200 dark:divide-zinc-700">
                                                <thead
                                                    class="bg-zinc-50 dark:bg-zinc-800 border-b border-zinc-200 dark:border-zinc-700">
                                                    <tr>
                                                        <th
                                                            class="text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Name
                                                        </th>
                                                        <th
                                                            class="md:table-cell text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Price
                                                        </th>
                                                        <th
                                                            class="md:table-cell px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            24h Change
                                                        </th>
                                                        <th
                                                            class="md:table-cell px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Volume
                                                        </th>
                                                        <th
                                                            class="px-4 py-3 text-right text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Action
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody
                                                    class="bg-white dark:bg-zinc-900 divide-y divide-zinc-200 dark:divide-zinc-700">
                                                    @foreach ($forex as $index => $a)
                                                                                                        @php
                                                                                                            $price = isset($a['price']) ? (float) $a['price'] : null;
                                                                                                            $change = isset($a['change_24h'])
                                                                                                                ? (float) str_replace('%', '', $a['change_24h'])
                                                                                                                : null;
                                                                                                        @endphp

                                                                                                        <tr
                                                                                                            class="{{ $loop->index % 2 === 0 ? 'bg-white dark:bg-zinc-900' : 'bg-zinc-50 dark:bg-zinc-800' }} hover:bg-zinc-100 dark:hover:bg-zinc-700 transition">

                                                                                                            <!-- Name -->
                                                                                                            <td class="px-4 py-3 whitespace-nowrap">
                                                                                                                <div class="flex items-center gap-3">
                                                                                                                    @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                                                        <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                                            class="w-8 h-8 rounded-full object-cover border border-zinc-200 dark:border-zinc-700">
                                                                                                                    @else
                                                                                                                        <div
                                                                                                                            class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                                                                                                            {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                                                        </div>
                                                                                                                    @endif
                                                                                                                    <div>
                                                                                                                        <div
                                                                                                                            class="font-medium text-zinc-900 dark:text-white">
                                                                                                                            {{ $a['name'] }}
                                                                                                                        </div>
                                                                                                                        <div
                                                                                                                            class="text-xs text-zinc-500 dark:text-zinc-400">
                                                                                                                            {{ $a['pair'] ?? $a['symbol'] }}
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                </div>
                                                                                                            </td>
                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap font-mono text-sm dark:text-zinc-100">
                                                                                                                {{ isset($a['price']) ? '$' . number_format((float) $a['price'], 2) : '-' }}
                                                                                                            </td>

                                                                                                            <td class="md:table-cell px-4 py-3 whitespace-nowrap">
                                                                                                                @if (isset($a['change_24h']))
                                                                                                                    <span
                                                                                                                        class="inline-flex items-center font-medium text-sm {{ (float) $a['change_24h'] >= 0 ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                                                                                                                        {{ (float) $a['change_24h'] >= 0 ? '+' : '' }}{{ number_format((float) $a['change_24h'], 2) }}%
                                                                                                                    </span>
                                                                                                                @else
                                                                                                                    <span
                                                                                                                        class="text-zinc-400 dark:text-zinc-500 text-sm">-</span>
                                                                                                                @endif
                                                                                                            </td>

                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap text-sm text-zinc-600 dark:text-zinc-300">
                                                                                                                {{ isset($a['volume_24h']) ? number_format((float) $a['volume_24h']) : '-' }}
                                                                                                            </td>


                                                                                                            <!-- Action -->
                                                                                                            <td class="px-4 py-3 text-right whitespace-nowrap">
                                                                                                                <a href="{{ route('user.trade', [
                                                            'symbol' => $a['symbol'],
                                                            'type' => 'forex',
                                                            'name' => $a['name'],
                                                            'price' => $price,
                                                            'pair' => $a['pair'],
                                                            'logo' => $a['logo'],
                                                            'change_24h' => $change,
                                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-xs font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                                                    <span
                                                                                                                        class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                                                    Trade
                                                                                                                </a>
                                                                                                            </td>
                                                                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- Forex Mobile Table -->
                                <div class="block lg:hidden space-y-2">
                                    @foreach ($forex as $index => $a)
                                                                        @php
                                                                            $price = isset($a['price']) ? (float) $a['price'] : null;
                                                                            $change = isset($a['change_24h'])
                                                                                ? (float) str_replace('%', '', $a['change_24h'])
                                                                                : null;
                                                                        @endphp
                                                                        <div class="overflow-x-auto px-2">
                                                                            <div
                                                                                class="rounded-xl p-4 border border-zinc-200 dark:border-zinc-800 transition-colors duration-300">
                                                                                <!-- Header row: Logo, Name/Price, and Trade button -->
                                                                                <div class="flex items-center justify-between mb-3">
                                                                                    <div class="flex items-center gap-3">
                                                                                        @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                            <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                class="w-10 h-10 object-contain rounded-md border border-gray-200 dark:border-zinc-700">
                                                                                        @else
                                                                                            <div
                                                                                                class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                                                                                {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                            </div>
                                                                                        @endif

                                                                                        <div>
                                                                                            <h6
                                                                                                class="leading-tight font-medium text-gray-800 dark:text-gray-100">
                                                                                                {{ $a['name'] }}
                                                                                                <span class="text-sm text-gray-500">
                                                                                                    -
                                                                                                    {{ isset($a['price']) ? '$' . number_format((float) $a['price'], 2) : '-' }}
                                                                                                </span>
                                                                                            </h6>
                                                                                            <p class="text-xs text-gray-400">
                                                                                                {{ $a['pair'] ?? $a['symbol'] }}
                                                                                            </p>
                                                                                        </div>
                                                                                    </div>

                                                                                    <!-- Trade button -->
                                                                                    <a href="{{ route('user.trade', [
                                            'symbol' => $a['symbol'],
                                            'type' => 'forex',
                                            'name' => $a['name'],
                                            'price' => $price,
                                            'pair' => $a['pair'],
                                            'logo' => $a['logo'],
                                            'change_24h' => $change,
                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-md font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                        <span class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                        Trade
                                                                                    </a>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            <div class="tab-pane fade" id="commo" role="tabpanel" aria-labelledby="commo-tab"
                                tabindex="0">
                                <div class="w-full mb-4 mt-4">
                                    <h5 class="text-lg mt-3 p-4">Commodities</h5>
                                    <div
                                        class=" bg-white dark:bg-zinc-900 shadow-card overflow-hidden hidden lg:block  w-full">
                                        <div class="overflow-x-auto border border-zinc-200 dark:border-zinc-700">
                                            <table class="min-w-full divide-y divide-zinc-200 dark:divide-zinc-700">
                                                <thead
                                                    class="bg-zinc-50 dark:bg-zinc-800 border-b border-zinc-200 dark:border-zinc-700">
                                                    <tr>
                                                        <th
                                                            class="text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Name
                                                        </th>
                                                        <th
                                                            class="md:table-cell text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Price
                                                        </th>
                                                        <th
                                                            class="md:table-cell px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            24h Change
                                                        </th>
                                                        <th
                                                            class="md:table-cell px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Volume
                                                        </th>
                                                        <th
                                                            class="px-4 py-3 text-right text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Action
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody
                                                    class="bg-white dark:bg-zinc-900 divide-y divide-zinc-200 dark:divide-zinc-700">
                                                    @foreach ($commodities as $index => $a)
                                                                                                        @php
                                                                                                            $price = isset($a['price']) ? (float) $a['price'] : null;
                                                                                                            $change = isset($a['change_24h'])
                                                                                                                ? (float) str_replace('%', '', $a['change_24h'])
                                                                                                                : null;
                                                                                                        @endphp

                                                                                                        <tr
                                                                                                            class="{{ $loop->index % 2 === 0 ? 'bg-white dark:bg-zinc-900' : 'bg-zinc-50 dark:bg-zinc-800' }} hover:bg-zinc-100 dark:hover:bg-zinc-700 transition">

                                                                                                            <!-- Name -->
                                                                                                            <td class="px-4 py-3 whitespace-nowrap">
                                                                                                                <div class="flex items-center gap-3">
                                                                                                                    @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                                                        <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                                            class="w-8 h-8 rounded-full object-cover border border-zinc-200 dark:border-zinc-700">
                                                                                                                    @else
                                                                                                                        <div
                                                                                                                            class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                                                                                                            {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                                                        </div>
                                                                                                                    @endif
                                                                                                                    <div>
                                                                                                                        <div
                                                                                                                            class="font-medium text-zinc-900 dark:text-white">
                                                                                                                            {{ $a['name'] }}
                                                                                                                        </div>
                                                                                                                        <div
                                                                                                                            class="text-xs text-zinc-500 dark:text-zinc-400">
                                                                                                                            {{ $a['pair'] ?? $a['symbol'] }}
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                </div>
                                                                                                            </td>
                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap font-mono text-sm dark:text-zinc-100">
                                                                                                                {{ isset($a['price']) ? '$' . number_format((float) $a['price'], 2) : '-' }}
                                                                                                            </td>

                                                                                                            <td class="md:table-cell px-4 py-3 whitespace-nowrap">
                                                                                                                @if (isset($a['change_24h']))
                                                                                                                    <span
                                                                                                                        class="inline-flex items-center font-medium text-sm {{ (float) $a['change_24h'] >= 0 ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                                                                                                                        {{ (float) $a['change_24h'] >= 0 ? '+' : '' }}{{ number_format((float) $a['change_24h'], 2) }}%
                                                                                                                    </span>
                                                                                                                @else
                                                                                                                    <span
                                                                                                                        class="text-zinc-400 dark:text-zinc-500 text-sm">-</span>
                                                                                                                @endif
                                                                                                            </td>

                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap text-sm text-zinc-600 dark:text-zinc-300">
                                                                                                                {{ isset($a['volume_24h']) ? number_format((float) $a['volume_24h']) : '-' }}
                                                                                                            </td>


                                                                                                            <!-- Action -->
                                                                                                            <td class="px-4 py-3 text-right whitespace-nowrap">
                                                                                                                <a href="{{ route('user.trade', [
                                                            'symbol' => $a['symbol'],
                                                            'type' => 'commodity',
                                                            'name' => $a['name'],
                                                            'price' => $price,
                                                            'pair' => $a['pair'],
                                                            'logo' => $a['logo'],
                                                            'change_24h' => $change,
                                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-xs font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                                                    <span
                                                                                                                        class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                                                    Trade
                                                                                                                </a>
                                                                                                            </td>
                                                                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- Commodities Mobile Table -->
                                <div class="block lg:hidden space-y-2">
                                    @foreach ($commodities as $index => $a)
                                                                        @php
                                                                            $price = isset($a['price']) ? (float) $a['price'] : null;
                                                                            $change = isset($a['change_24h'])
                                                                                ? (float) str_replace('%', '', $a['change_24h'])
                                                                                : null;
                                                                        @endphp
                                                                        <div class="overflow-x-auto px-2">
                                                                            <div
                                                                                class="rounded-xl p-4 border border-zinc-200 dark:border-zinc-800 transition-colors duration-300">
                                                                                <!-- Header row: Logo, Name/Price, and Trade button -->
                                                                                <div class="flex items-center justify-between mb-3">
                                                                                    <div class="flex items-center gap-3">
                                                                                        @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                            <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                class="w-10 h-10 object-contain rounded-md border border-gray-200 dark:border-zinc-700">
                                                                                        @else
                                                                                            <div
                                                                                                class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                                                                                {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                            </div>
                                                                                        @endif

                                                                                        <div>
                                                                                            <h6
                                                                                                class="leading-tight font-medium text-gray-800 dark:text-gray-100">
                                                                                                {{ $a['name'] }}
                                                                                                <span class="text-sm text-gray-500">
                                                                                                    -
                                                                                                    {{ isset($a['price']) ? '$' . number_format((float) $a['price'], 2) : '-' }}
                                                                                                </span>
                                                                                            </h6>
                                                                                            <p class="text-xs text-gray-400">
                                                                                                {{ $a['pair'] ?? $a['symbol'] }}
                                                                                            </p>
                                                                                        </div>
                                                                                    </div>

                                                                                    <!-- Trade button -->
                                                                                    <a href="{{ route('user.trade', [
                                            'symbol' => $a['symbol'],
                                            'type' => 'commodity',
                                            'name' => $a['name'],
                                            'price' => $price,
                                            'pair' => $a['pair'],
                                            'logo' => $a['logo'],
                                            'change_24h' => $change,
                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-md font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                        <span class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                        Trade
                                                                                    </a>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                    @endforeach
                                </div>
                            </div>
                            <div class="tab-pane fade" id="bond" role="tabpanel" aria-labelledby="bond-tab"
                                tabindex="0">
                                <div class="w-full mb-4 mt-4">
                                    <h5 class="text-lg mt-3 p-4">Bonds</h5>
                                    <div
                                        class=" bg-white dark:bg-zinc-900 shadow-card overflow-hidden hidden lg:block  w-full">
                                        <div class="overflow-x-auto border border-zinc-200 dark:border-zinc-700">
                                            <table class="min-w-full divide-y divide-zinc-200 dark:divide-zinc-700">
                                                <thead
                                                    class="bg-zinc-50 dark:bg-zinc-800 border-b border-zinc-200 dark:border-zinc-700">
                                                    <tr>
                                                        <th
                                                            class="text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Name
                                                        </th>
                                                        <th
                                                            class="md:table-cell text-left px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Price
                                                        </th>
                                                        <th
                                                            class="md:table-cell px-4 py-3 text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            24h Change
                                                        </th>
                                                        <th
                                                            class="px-4 py-3 text-right text-xs font-medium text-zinc-700 dark:text-zinc-300 uppercase tracking-wider">
                                                            Action
                                                        </th>
                                                    </tr>
                                                </thead>
                                                <tbody
                                                    class="bg-white dark:bg-zinc-900 divide-y divide-zinc-200 dark:divide-zinc-700">
                                                    @foreach ($bonds as $index => $a)
                                                                                                        <tr
                                                                                                            class="{{ $loop->index % 2 === 0 ? 'bg-white dark:bg-zinc-900' : 'bg-zinc-50 dark:bg-zinc-800' }} hover:bg-zinc-100 dark:hover:bg-zinc-700 transition">
                                                                                                            <!-- Name -->
                                                                                                            <td class="px-4 py-3 whitespace-nowrap">
                                                                                                                <div class="flex items-center gap-3">
                                                                                                                    @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                                                        <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                                            class="w-8 h-8 rounded-full object-cover border border-zinc-200 dark:border-zinc-700">
                                                                                                                    @else
                                                                                                                        <span
                                                                                                                            class="inline-flex w-8 h-8 rounded-full items-center justify-center bg-gradient-to-br from-indigo-500 to-purple-600 text-white text-xs font-bold border border-zinc-200 dark:border-zinc-700">
                                                                                                                            {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                                                        </span>
                                                                                                                    @endif

                                                                                                                    <div>
                                                                                                                        <div
                                                                                                                            class="font-medium text-zinc-900 dark:text-white">
                                                                                                                            {{ $a['name'] }}
                                                                                                                        </div>
                                                                                                                        <div
                                                                                                                            class="text-xs text-zinc-500 dark:text-zinc-400">
                                                                                                                            {{ $a['pair'] ?? $a['symbol'] }}
                                                                                                                        </div>
                                                                                                                    </div>
                                                                                                                </div>
                                                                                                            </td>

                                                                                                            <!-- Price -->
                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap font-mono text-sm dark:text-zinc-100">
                                                                                                                {{ isset($a['price']) ? '$' . number_format($a['price'], 2) : '-' }}
                                                                                                            </td>

                                                                                                            <!-- 24h Change -->
                                                                                                            {{-- <td class="md:table-cell px-4 py-3 whitespace-nowrap">
                                                                                                                @if (isset($a['change_24h']))
                                                                                                                <span
                                                                                                                    class="inline-flex items-center font-medium text-sm {{ $a['change_24h'] >= 0 ? 'text-green-600 dark:text-green-400' : 'text-red-600 dark:text-red-400' }}">
                                                                                                                    {{ $a['change_24h'] >= 0 ? '+' : '' }}{{
                                                                                                                    number_format($a['change_24h'], 2) }}%
                                                                                                                </span>
                                                                                                                @else
                                                                                                                <span
                                                                                                                    class="text-zinc-400 dark:text-zinc-500 text-sm">-</span>
                                                                                                                @endif
                                                                                                            </td> --}}

                                                                                                            <!-- Volume -->
                                                                                                            <td
                                                                                                                class="md:table-cell px-4 py-3 whitespace-nowrap text-sm text-zinc-600 dark:text-zinc-300">
                                                                                                                {{ isset($a['volume_24h']) ? number_format($a['volume_24h']) : '-' }}
                                                                                                            </td>

                                                                                                            <!-- Action -->
                                                                                                            <td class="px-4 py-3 text-right whitespace-nowrap">
                                                                                                                <a href="{{ route('user.trade', [
                                                            'symbol' => $a['symbol'],
                                                            'type' => 'bond',
                                                            'name' => $a['name'],
                                                            'price' => $a['price'],
                                                            'pair' => $a['pair'],
                                                            'logo' => $a['logo'],
                                                            'change_24h' => $a['change_24h'],
                                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-xs font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                                                    <span
                                                                                                                        class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                                                    Trade
                                                                                                                </a>
                                                                                                            </td>
                                                                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>

                                <!-- Bonds Mobile Table -->
                                <div class="block lg:hidden space-y-2">
                                    @foreach ($bonds as $index => $a)
                                                                        @php
                                                                            $price = isset($a['price']) ? (float) $a['price'] : null;
                                                                            $change = isset($a['change_24h'])
                                                                                ? (float) str_replace('%', '', $a['change_24h'])
                                                                                : null;
                                                                        @endphp
                                                                        <div class="overflow-x-auto px-2">
                                                                            <div
                                                                                class="rounded-xl p-4 border border-zinc-200 dark:border-zinc-800 transition-colors duration-300">
                                                                                <!-- Header row: Logo, Name/Price, and Trade button -->
                                                                                <div class="flex items-center justify-between mb-3">
                                                                                    <div class="flex items-center gap-3">
                                                                                        @if (isset($a['logo']) && filter_var($a['logo'], FILTER_VALIDATE_URL))
                                                                                            <img src="{{ $a['logo'] }}" alt="{{ $a['name'] }}"
                                                                                                class="w-10 h-10 object-contain rounded-md border border-gray-200 dark:border-zinc-700">
                                                                                        @else
                                                                                            <div
                                                                                                class="w-8 h-8 bg-gradient-to-br from-indigo-500 to-purple-600 rounded-full flex items-center justify-center text-white text-xs font-bold">
                                                                                                {{ strtoupper(substr($a['symbol'] ?? $a['pair'], 0, 2)) }}
                                                                                            </div>
                                                                                        @endif

                                                                                        <div>
                                                                                            <h6
                                                                                                class="leading-tight font-medium text-gray-800 dark:text-gray-100">
                                                                                                {{ $a['name'] }}
                                                                                                <span class="text-sm text-gray-500">
                                                                                                    -
                                                                                                    {{ isset($a['price']) ? '$' . number_format((float) $a['price'], 2) : '-' }}
                                                                                                </span>
                                                                                            </h6>
                                                                                            <p class="text-xs text-gray-400">
                                                                                                {{ $a['pair'] ?? $a['symbol'] }}
                                                                                            </p>
                                                                                        </div>
                                                                                    </div>

                                                                                    <!-- Trade button -->
                                                                                    <a href="{{ route('user.trade', [
                                            'symbol' => $a['symbol'],
                                            'type' => 'bond',
                                            'name' => $a['name'],
                                            'price' => $a['price'],
                                            'pair' => $a['pair'],
                                            'logo' => $a['logo'],
                                            'change_24h' => $a['change_24h'],
                                        ]) }}" class="inline-flex items-center gap-1 px-3 py-1.5 text-md font-semibold text-white bg-primary hover:bg-primary-deep rounded-md shadow-sm transition">
                                                                                        <span class="icon-[lucide--arrow-up-right] w-3.5 h-3.5"></span>
                                                                                        Trade
                                                                                    </a>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.getElementById('instrumentSearch').addEventListener('keyup', function () {
            let query = this.value.trim();

            if (query.length < 2) {
                document.getElementById('searchResults').classList.add('hidden');
                return;
            }

            fetch(`/search-instruments?q=` + encodeURIComponent(query))
                .then(response => response.json())
                .then(data => {
                    let resultsBox = document.getElementById('searchResults');
                    resultsBox.innerHTML = '';

                    if (data.length === 0) {
                        resultsBox.innerHTML = `
                        <div class="px-3 py-2 text-sm text-gray-600">
                            No results found.
                        </div>
                    `;
                    } else {
                        data.forEach(item => {
                            resultsBox.innerHTML += `
                            <div class="px-3 py-2 border-b border-gray-200 dark:border-gray-700 hover:bg-gray-100 dark:hover:bg-gray-700 cursor-pointer">
                                <span class="font-semibold">${item.name}</span>
                                <span class="text-xs text-gray-500">(${item.symbol})</span>
                            </div>
                        `;
                        });
                    }

                    resultsBox.classList.remove('hidden');
                });
        });
    </script>


</x-user>