<x-user :title="$pageTitle">

    <!--:Page Header:-->
    <div class="px-4 lg:px-8 pt-4 pb-4 flex flex-col sm:flex-row sm:items-center">
        <div class="flex-grow mb-3 sm:mb-0">
            <h2 class="text-xl font-semibold mb-1 text-black dark:text-white">Referral Program</h2>
            <p>Grow your network and earn rewards with {{ $websiteSettings->site_name }}</p>
        </div>
        {{-- <div class="shrink-0">
            <button type="button" class="btn bg-primary text-white hover:bg-primary-deep">Create
                Campaign</button>
        </div> --}}
    </div>

    <!--:Page content:-->
    <div class="content lg:px-4 flex-grow">
        {{-- <div class="px-2 mb-4 grid grid-cols-1 md:grid-cols-4 gap-4">
            <!--:Card:-->
            <div class="rounded-xl p-4 bg-white dark:bg-zinc-900 shadow-card flex items-center">
                <div class="shrink-0 w-3/5">
                    <p class="mb-2">Total Referrals</p>
                    <h4 class="text-2xl mb-1">$59K</h4>
                    <span class="text-sm">
                        <span class="text-green-500">+5.5%</span></span>
                </div>
            </div>
            <!--:Card:-->
            <div class="rounded-xl p-4 bg-white dark:bg-zinc-900 shadow-card flex items-center">
                <div class="shrink-0 w-3/5">
                    <p class="mb-2">Total Earnings</p>
                    <h4 class="text-2xl mb-1">47%</h4>
                    <span class="text-sm">
                        <span class="text-green-500">+2.5%</span></span>
                </div>
            </div>
            <!--:Card:-->
            <div class="rounded-xl p-4 bg-white dark:bg-zinc-900 shadow-card flex items-center">
                <div class="shrink-0 w-3/5">
                    <p class="mb-2">Your Level</p>
                    <h4 class="text-2xl mb-1">82%</h4>
                    <span class="text-sm">
                        <span class="text-red-500">-0.5%</span></span>
                </div>
            </div>
            <!--:Card:-->
            <div class="rounded-xl p-4 bg-white dark:bg-zinc-900 shadow-card flex items-center">
                <div class="shrink-0 w-3/5">
                    <p class="mb-2">Referred By</p>
                    <h4 class="text-2xl mb-1">82%</h4>
                    <span class="text-sm">
                        <span class="text-red-500">-0.5%</span></span>
                </div>
            </div>
        </div> --}}
        <div class="px-2 mb-4">
            <div class="rounded-xl bg-white dark:bg-zinc-900 shadow-card overflow-hidden">
                <div class="px-4 max-w-md mx-auto py-8 w-full">
                    <div class="mb-5">
                        <span class="text-muted text-xl text-bold">
                            Referral Tools
                        </span>
                    </div>
                    <div class="flex flex-col gap-1 mb-4">
                        <label class="block mb-0.5 text-muted" for="userEmail">
                            Your Referral ID
                        </label>
                        <!-- Success message -->
                        <p id="copyMsg"
                            class="hidden mt-2 text-sm text-green-600 font-medium transition-opacity duration-300">
                            ✅ Referral copied!
                        </p>
                        <input id="referralCode" class="input" placeholder="" readonly type="text"
                            value="{{ Auth::user()->referral_code }}">
                    </div>
                    <button id="copyBtn"
                        class="btn bg-primary text-white hover:bg-primary-deep w-full text-center">Copy</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    {{-- <div class="grid grid-cols-1 px-2 md:grid-cols-12 gap-4 mb-4">
        <div class="md:col-span-6">
            <!--:card:-->
            <div class="rounded-xl bg-white dark:bg-zinc-900 shadow-card overflow-hidden">
                <div class="flex justify-between items-center px-4 py-4">
                    <div class="space-y-6">
                        <div>
                            <h3 class="text-xl font-semibold text-white mb-4">How It Works</h3>
                            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                                <div class="text-center">
                                    <div
                                        class="badge bg-red-900  w-12 h-12 rounded-full flex items-center justify-center mx-auto mb-3">
                                        <span class="text-blue-500 font-bold">1</span>
                                    </div>
                                    <h4 class="text-white font-medium mb-2">Share Your Code</h4>
                                    <p class="text-gray-400 text-md">Share your unique referral Code with friends and
                                        family</p>
                                </div>
                                <div class="text-center">
                                    <div
                                        class="bg-green-600/10 w-12 h-12 rounded-full flex items-center justify-center mx-auto mb-3">
                                        <span class="text-green-500 font-bold">2</span>
                                    </div>
                                    <h4 class="text-white font-medium mb-2">They Join</h4>
                                    <p class="text-gray-400 text-md">When someone signs up using your Code, they become
                                        your referral</p>
                                </div>
                                <div class="text-center">
                                    <div
                                        class="bg-purple-600/10 w-12 h-12 rounded-full flex items-center justify-center mx-auto mb-3">
                                        <span class="text-purple-500 font-bold">3</span>
                                    </div>
                                    <h4 class="text-white font-medium mb-2">Earn Rewards</h4>
                                    <p class="text-gray-400 text-md">Get commission from their trading activities and
                                        transactions</p>
                                </div>
                            </div>
                        </div>

                        <div>
                            <h3 class="text-lg font-semibold text-white mb-4">Referral Levels</h3>
                            <div class="space-y-3">
                                @foreach ($levels as $lev)
                                <div
                                    class="flex items-center rounded-xl bg-green-500/20 dark:bg-green-900/50 shadow-card overflow-hidden px-2 py-2">
                                    <div class="flex-grow">
                                        <h5 class="text-xl mb-1">{{ $lev->level_name }}</h5>
                                        <p class="mb-2">{{ $lev->min_referrals }} - {{ $lev->max_referrals }}
                                            referrals</p>

                                    </div>
                                    <div class="text-primary size-12 flex pr-6 items-center justify-center">
                                        <span class="text-md text-muted italic items-center">
                                            <span class="text-green-500 flex items-center">
                                                {{ $lev->commission_percentage }}%</span> Commission
                                        </span>
                                    </div>
                                </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div> --}}

</x-user>