<x-user :title="$pageTitle">
    <div class="content flex-grow px-2 lg:px-4 pt-6 mb-4 gap-2.5">
        <div class="mb-4 gap-4 max-w-7xl mx-auto">
            <div class="px-4 lg:px-8 pt-4 pb-1 flex flex-col sm:flex-row sm:items-center mb-1">
                <div class="flex-grow mb-3 sm:mb-0">
                    <h2 class="text-2xl font-semibold mb-1 text-black dark:text-white">📈 Premium Trading Signals</h2>
                    <p>Subscribe to professional trading signals and enhance your trading success</p>
                </div>
                <div class="shrink-0">
                    <div class="flex items-center border border-zinc-200 dark:border-zinc-700 gap-4 p-2 rounded-xl">
                        <!-- Icon -->
                        <div
                            class="flex items-center justify-center size-10 rounded-full shrink-0 bg-zinc-300 dark:bg-zinc-900 text-white">
                            <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                                <g fill="none" stroke="#f7f7f7" stroke-linecap="round" stroke-linejoin="round"
                                    stroke-width="2">
                                    <path d="M16 7h6v6" />
                                    <path d="m22 7l-8.5 8.5l-5-5L2 17" />
                                </g>
                            </svg>
                        </div>

                        <!-- Texts -->
                        <div>
                            <h5 class="text-xl font-semibold mb-1">{{ $total }}</h5>
                            <p class="mb-1 text-sm text-zinc-500">Available Signals</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="content flex flex-col flex-grow px-4 lg:px-8 mb-2">
                <div class="rounded-xl bg-white dark:bg-zinc-900 shadow-card overflow-hidden mb-2">
                    @php
                        $activeSignal = $purchases->first();
                    @endphp

                    @if ($purchases->isEmpty())

                        <div class="flex justify-between items-center px-4 py-4">
                            <h5 class="text-lg">
                                Signal Strength
                            </h5>
                        </div>

                        <div class="p-4 pt-0">
                            <div class="flex mb-2 items-end justify-between">
                                <h3 class="text-2xl"></h3>
                                <span class="text-l text-muted flex items-center gap-1">
                                    <span class="text-red-500 flex items-center gap-1">
                                        0%</span>
                                </span>
                            </div>
                            <!--:Progress:-->
                            <div class="progress flex-grow h-2 rounded-full overflow-hidden bg-red-500/10">
                                <div class="animate-pulse bg-red-500 h-2 transition-all duration-700 ease-out"
                                    style="width: 2%"></div>
                            </div>
                            <div class="flex items-center gap-2">
                                <span class="text-gray-400 italic">
                                    You currently do not have any active signals
                                </span>
                            </div>
                        </div>
                    @else
                        {{-- HAS ACTIVE SIGNAL --}}
                        @php
                            $strength = $activeSignal->signal->strength ?? 0;
                            $status = $activeSignal->status ?? 'pending';
                        @endphp

                        @if ($status === 'approved')
                            @if ($strength <= 30)
                                <div class="flex justify-between items-center px-4 py-4">
                                    <h5 class="text-lg">
                                        Signal Strength
                                    </h5>
                                </div>

                                <div class="p-4 pt-0">
                                    <div class="flex mb-2 items-end justify-between">
                                        <h3 class="text-2xl"></h3>
                                        <span class="text-l text-muted flex items-center gap-1">
                                            <span class="text-red-500 flex items-center gap-1">
                                                {{ $strength }}%</span>
                                        </span>
                                    </div>
                                    <!--:Progress:-->
                                    <div class="progress mb-4 h-2 rounded-lg w-full bg-primary/20" role="progressbar"
                                        aria-label="Basic example" aria-valuenow="0" aria-valuemin="0"
                                        aria-valuemax="100">
                                        <div class="progress-bar bg-red-500 rounded-lg h-2"
                                            style="width: {{ $strength }}%"></div>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <span class="text-gray-400 italic">
                                            You are currently subscribed to <span
                                                class="font-semibold">{{ $activeSignal->signal->title }}</span>
                                            signal
                                        </span>
                                    </div>
                                </div>
                            @elseif ($strength <= 69)
                                <div class="flex justify-between items-center px-4 py-4">
                                    <h5 class="text-lg">
                                        Signal Strength
                                    </h5>
                                </div>

                                <div class="p-4 pt-0">
                                    <div class="flex mb-2 items-end justify-between">
                                        <h3 class="text-2xl"></h3>
                                        <span class="text-l text-muted flex items-center gap-1">
                                            <span class="text-orange-500 flex items-center gap-1">
                                                {{ $strength }}%</span>
                                        </span>
                                    </div>
                                    <!--:Progress:-->
                                    <div class="progress mb-4 h-2 rounded-lg w-full bg-primary/20" role="progressbar"
                                        aria-label="Basic example" aria-valuenow="0" aria-valuemin="0"
                                        aria-valuemax="100">
                                        <div class="progress-bar bg-orange-500 rounded-lg h-2"
                                            style="width: {{ $strength }}%"></div>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <span class="text-gray-400 italic">
                                            You are currently subscribed to <span
                                                class="font-semibold">{{ $activeSignal->signal->title }}</span>
                                            signal
                                        </span>
                                    </div>
                                </div>
                            @else
                                <div class="flex justify-between items-center px-4 py-4">
                                    <h5 class="text-lg">
                                        Signal Strength
                                    </h5>
                                </div>

                                <div class="p-4 pt-0">
                                    <div class="flex mb-2 items-end justify-between">
                                        <h3 class="text-2xl"></h3>
                                        <span class="text-l text-muted flex items-center gap-1">
                                            <span class="text-green-500 flex items-center gap-1">
                                                {{ $strength }}%</span>
                                        </span>
                                    </div>
                                    <!--:Progress:-->
                                    <div class="progress mb-4 h-2 rounded-lg w-full bg-primary/20" role="progressbar"
                                        aria-label="Basic example" aria-valuenow="0" aria-valuemin="0"
                                        aria-valuemax="100">
                                        <div class="progress-bar bg-green-500 rounded-lg h-2"
                                            style="width: {{ $strength }}%"></div>
                                    </div>
                                    <div class="flex items-center gap-2">
                                        <span class="text-gray-400 italic">
                                            You are currently subscribed to <span
                                                class="font-semibold">{{ $activeSignal->signal->title }}</span>
                                            signal
                                        </span>
                                    </div>
                                </div>
                            @endif
                        @elseif($status === 'pending')
                            <div class="flex items-center gap-2 p-4 pt-3">
                                <span class="text-gray-400 italic">
                                    Your Subscription Status is currently <span
                                        class="text-yellow-500 font-semibold">Pending</span>
                                    Please
                                    wait for approval
                                </span>
                            </div>
                        @else
                            <span class="text-gray-400 italic">
                                Your Subscription is <span class="text-red-500 font-semibold">Rejected</span>
                                If this is an error, contact Admin
                            </span>
                        @endif

                    @endif
                </div>
            </div>

            <div class="content flex flex-col flex-grow px-4 lg:px-8">
                <!-- Pricing Plans -->
                <div class="grid grid-cols-1 md:grid-cols-4 gap-6">

                    <!-- Team Plan (Popular) -->
                    @foreach ($signals as $item)
                        <div
                            class="p-4 border hover:border-primary py-8 md:py-4 md:px-8 border-zinc-200 transition-all hover:-translate-y-1 transform group dark:border-zinc-800 flex flex-col relative rounded-xl">
                            <span
                                class="flex absolute top-4 ltr:right-4 rtl:left-4 gap-1 bg-sky-500/20 px-2 py-1 text-xs rounded-full">
                                <svg xmlns="http://www.w3.org/2000/svg" width="12" height="12"
                                    viewBox="0 0 24 24">
                                    <path fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="2"
                                        d="M11.525 2.295a.53.53 0 0 1 .95 0l2.31 4.679a2.12 2.12 0 0 0 1.595 1.16l5.166.756a.53.53 0 0 1 .294.904l-3.736 3.638a2.12 2.12 0 0 0-.611 1.878l.882 5.14a.53.53 0 0 1-.771.56l-4.618-2.428a2.12 2.12 0 0 0-1.973 0L6.396 21.01a.53.53 0 0 1-.77-.56l.881-5.139a2.12 2.12 0 0 0-.611-1.879L2.16 9.795a.53.53 0 0 1 .294-.906l5.165-.755a2.12 2.12 0 0 0 1.597-1.16z" />
                                </svg>Premium</span>
                            <h2 class="text-lg mb-3 mt-5">{{ $item->title }}</h2>
                            <div class="mb-5">
                                <p class="price-monthly text-3xl font-semibold">${{ number_format($item->price, 2) }}
                                    <span class="text-sm"> /month</span>
                                </p>
                                <p class="price-monthly text-sm font-semibold mt-2">
                                    {{ $item->description }}
                                </p>
                            </div>
                            <ul class="mt-4 space-y-4 text-left mb-4 flex-grow">
                                <li class="flex flex-wrap items-center gap-3"><span
                                        class="icon-[lucide--check] text-sm bg-green-500 text-muted"></span> Pairs:
                                    <span class="text-sm font-semibold">{{ $item->pair }}</span>
                                </li>
                                <li class="flex flex-wrap items-center gap-3"><span
                                        class="icon-[lucide--check] text-sm bg-green-500 text-muted"></span> Direction:
                                    <span class="text-sm font-semibold">{{ $item->direction }}</span>
                                </li>
                                <li class="flex flex-wrap items-center gap-3"><span
                                        class="icon-[lucide--check] text-sm bg-green-500 text-muted"></span> Real-time
                                    notifications</li>
                                <li class="flex flex-wrap items-center gap-3"><span
                                        class="icon-[lucide--check] text-sm bg-green-500 text-muted"></span> 24/7
                                    support
                                </li>
                                <li class="flex flex-wrap items-center gap-3"><span
                                        class="icon-[lucide--check] text-sm bg-green-500 text-muted"></span> Expert
                                    analysis</li>
                                <li class="flex flex-wrap items-center gap-3">
                                    <!--:Bar:-->
                                    @php
                                        $strength = $item->strength;
                                    @endphp

                                    <div class="flex-grow max-w-md">
                                        <div class="flex items-center gap-3">

                                            <span class="text-sm">Strength</span>

                                            @if ($strength <= 30)
                                                <div
                                                    class="progress flex-grow h-2 rounded-full overflow-hidden bg-red-500/10">
                                                    <div class="animate-pulse bg-red-500 h-2 transition-all duration-700 ease-out"
                                                        style="width: {{ $strength }}%"></div>
                                                </div>
                                            @elseif($strength <= 69)
                                                <div
                                                    class="progress flex-grow h-2 rounded-full overflow-hidden bg-orange-500/20">
                                                    <div class="animate-pulse bg-orange-500 h-2 transition-all duration-700 ease-out"
                                                        style="width: {{ $strength }}%"></div>
                                                </div>
                                            @else
                                                <div
                                                    class="progress flex-grow h-2 rounded-full overflow-hidden bg-green-500/20">
                                                    <div class="bg-green-500 h-2 transition-all duration-700 ease-out"
                                                        style="width: {{ $strength }}%"></div>
                                                </div>
                                            @endif

                                            <span class="text-sm">{{ $strength }}%</span>

                                        </div>
                                    </div>
                                </li>
                            </ul>
                            <a href="{{ route('user.signals.details', $item->id) }}"
                                class="btn btn-lg bg-primary h-9 text-white hover:bg-primary-deep gap-1">
                                <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16"
                                    viewBox="0 0 24 24">
                                    <g fill="none" stroke="#f7f7f7" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="2">
                                        <circle cx="12" cy="12" r="10" />
                                        <path d="M8 12h8m-4-4v8" />
                                    </g>
                                </svg> Subscribe Now
                            </a>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>

</x-user>
