<x-user>
    <!--:Page Header:-->
    <div class="px-4 py-8 lg:py-12 rounded-b-xl">
        <div class="text-center">
            <h4 class="text-xl lg:text-2xl mb-2">Assistance & Support Center</h4>
            <p class="max-w-sm mx-auto text-muted mb-4">
                We're here to help you with any questions or concerns
            </p>

        </div>
    </div>

    <!--:Page content:-->
    <div class="content flex-grow lg:px-4">
        <div class="px-2 py-4 max-w-4xl mx-auto">
            @if (session('message'))
                <div role="alert"
                    class="flex gap-2.5 items-center px-4 py-2.5 mb-4 rounded-lg bg-green-500/20 text-green-800 dark:text-green-200 gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24">
                        <path fill="currentColor"
                            d="M5.25 4h13.5a3.25 3.25 0 0 1 3.245 3.066L22 7.25v9.5a3.25 3.25 0 0 1-3.066 3.245L18.75 20H5.25a3.25 3.25 0 0 1-3.245-3.066L2 16.75v-9.5a3.25 3.25 0 0 1 3.066-3.245zh13.5zM20.5 9.373l-8.15 4.29a.75.75 0 0 1-.603.043l-.096-.042L3.5 9.374v7.376a1.75 1.75 0 0 0 1.606 1.744l.144.006h13.5a1.75 1.75 0 0 0 1.744-1.607l.006-.143zM18.75 5.5H5.25a1.75 1.75 0 0 0-1.744 1.606L3.5 7.25v.429l8.5 4.474l8.5-4.475V7.25a1.75 1.75 0 0 0-1.607-1.744z" />
                    </svg>
                    <div class="flex-grow">
                        {{ session('message') }}
                    </div>
                </div>
            @endif
            <div
                class="rounded-xl p-4 mb-4 lg:p-6 bg-white dark:bg-zinc-900 border border-zinc-200 dark:border-zinc-700 shadow-card">
                <div class="flex items-center gap-4">
                    <div class="flex-grow md:pe-12 space-y-2">
                        <!-- Icon + Title Row -->
                        <div class="flex items-center gap-2">
                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 24 24"
                                class="text-primary">
                                <path fill="currentColor"
                                    d="M5.25 4h13.5a3.25 3.25 0 0 1 3.245 3.066L22 7.25v9.5a3.25 3.25 0 0 1-3.066 3.245L18.75 20H5.25a3.25 3.25 0 0 1-3.245-3.066L2 16.75v-9.5a3.25 3.25 0 0 1 3.066-3.245zM20.5 9.373l-8.15 4.29a.75.75 0 0 1-.603.043l-.096-.042L3.5 9.374v7.376a1.75 1.75 0 0 0 1.606 1.744l.144.006h13.5a1.75 1.75 0 0 0 1.744-1.607l.006-.143zM18.75 5.5H5.25a1.75 1.75 0 0 0-1.744 1.606L3.5 7.25v.429l8.5 4.474l8.5-4.475V7.25a1.75 1.75 0 0 0-1.607-1.744z" />
                            </svg>
                            <h5 class="text-lg font-semibold text-gray-900 dark:text-gray-100">
                                Email Support
                            </h5>
                        </div>

                        <!-- Subtitle -->
                        <p class="text-sm text-gray-500 dark:text-gray-400">
                            Get help via email.
                        </p>

                        <!-- Description -->
                        <p class="text-gray-600 dark:text-gray-300">
                            Direct email communication for detailed inquiries and support requests.
                        </p>

                        <!-- Button -->
                        <a href="mailto:{{ $websiteSettings->site_email }}"
                            class="btn btn-sm bg-sky-500/20 text-white hover:bg-zinc-800">
                            {{ $websiteSettings->site_email }}
                        </a>
                    </div>

                    <div class="shrink-0 w-24">
                        <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24">
                            <g fill="currentColor" fill-rule="evenodd" clip-rule="evenodd">
                                <path
                                    d="M9.746 18.286q-.613-.135-1.2-.36a5.6 5.6 0 0 1-1.088-.55a4.31 4.31 0 0 1-1.999-3.507a6.2 6.2 0 0 1 1.25-3.937a6.3 6.3 0 0 1 2.068-1.839a6.8 6.8 0 0 1 2.668-.77a6.235 6.235 0 0 1 5.996 3.558a4.577 4.577 0 0 1-1.76 6.376a.39.39 0 0 0-.14.54a.38.38 0 0 0 .53.14c3.208-1.76 3.578-4.907 2.369-7.536a7.5 7.5 0 0 0-6.995-4.396a7.7 7.7 0 0 0-3.208.939a7.3 7.3 0 0 0-3.687 6.995a5.2 5.2 0 0 0 2.458 4.127q.6.346 1.26.56q.635.22 1.298.34a.36.36 0 0 0 .42-.28a.35.35 0 0 0-.24-.4" />
                                <path
                                    d="M11.905 16.807a2.68 2.68 0 0 0 1.998-1.709a.38.38 0 0 0-.16-.53a.38.38 0 0 0-.53.16a1.78 1.78 0 0 1-1.838.77a2.4 2.4 0 0 1-.6-.15a2.42 2.42 0 0 1-1.269-.95a.34.34 0 0 0-.5-.18a.35.35 0 0 0-.18.46c.209.75.69 1.396 1.35 1.81c.306.178.646.29.999.329q.365.05.73-.01" />
                                <path
                                    d="M23.886 12.45a3 3 0 0 0-.29-.76a3.47 3.47 0 0 0-2.238-1.678a12 12 0 0 0-.36-1.739a9.13 9.13 0 0 0-5.066-5.806a10.15 10.15 0 0 0-7.995.35a8.4 8.4 0 0 0-5.046 6.076c0 .24 0 .48-.06.72A3.48 3.48 0 0 0 .413 11.37q-.196.36-.29.76a3 3 0 0 0 0 1.698a2.67 2.67 0 0 0 1.889 1.699q.297.094.61.13q.304.03.609 0a.4.4 0 0 0 .38-.33a.3.3 0 0 0 .26 0a.34.34 0 0 0 .2-.32a17.3 17.3 0 0 1-.44-2.998c-.056-.987.014-1.978.21-2.948a7.47 7.47 0 0 1 4.636-5.046a9 9 0 0 1 6.995-.33a8.05 8.05 0 0 1 4.527 4.917a10.3 10.3 0 0 1-.19 6.995a.39.39 0 0 0 .22.51a.3.3 0 0 0 .19 0a9.7 9.7 0 0 1-1 1.648c-.37.501-.802.951-1.289 1.34a4.2 4.2 0 0 1-2.718 1.079a.39.39 0 0 0-.47-.18a.4.4 0 0 0-.22.52c0 .13 0 .22-.13.31c-.16.12-.35.197-.549.219a1.8 1.8 0 0 1-.84-.04a2 2 0 0 1-.759-.37c-.17-.12-.3-.2-.24-.32a.8.8 0 0 1 .34-.34l.68-.22a4 4 0 0 1 .58-.05h.619a.34.34 0 0 0 .39-.279a.35.35 0 0 0-.28-.41l-1.33-.22a3 3 0 0 0-.509 0a2.5 2.5 0 0 0-.53.1a1.72 1.72 0 0 0-1.219 1.14a1.53 1.53 0 0 0 .74 1.639c.4.264.854.434 1.329.5c.453.045.911-.013 1.339-.17c.41-.155.759-.435 1-.8q.064-.14.1-.29a4.8 4.8 0 0 0 2.997-.58a5.5 5.5 0 0 0 1.999-1.998a7.2 7.2 0 0 0 .909-2.328h.28q.31-.05.61-.14a2.67 2.67 0 0 0 1.808-1.7a2.94 2.94 0 0 0 .03-1.718M2.741 14.808a4 4 0 0 1-.42-.17a1.73 1.73 0 0 1-.93-1.179a2.5 2.5 0 0 1 .001-.999a2.92 2.92 0 0 1 1.349-1.998q-.015.821.06 1.638c.1.984.287 1.958.56 2.908c-.06 0-.1-.07-.17-.07zm18.987.14c-1.51.73-.1-.939-.27-4.117a3 3 0 0 1 1.189 1.919c.066.33.066.67 0 1a1.72 1.72 0 0 1-.96 1.198z" />
                                <path
                                    d="M8.837 10.521a1.4 1.4 0 0 0-.53.09c-.38.15-.72.382-1 .68a.35.35 0 0 0-.11.48c.14.25 2 0 2.36 0q.239.01.469.08a.41.41 0 0 0 .55-.13a.4.4 0 0 0-.13-.54a2.4 2.4 0 0 0-1.08-.62a1.6 1.6 0 0 0-.53-.04m7.246 1.249a.35.35 0 0 0-.12-.48a2.6 2.6 0 0 0-1-.679a1.4 1.4 0 0 0-.53-.09c-.181-.01-.364.01-.539.06c-.407.11-.779.324-1.08.62a.4.4 0 0 0-.119.54a.4.4 0 0 0 .55.13q.229-.07.47-.08c1.128-.09 2.158.34 2.368-.02" />
                            </g>
                        </svg>
                    </div>
                </div>
            </div>
            <!--:Search results:-->
            <div
                class="rounded-xl bg-white dark:bg-zinc-900 shadow-card mb-4 border border-zinc-200 dark:border-zinc-700 relative">
                <div class="p-4 pb-0 text-center justify-center">
                    <h5 class="text-xl mb-3">Send Us A Message </h5>
                    <p class="text-zinc-400 mb-3">Have a specific question or need assistance? Fill out the form
                        below and our support team will get back to you as soon as possible. </p>
                </div>
                <div class="p-4">
                    <form action="{{ route('user.support_store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="flex lg:px-4 flex-wrap -mx-2">
                            <div class="w-full px-2 sm:w-6/12 mb-4">
                                <label class="mb-1 block">Name</label>
                                <input type="text" class="input" name="name" readonly
                                    value="{{ Auth::user()->firstname }} {{ Auth::user()->lastname }}">
                            </div>
                            <div class="w-full px-2 sm:w-6/12 mb-4">
                                <label class="mb-1 block">Email</label>
                                <input type="email" name="email" class="input" readonly
                                    value="{{ Auth::user()->email }}">
                            </div>
                            <div class="w-full px-2 mb-4">
                                <label class="mb-1 block">Reason</label>
                                <select class="input" name="title">
                                    <option value="Deposit Issue">Deposit Issue</option>
                                    <option value="Withdrawal Issue">Withdrawal Issue</option>
                                    <option value="Investment Issue">Investment Issue</option>
                                    <option value="Live Trading Issue">Live Trading Issue</option>
                                    <option value="Kyc Identification Issue">Kyc Identification Issue</option>
                                    <option value="Others">Others</option>
                                </select>
                            </div>
                            <div class="w-full px-2 mb-4">
                                <label class="mb-1 block">Message</label>
                                <textarea type="text" class="input" name="message"
                                    placeholder="Please describe your isues or question in details" rows="5"></textarea>
                            </div>
                            <div class="w-full px-2 mb-4">
                                <label class="mb-1 block">Attach Image (Optional)</label>
                                <input type="file" name="image" class="input">
                            </div>
                        </div>
                        <!--:Page footer:-->
                        <div class="pb-4 px-2 flex items-center w-full">
                            <button type="submit"
                                class="btn w-full bg-primary text-white hover:bg-primary-deep flex items-center h-12 justify-center gap-2">
                                <span class="icon-[lucide--mail] text-lg leading-none"></span>
                                Send
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

</x-user>