<x-user :title="$pageTitle">

    <!--:Page Header:-->
    <div class="px-4 py-8 lg:py-12 rounded-b-xl">
        <div class="text-center">
            <h4 class="text-xl lg:text-2xl mb-2">Swap Balance</h4>
            <p class="max-w-sm mx-auto text-muted mb-4">
                Make Swap from Profit Balance or Bonus Balance
            </p>
        </div>
    </div>

    <!--:Page content:-->
    <div class="content flex-grow lg:px-4">
        <div class="px-2 py-4 max-w-4xl mx-auto">
            @if (session('message'))
                <div role="alert"
                    class="flex gap-2.5 items-center px-4 py-2.5 mb-4 rounded-lg bg-green-500/20 text-green-800 dark:text-green-200 gap-2">
                    <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 24 24">
                        <path fill="currentColor"
                            d="M5.25 4h13.5a3.25 3.25 0 0 1 3.245 3.066L22 7.25v9.5a3.25 3.25 0 0 1-3.066 3.245L18.75 20H5.25a3.25 3.25 0 0 1-3.245-3.066L2 16.75v-9.5a3.25 3.25 0 0 1 3.066-3.245zh13.5zM20.5 9.373l-8.15 4.29a.75.75 0 0 1-.603.043l-.096-.042L3.5 9.374v7.376a1.75 1.75 0 0 0 1.606 1.744l.144.006h13.5a1.75 1.75 0 0 0 1.744-1.607l.006-.143zM18.75 5.5H5.25a1.75 1.75 0 0 0-1.744 1.606L3.5 7.25v.429l8.5 4.474l8.5-4.475V7.25a1.75 1.75 0 0 0-1.607-1.744z" />
                    </svg>
                    <div class="flex-grow">
                        {{ session('message') }}
                    </div>
                </div>
            @endif
            <div
                class="rounded-xl p-4 mb-4 lg:p-6 bg-white dark:bg-zinc-900 border border-zinc-200 dark:border-zinc-700 shadow-card">
                <div class="flex items-center gap-4">
                    <!-- 💳 Balance Icon -->
                    <div class="shrink-0 bg-primary/10 text-primary rounded-full p-3 flex items-center justify-center">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                            <path fill="currentColor"
                                d="M19.435 4.065H4.565a2.5 2.5 0 0 0-2.5 2.5v10.87a2.5 2.5 0 0 0 2.5 2.5h14.87a2.5 2.5 0 0 0 2.5-2.5V6.565a2.5 2.5 0 0 0-2.5-2.5m1.5 9.93h-6.42a2 2 0 0 1 0-4h6.42Zm-6.42-5a3 3 0 0 0 0 6h6.42v2.44a1.5 1.5 0 0 1-1.5 1.5H4.565a1.5 1.5 0 0 1-1.5-1.5V6.565a1.5 1.5 0 0 1 1.5-1.5h14.87a1.5 1.5 0 0 1 1.5 1.5v2.43Z" />
                            <circle cx="14.519" cy="11.996" r="1" fill="currentColor" />
                        </svg>
                    </div>

                    <!-- 💰 Balance Details -->
                    <div class="flex flex-col">
                        <p class="text-sm text-muted leading-tight">Available Balance</p>
                        <h5 class="text-xl font-semibold text-gray-900 dark:text-gray-100">
                            ${{ number_format(Auth::user()->balance, 2) }}
                        </h5>
                    </div>
                </div>

            </div>
            <!--:Search results:-->
            <div
                class="rounded-xl bg-white dark:bg-zinc-900 shadow-card mb-4 border border-zinc-200 dark:border-zinc-700 relative">
                <div class="p-4 rounded-t-xl mb-2 lg:p-6 bg-white dark:bg-zinc-900 shadow-card">
                    <div class="flex items-center gap-2 px-4 my-4">
                        <div
                            class="shrink-0 flex items-center justify-center size-12 rounded-md bg-sky-500/10 text-sky-500">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 16 16">
                                <path fill="currentColor"
                                    d="M15.854.146a.5.5 0 0 1 .11.54l-5.819 14.547a.75.75 0 0 1-1.329.124l-3.178-4.995L.643 7.184a.75.75 0 0 1 .124-1.33L15.314.037a.5.5 0 0 1 .54.11ZM6.636 10.07l2.761 4.338L14.13 2.576zm6.787-8.201L1.591 6.602l4.339 2.76z" />
                            </svg>
                        </div>

                        <div>
                            <h5 class="text-xl font-semibold text-gray-900 dark:text-gray-100">
                                Swap Funds
                            </h5>
                            <p class="text-md">
                                Swap Funds between Your balance.</p>
                        </div>
                    </div>
                </div>
                <div class="p-4">
                    <form method="POST" action="{{ route('user.swapFunds') }}">
                        @csrf
                        <div class="flex lg:px-4 flex-wrap -mx-2">
                            <div class="w-full px-2 mb-4">
                                <label class="mb-1 block">Swap Balance</label>
                                <select name="from" class="input" required>
                                    <option value="">Select Source</option>
                                    <option value="profit">Profit Wallet (${{ number_format(Auth::user()->profit, 2) }})
                                    </option>
                                    <option value="bonus">Bonus Wallet (${{ number_format(Auth::user()->bonus, 2) }})
                                    </option>
                                </select>
                            </div>
                            <div class="w-full px-2 mb-4">
                                <label class="mb-1 block">Amount ($)</label>
                                <input type="number" name="amount" min="1" step="0.01" class="input" required>
                                @error('amount')
                                    <p class="text-red-400 text-sm mt-1">{{ $message }}</p>
                                @enderror
                            </div>
                        </div>
                        <!--:Page footer:-->
                        <div class="pb-4 px-2 mt-2 flex items-center w-full">
                            <button type="submit"
                                class="btn w-full bg-primary text-white hover:bg-primary-deep flex items-center h-12 justify-center gap-2">
                                <span class="icon-[lucide--send] text-lg leading-none"></span>
                                Make Swap
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

</x-user>