<x-user :title="$pageTitle">

    <!--:Page Header:-->
    <div class="px-4 lg:px-8 pt-4 pb-4 flex flex-col sm:flex-row sm:items-center">
        <div class="flex-grow mb-3 text-center sm:mb-0">
            <span class="ms-auto badge bg-amber-500/10 mb-2"
                style="display:inline-flex;align-items:center;gap:6px;font-weight:600;font-family:sans-serif;">
                <span style="
                                    position:relative;
                                    width:10px;height:10px;
                                    border-radius:50%;
                                    background:#e2d304;
                                    display:inline-block;
                                    animation:pulse 1.4s infinite;
                                "></span>
                <span class="ms-auto text-amber-500"> Verification Required</span>
            </span>
            <h2 class="text-2xl font-semibold mb-1 text-black dark:text-white">Kyc Verification</h2>
            <p>Complete your identity verification to unlock all features</p>
        </div>
    </div>

    <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-2">

    <!--:Page content:-->
    <div class="content flex-grow lg:px-2">
        <div class="px-2 py-4 max-w-4xl mx-auto">
            <div class="px-2 mb-4 gap-4">
                <!--:Card:-->
                <div
                    class="rounded-xl bg-white dark:bg-zinc-900 border-zinc-200 dark:border-zinc-800 border shadow-card p-4 sm:p-6 text-center">
                    <div class="flex justify-center mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" width="70" height="70" viewBox="0 0 24 24">
                            <g fill="none">
                                <path fill="#b5860f"
                                    d="m12 3l.197-.46a.5.5 0 0 0-.394 0zm0 18l-.248.434a.5.5 0 0 0 .496 0zm6.394-15.26l-.197.46zM8.024 18.727l-.249.435zM11.802 2.54L5.409 5.28l.394.92l6.394-2.74zM4.5 6.66v6.858h1V6.66zm3.275 12.502l3.977 2.272l.496-.868l-3.977-2.273zm4.473 2.272l3.977-2.272l-.496-.869l-3.977 2.273zm7.252-7.916V6.66h-1v6.86zm-.91-8.237l-6.393-2.74l-.394.919l6.394 2.74zm.91 1.378a1.5 1.5 0 0 0-.91-1.378l-.393.919a.5.5 0 0 1 .303.46zm-3.275 12.503a6.5 6.5 0 0 0 3.275-5.644h-1a5.5 5.5 0 0 1-2.771 4.775zM4.5 13.518a6.5 6.5 0 0 0 3.275 5.644l.496-.869A5.5 5.5 0 0 1 5.5 13.518zm.91-8.237a1.5 1.5 0 0 0-.91 1.378h1c0-.2.12-.38.303-.46z" />
                                <path stroke="#b5860f" stroke-linecap="round" stroke-linejoin="round"
                                    d="m15 10l-4 4l-2-2" stroke-width="1" />
                            </g>
                        </svg>
                    </div>
                    <h5 class="text-xl mb-2">Identity Verification Required</h5>
                    <p class="text-muted mb-6">
                        Complete your kyc verification to comply with regulations and access all features
                    </p>
                    <div class="flex items-center flex-wrap justify-center gap-4">
                        <a href="{{ url('user/start_verification') }}"
                            class="btn bg-sky-500/20 text-white hover:bg-primary-deep gap-2">
                            <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 24 24">
                                <path fill="currentColor"
                                    d="M11.46 1.137a1.75 1.75 0 0 1 1.08 0l8.25 2.675A1.75 1.75 0 0 1 22 5.476V10.5c0 6.19-3.77 10.705-9.401 12.83a1.7 1.7 0 0 1-1.198 0C5.771 21.204 2 16.69 2 10.5V5.476c0-.76.49-1.43 1.21-1.664Zm.617 1.426a.25.25 0 0 0-.154 0L3.673 5.24a.25.25 0 0 0-.173.237V10.5c0 5.461 3.28 9.483 8.43 11.426a.2.2 0 0 0 .14 0c5.15-1.943 8.43-5.965 8.43-11.426V5.476a.25.25 0 0 0-.173-.237ZM13 12.232V15a1 1 0 0 1-2 0v-2.768a2 2 0 1 1 2 0" />
                            </svg>
                            Start Verification</a>
                    </div>
                </div>
                <!--:Card:-->
                <div
                    class="p-4 lg:p-6 overflow-hidden mt-3 rounded-xl bg-white dark:bg-zinc-900 border-zinc-200 dark:border-zinc-800 border">
                    <div class="flex items-center justify-between">
                        <div class="flex-grow me-4">
                            <h6 class="text-xl mb-2 gap-1">Need Help<span class="text-yellow-600"> ?</span></h6>
                            <p class="mb-4 dark:text-white/70">Our Support team is ready to assist you with the
                                verification process</p>
                            <a href="{{ url('user/support') }}" type="button"
                                class="btn bg-sky-500/20 text-white hover:bg-primary-deep gap-2">Get
                                Support
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 28 28">
                                    <path fill="currentColor"
                                        d="M14 19a2 2 0 0 1-1.839-1.212a8 8 0 0 1-.951-.288l-.017-.006A8 8 0 0 1 8.708 16a8 8 0 1 1 13.257-6.75c.039.413-.3.75-.715.75c-.414 0-.745-.337-.793-.749A6.5 6.5 0 1 0 11.496 16l.04.017q.3.123.616.217a2 2 0 0 1 3.785 1.266A2 2 0 0 1 14 19m-7-1.5h1.169a9.6 9.6 0 0 1-1.518-1.48A3 3 0 0 0 4 19v.715C4 23.433 8.21 26 14 26s10-2.708 10-6.285V19a3 3 0 0 0-3-3h-3.645a3.5 3.5 0 0 1 .11 1.5H21l.145.007A1.5 1.5 0 0 1 22.5 19v.715l-.005.161c-.14 2.52-3.569 4.624-8.495 4.624c-5.111 0-8.5-2.111-8.5-4.785V19l.007-.145A1.5 1.5 0 0 1 7 17.5M19 10a5 5 0 0 1-2.644 4.411A3.5 3.5 0 0 0 14 13.5a3.5 3.5 0 1 0 0-7a3.5 3.5 0 0 0 0 7c-.908 0-1.734.346-2.355.912a5 5 0 0 1-1.932-1.838A5 5 0 1 1 19 10" />
                                </svg>
                            </a>
                        </div>
                        <div class="shrink-0 w-24">
                            <svg xmlns="http://www.w3.org/2000/svg" width="50" height="50" viewBox="0 0 28 28">
                                <path fill="currentColor"
                                    d="M14 19a2 2 0 0 1-1.839-1.212a8 8 0 0 1-.951-.288l-.017-.006A8 8 0 0 1 8.708 16a8 8 0 1 1 13.257-6.75c.039.413-.3.75-.715.75c-.414 0-.745-.337-.793-.749A6.5 6.5 0 1 0 11.496 16l.04.017q.3.123.616.217a2 2 0 0 1 3.785 1.266A2 2 0 0 1 14 19m-7-1.5h1.169a9.6 9.6 0 0 1-1.518-1.48A3 3 0 0 0 4 19v.715C4 23.433 8.21 26 14 26s10-2.708 10-6.285V19a3 3 0 0 0-3-3h-3.645a3.5 3.5 0 0 1 .11 1.5H21l.145.007A1.5 1.5 0 0 1 22.5 19v.715l-.005.161c-.14 2.52-3.569 4.624-8.495 4.624c-5.111 0-8.5-2.111-8.5-4.785V19l.007-.145A1.5 1.5 0 0 1 7 17.5M19 10a5 5 0 0 1-2.644 4.411A3.5 3.5 0 0 0 14 13.5a3.5 3.5 0 1 0 0-7a3.5 3.5 0 0 0 0 7c-.908 0-1.734.346-2.355.912a5 5 0 0 1-1.932-1.838A5 5 0 1 1 19 10" />
                            </svg>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

</x-user>