<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\AdminAuthController;

// ---------------------------
// PUBLIC ROUTES
// ---------------------------

// Admin Login (email or username)
Route::post('/admin/login', [AdminAuthController::class, 'adminLogin']);


// ---------------------------
// PROTECTED ADMIN ROUTES
// Requires: Authorization: Bearer {token}
// ---------------------------

Route::middleware('auth:sanctum')->group(function () {

    Route::post('/admin/logout', [AdminAuthController::class, 'adminLogout']);

    Route::get('/admin/dashboard', function (Request $request) {

        if ($request->user()->role !== 'admin') {
            return response()->json([
                'message' => 'Access denied. Admins only.',
            ], 403);
        }

        return response()->json([
            'status'  => 'success',
            'message' => 'Welcome Admin Dashboard',
            'admin'   => $request->user(),
        ]);
    });


    Route::get('/admin/users', function () {
        return \App\Models\User::all();
    });

    // Example: Admin-only statistics
    Route::get('/admin/stats', function () {
        return [
            'users'        => \App\Models\User::count(),
            'today_logins' => 15,
            'system'       => 'Admin API Ready',
        ];
    });
});


Route::get('/ping', function () {
    return "PONG";
});
