<?php if (isset($component)) { $__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.user','data' => ['title' => $pageTitle]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($pageTitle)]); ?>
    <div class="content flex-grow lg:px-12">
        <!--:Page Header:-->
        <div class="px-4 py-8 lg:py-12 rounded-b-xl bg-gradient-to-t from-white dark:from-zinc-900">
            <div class="text-center">
                <h4 class="text-xl lg:text-2xl mb-2">My Investments</h4>
                <p class="max-w-sm mx-auto mb-4">
                    Track and manage your active investment portfolios
                </p>
            </div>
        </div>

        <div class="content flex flex-col flex-grow lg:px-4 w-full">
            <div class="px-2 mt-2">
                <div
                    class="mb-4 p-4 rounded-xl bg-white dark:bg-zinc-900 shadow-card overflow-hidden border border-zinc-200 dark:border-zinc-700">
                    <div class="grid grid-cols-2 md:grid-cols-4 gap-4 text-center">
                        <!--:Card:-->
                        <div
                            class="overflow-hidden p-4 rounded-xl flex flex-col items-center justify-center text-center">
                            <div
                                class="flex items-center justify-center mb-3 size-10 rounded-full shrink-0 bg-sky-500/10 text-sky-500">
                                <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                    viewBox="0 0 20 20">
                                    <path fill="currentColor"
                                        d="M2 11a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v5a1 1 0 0 1-1 1H3a1 1 0 0 1-1-1zm6-4a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v9a1 1 0 0 1-1 1H9a1 1 0 0 1-1-1zm6-3a1 1 0 0 1 1-1h2a1 1 0 0 1 1 1v12a1 1 0 0 1-1 1h-2a1 1 0 0 1-1-1z" />
                                </svg>
                            </div>
                            <h5 class="text-xl font-semibold mb-1 text-gray-800 dark:text-gray-100">
                                <?php echo e($totalInvestments); ?>

                            </h5>
                            <p class="mb-1 text-sm text-gray-500 dark:text-gray-400">Total Plans</p>
                        </div>

                        <!--:Card:-->
                        <div
                            class="overflow-hidden p-4 rounded-xl flex flex-col items-center justify-center text-center">
                            <div
                                class="flex items-center justify-center mb-3 size-10 rounded-full shrink-0 bg-green-500/10 text-green-500">
                                <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                    viewBox="0 0 24 24">
                                    <path fill="currentColor"
                                        d="M13.75 9a.75.75 0 0 1 .75-.75H18a.75.75 0 0 1 .75.75v3.5a.75.75 0 0 1-1.5 0v-1.69l-4.72 4.72a.75.75 0 0 1-1.06 0L9 13.06l-2.47 2.47a.75.75 0 0 1-1.06-1.06l3-3a.75.75 0 0 1 1.06 0L12 13.94l4.19-4.19H14.5a.75.75 0 0 1-.75-.75" />
                                </svg>
                            </div>
                            <h5 class="text-xl font-semibold mb-1 text-gray-800 dark:text-gray-100">
                                <?php echo e($activeInvestments); ?>

                            </h5>
                            <p class="mb-1 text-sm text-gray-500 dark:text-gray-400">Active</p>
                        </div>

                        <!--:Card:-->
                        <div
                            class="overflow-hidden p-4 rounded-xl flex flex-col items-center justify-center text-center">
                            <div
                                class="flex items-center justify-center mb-3 size-10 rounded-full shrink-0 bg-red-500/10 text-red-500">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    viewBox="0 0 24 24">
                                    <path fill="currentColor"
                                        d="M21 11a1 1 0 0 0-1 1v2.59l-6.29-6.3a1 1 0 0 0-1.42 0L9 11.59l-5.29-5.3a1 1 0 0 0-1.42 1.42l6 6a1 1 0 0 0 1.42 0l3.29-3.3L18.59 16H16a1 1 0 0 0 0 2h5a1 1 0 0 0 .38-.08a1 1 0 0 0 .54-.54A1 1 0 0 0 22 17v-5a1 1 0 0 0-1-1" />
                                </svg>
                            </div>
                            <h5 class="text-xl font-semibold mb-1 text-gray-800 dark:text-gray-100">
                                <?php echo e($completedInvestments); ?>

                            </h5>
                            <p class="mb-1 text-sm text-gray-500 dark:text-gray-400">Expired</p>
                        </div>

                        <!--:Card:-->
                        <div
                            class="overflow-hidden p-4 rounded-xl flex flex-col items-center justify-center text-center">
                            <div
                                class="flex items-center justify-center mb-3 size-10 rounded-full shrink-0 bg-amber-500/10 text-amber-500">
                                <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                    viewBox="0 0 14 14">
                                    <g fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="1">
                                        <path
                                            d="M7 13.5c3.5 0 6-1.238 6-3.994c0-2.995-1.5-4.992-4.5-6.49l1.18-1.518A.658.658 0 0 0 9.12.5H4.88a.66.66 0 0 0-.56.998L5.5 3.026C2.5 4.534 1 6.531 1 9.526C1 12.262 3.5 13.5 7 13.5" />
                                        <path
                                            d="M8.383 6.806a1.08 1.08 0 0 0-1.022-.723h-.838a.967.967 0 0 0-.207 1.912l1.277.28a1.084 1.084 0 0 1-.232 2.142H6.64c-.472 0-.873-.302-1.022-.722M7 6.083V5m0 6.5v-1.083" />
                                    </g>
                                </svg>
                            </div>
                            <h5 class="text-xl font-semibold mb-1 text-gray-800 dark:text-gray-100">
                                $<?php echo e(number_format($totalAmountInvested, 2)); ?>

                            </h5>
                            <p class="mb-1 text-sm text-gray-500 dark:text-gray-400">Total Invested</p>
                        </div>
                    </div>
                    <hr class="border-zinc-200 dark:border-zinc-800 border-dashed my-3">
                </div>
            </div>

            <div class="px-2 grid grid-cols-1 gap-4 mb-4">
                <!--:Card:-->
                <?php $__empty_2 = true; $__currentLoopData = $investments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                    <div
                        class="rounded-xl bg-white dark:bg-zinc-900 border border-zinc-200 dark:border-zinc-700 shadow-card overflow-hidden relative">
                        <div class="p-4">
                            <div class="flex flex-wrap items-start justify-between">
                                <div class="flex items-center gap-3">
                                    <!-- Icon inside a background span -->
                                    <span
                                        class="bg-blue-500/10 text-blue-500 rounded-xl p-3 flex items-center justify-center">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="27" height="27"
                                            viewBox="0 0 32 32">
                                            <path fill="currentColor"
                                                d="M21 4v24h8V4zm2 2h4v20h-4zM3 10v18h8V10zm2 2h4v14H5zm7 4v12h8V16zm2 2h4v8h-4z" />
                                        </svg>
                                    </span>

                                    <!-- Plan name and description -->
                                    <div>
                                        <h3 class="text-xl font-semibold mb-1"><?php echo e($item->plan->name); ?></h3>
                                    </div>
                                </div>
                                <!--:Legend:-->
                                <div class="flex flex-wrap gap-3 pt-4">
                                    <span class="badge bg-primary-subtle text-primary">
                                        <p class="text-zinc-400 text-sm flex items-center gap-2">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                                viewBox="0 0 24 24" class="shrink-0">
                                                <g fill="none" stroke="currentColor" stroke-width="1.5">
                                                    <circle cx="12" cy="12" r="10" opacity="0.5" />
                                                    <path stroke-linecap="round"
                                                        d="M12 6v12m3-8.5C15 8.12 13.657 7 12 7S9 8.12 9 9.5s1.343 2.5 3 2.5s3 1.12 3 2.5s-1.343 2.5-3 2.5s-3-1.12-3-2.5" />
                                                </g>
                                            </svg>
                                            Investment Amount:
                                            <span class="font-semibold">$<?php echo e($item->amount); ?></span>
                                        </p>
                                    </span>
                                    <span class="badge bg-sky-500/10 text-sky-500">
                                        <p class="text-zinc-400 text-sm flex items-center gap-2">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                                viewBox="0 0 24 24" class="shrink-0">
                                                <path fill="currentColor"
                                                    d="M13.75 9a.75.75 0 0 1 .75-.75H18a.75.75 0 0 1 .75.75v3.5a.75.75 0 0 1-1.5 0v-1.69l-4.72 4.72a.75.75 0 0 1-1.06 0L9 13.06l-2.47 2.47a.75.75 0 0 1-1.06-1.06l3-3a.75.75 0 0 1 1.06 0L12 13.94l4.19-4.19H14.5a.75.75 0 0 1-.75-.75" />
                                            </svg>
                                            Expected ROI:
                                            <span
                                                class="text-green-500 font-semibold"><?php echo e($item->plan->interest_rate); ?>%</span>
                                        </p>
                                    </span>
                                    <span class="badge bg-blue-500/10 text-blue-500">
                                        <p class="text-zinc-400 text-sm  flex items-center gap-2">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                                viewBox="0 0 24 24" class="shrink-0">
                                                <path fill="currentColor" fill-rule="evenodd"
                                                    d="m12.6 11.503l3.891 3.891l-.848.849L11.4 12V6h1.2zM12 22C6.477 22 2 17.523 2 12S6.477 2 12 2s10 4.477 10 10s-4.477 10-10 10m0-1.2a8.8 8.8 0 1 0 0-17.6a8.8 8.8 0 0 0 0 17.6" />
                                            </svg>
                                            Expiration:
                                            <span id="countdown-<?php echo e($item->id); ?>" class="font-semibold"></span>
                                        </p>
                                    </span>
                                    <span
                                        class="badge  <?php if($item->status === 'active'): ?> bg-green-500/10 text-green-500
                                <?php elseif($item->status === 'completed'): ?> bg-blue-500/10 text-blue-500
                                    <?php elseif($item->status === 'pending'): ?> bg-amber-500/10 text-amber-500
                                        <?php else: ?> bg-red-500/10 text-red-500 <?php endif; ?>">
                                        <div
                                            class="w-1.5 h-1.5 rounded-full mr-1.5
                                                                            <?php if($item->status === 'active'): ?> bg-green-500
                                                                            <?php elseif($item->status === 'completed'): ?> bg-blue-500
                                                                            <?php elseif($item->status === 'pending'): ?> bg-amber-500
                                                                            <?php else: ?> bg-red-500 <?php endif; ?>">
                                        </div>
                                        <?php echo e(ucfirst($item->status)); ?>

                                    </span>
                                    </span>
                                    <a href="<?php echo e(url('user/investment_details/' . $item->id)); ?>"
                                        class="btn btn-sm bg-zinc-500/20 gap-1">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                            viewBox="0 0 24 24">
                                            <path fill="currentColor"
                                                d="M11.5 18c4 0 7.46-2.22 9.24-5.5C18.96 9.22 15.5 7 11.5 7s-7.46 2.22-9.24 5.5C4.04 15.78 7.5 18 11.5 18m0-12c4.56 0 8.5 2.65 10.36 6.5C20 16.35 16.06 19 11.5 19S3 16.35 1.14 12.5C3 8.65 6.94 6 11.5 6m0 2C14 8 16 10 16 12.5S14 17 11.5 17S7 15 7 12.5S9 8 11.5 8m0 1A3.5 3.5 0 0 0 8 12.5a3.5 3.5 0 0 0 3.5 3.5a3.5 3.5 0 0 0 3.5-3.5A3.5 3.5 0 0 0 11.5 9" />
                                        </svg> View Details
                                    </a>
                                </div>
                            </div>
                            <div class="h-8"></div>
                            <div class="flex items-center pb-4">
                                <?php
                                    $start = \Carbon\Carbon::parse($item->start_date);
                                    $end = \Carbon\Carbon::parse($item->end_date);
                                    $now = \Carbon\Carbon::now();

                                    $totalSeconds = $start->diffInSeconds($end);
                                    $elapsedSeconds = $start->isPast() ? $start->diffInSeconds($now) : 0;
                                    $progress =
                                        $totalSeconds > 0
                                            ? min(100, max(0, ($elapsedSeconds / $totalSeconds) * 100))
                                            : 0;

                                    $remaining = $now->lt($end)
                                        ? $now->diffForHumans($end, [
                                            'parts' => 2,
                                            'join' => true,
                                            'short' => true,
                                            'syntax' => \Carbon\CarbonInterface::DIFF_RELATIVE_TO_NOW,
                                        ])
                                        : 'Completed';

                                    // ✅ Determine progress bar color based on progress %
                                    if ($progress < 25) {
                                        $progressColor = 'bg-primary';
                                    } elseif ($progress < 50) {
                                        $progressColor = 'bg-amber-500/20';
                                    } elseif ($progress < 75) {
                                        $progressColor = 'bg-sky-500';
                                    } else {
                                        $progressColor = 'bg-green-500/30';
                                    }
                                ?>

                                <!-- ✅ Progress Bar -->
                                <div class="progress flex-grow h-2 rounded-full overflow-hidden bg-primary-subtle"
                                    role="progressbar" aria-label="Investment Progress"
                                    aria-valuenow="<?php echo e(round($progress, 2)); ?>" aria-valuemin="0" aria-valuemax="100">
                                    <div class="<?php echo e($progressColor); ?> h-2 transition-all duration-500"
                                        style="width: <?php echo e($progress); ?>%;"></div>
                                </div>

                                <!-- ✅ Percentage Display -->
                                <div class="text-right text-xs text-zinc-400 px-1">
                                    <?php echo e(round($progress, 1)); ?>%
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                <?php endif; ?>
            </div>
        </div>
    </div>


    <script>
        document.addEventListener('DOMContentLoaded', function() {
            <?php $__currentLoopData = $investments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                const endDate<?php echo e($item->id); ?> = new Date(
                    "<?php echo e(\Carbon\Carbon::parse($item->end_date)); ?>").getTime();

                const countdownFunc<?php echo e($item->id); ?> = setInterval(function() {
                    const now = new Date().getTime();
                    const distance = endDate<?php echo e($item->id); ?> - now;

                    if (distance <= 0) {
                        clearInterval(countdownFunc<?php echo e($item->id); ?>);
                        document.getElementById("countdown-<?php echo e($item->id); ?>").innerHTML = "Completed";
                        const mobile = document.getElementById("countdown-mobile-<?php echo e($item->id); ?>");
                        if (mobile) mobile.innerHTML = "Completed";
                        return;
                    }

                    const days = Math.floor(distance / (1000 * 60 * 60 * 24));
                    const hours = Math.floor((distance % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
                    const minutes = Math.floor((distance % (1000 * 60 * 60)) / (1000 * 60));
                    const seconds = Math.floor((distance % (1000 * 60)) / 1000);

                    const formatted = `${days}d ${hours}h ${minutes}m ${seconds}s`;
                    document.getElementById("countdown-<?php echo e($item->id); ?>").innerHTML = formatted;

                    const mobile = document.getElementById("countdown-mobile-<?php echo e($item->id); ?>");
                    if (mobile) mobile.innerHTML = formatted;
                }, 1000);
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1)): ?>
<?php $attributes = $__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1; ?>
<?php unset($__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1)): ?>
<?php $component = $__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1; ?>
<?php unset($__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1); ?>
<?php endif; ?>
<?php /**PATH /home/allejouk/Desktop/work/NEW BINARY/resources/views/user/portfolio.blade.php ENDPATH**/ ?>