<!DOCTYPE html>
<html lang="en" class="dark">

<head>
    <?php echo $__env->make('layouts.home.head', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
</head>

<body class="antialiased text-gray-200 bg-gray-900 font-sans min-h-screen flex flex-col">
    <!-- Accessibility Skip Link -->
    <a href="<?php echo e(url('/')); ?>#main-content"
        class="sr-only focus:not-sr-only focus:bg-blue-700 focus:text-white focus:fixed focus:px-4 focus:py-2 focus:top-2 focus:left-2 focus:z-50">
        Skip to main content
    </a>

    <!-- Header -->
    <header class="bg-gray-900 border-b border-gray-800 relative z-50">
        <!-- Top Navigation Bar -->
        <div x-data="{ mobileMenuOpen: false }" class="max-w-7xl w-full mx-auto px-4 sm:px-6 lg:px-8">
            <div class="relative">
                <div class="flex items-center justify-between h-16">
                    <!-- Logo -->
                    <div class="flex-shrink-0">
                        <a href="<?php echo e(url('/')); ?>" class="flex items-center">
                            <img class="h-8 w-auto" src="<?php echo e(asset('upload/' . $websiteSettings->site_logo)); ?>"
                                alt="<?php echo e($websiteSettings->site_name); ?>">
                        </a>
                    </div>

                    <!-- Main Navigation - Desktop -->
                    <nav class="hidden md:flex space-x-8">
                        <?php echo $__env->make('layouts.home.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </nav>

                    <!-- Right Navigation -->
                    <div class="hidden md:flex items-center">

                        <div class="flex items-center space-x-4">
                            <a href="<?php echo e(url('login')); ?>" class="text-gray-200 hover:text-white flex items-center">
                                <i class="fas fa-lock mr-1"></i>
                                <span>Log in</span>
                            </a>
                            <a href="<?php echo e(url('register')); ?>"
                                class="bg-blue-600 hover:bg-blue-700 text-white px-4 py-2 rounded-md text-sm font-medium transition-colors">
                                Sign up
                            </a>
                        </div>
                    </div>

                    <!-- Mobile menu button and theme toggle -->
                    <div class="flex md:hidden items-center space-x-2">
                        <!-- Mobile Menu Toggle -->
                        <button @click="mobileMenuOpen = !mobileMenuOpen" type="button"
                            class="inline-flex items-center justify-center p-2 rounded-md text-gray-400 hover:text-white hover:bg-gray-700 focus:outline-none focus:ring-2 focus:ring-inset focus:ring-white"
                            aria-controls="mobile-menu" aria-expanded="false">
                            <span class="sr-only">Open main menu</span>
                            <svg x-show="!mobileMenuOpen" class="block h-6 w-6" xmlns="http://www.w3.org/2000/svg"
                                fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M4 6h16M4 12h16M4 18h16" />
                            </svg>
                            <svg x-show="mobileMenuOpen" class="block h-6 w-6" xmlns="http://www.w3.org/2000/svg"
                                fill="none" viewBox="0 0 24 24" stroke="currentColor" aria-hidden="true"
                                style="display: none;">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                                    d="M6 18L18 6M6 6l12 12" />
                            </svg>
                        </button>
                    </div>
                </div>
            </div>

            <!-- Mobile menu -->
            <div x-show="mobileMenuOpen" class="md:hidden" id="mobile-menu" style="display: none;">
                <?php echo $__env->make('layouts.home.mobilenav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
            </div>

        </div>
    </header>



    <!--  sub menu -->

    <!-- Market Ticker Widget -->
    <div class="bg-dark-300 border-b border-gray-800">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="py-1">
                <script defer src="https://www.livecoinwatch.com/static/lcw-widget.js"></script>
                <div class="livecoinwatch-widget-5" lcw-base="USD" lcw-color-tx="#999999" lcw-marquee-1="coins"
                    lcw-marquee-2="none" lcw-marquee-items="10"></div>
            </div>
        </div>
    </div>

    <!-- Main Content Area -->
    <main id="main-content" class="flex-grow">

        <?php echo e($slot); ?>


    </main>


    <!-- Footer -->
    <footer class="bg-dark-400 text-gray-300">
        <?php echo $__env->make('layouts.home.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </footer>


    <style>
        .notification-popup {
            position: fixed;
            z-index: 1000;
            bottom: 20px;
            right: 20px;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            border-radius: 12px;
            padding: 16px 20px;
            box-shadow: 0 20px 25px -5px rgba(0, 0, 0, 0.1), 0 10px 10px -5px rgba(0, 0, 0, 0.04);
            border: 1px solid rgba(255, 255, 255, 0.1);
            backdrop-filter: blur(10px);
            max-width: 350px;
            min-width: 280px;
            transform: translateX(400px);
            opacity: 0;
            transition: all 0.4s cubic-bezier(0.4, 0, 0.2, 1);
        }

        .notification-popup.show {
            transform: translateX(0);
            opacity: 1;
        }

        .notification-popup .notification-header {
            display: flex;
            align-items: center;
            margin-bottom: 8px;
        }

        .notification-popup .notification-icon {
            width: 24px;
            height: 24px;
            background: rgba(255, 255, 255, 0.2);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 8px;
            font-size: 12px;
            color: #fff;
        }

        .notification-popup .notification-title {
            color: #fff;
            font-weight: 600;
            font-size: 14px;
            opacity: 0.9;
        }

        .notification-popup .notification-content {
            color: #fff;
            font-size: 13px;
            line-height: 1.4;
            margin-bottom: 12px;
        }

        .notification-popup .notification-content b {
            font-weight: 700;
            color: #FFD700;
        }

        .notification-popup .notification-content a {
            color: #FFD700;
            text-decoration: none;
            font-weight: 600;
            border-bottom: 1px solid transparent;
            transition: border-color 0.2s ease;
        }

        .notification-popup .notification-content a:hover {
            border-bottom-color: #FFD700;
        }

        .notification-popup .notification-footer {
            display: flex;
            justify-content: space-between;
            align-items: center;
            font-size: 11px;
            color: rgba(255, 255, 255, 0.7);
        }

        .notification-popup .notification-time {
            font-style: italic;
        }

        .notification-popup .notification-close {
            background: none;
            border: none;
            color: rgba(255, 255, 255, 0.7);
            font-size: 14px;
            cursor: pointer;
            padding: 2px;
            border-radius: 3px;
            transition: color 0.2s ease;
        }

        .notification-popup .notification-close:hover {
            color: #fff;
        }

        .notification-popup .progress-bar {
            position: absolute;
            bottom: 0;
            left: 0;
            height: 3px;
            background: rgba(255, 215, 0, 0.8);
            border-radius: 0 0 12px 12px;
            transition: width linear;
        }

        /* Dark mode adjustments */
        html.dark .notification-popup {
            background: linear-gradient(135deg, #1e3a8a 0%, #3730a3 100%);
            border-color: rgba(255, 255, 255, 0.1);
        }

        /* Mobile responsiveness */
        @media (max-width: 640px) {
            .notification-popup {
                right: 10px;
                bottom: 80px;
                max-width: calc(100vw - 20px);
                min-width: auto;
            }
        }

        /* Animation keyframes */
        @keyframes slideInRight {
            from {
                transform: translateX(400px);
                opacity: 0;
            }

            to {
                transform: translateX(0);
                opacity: 1;
            }
        }

        @keyframes slideOutRight {
            from {
                transform: translateX(0);
                opacity: 1;
            }

            to {
                transform: translateX(400px);
                opacity: 0;
            }
        }

        .notification-popup.animate-in {
            animation: slideInRight 0.4s cubic-bezier(0.4, 0, 0.2, 1) forwards;
        }

        .notification-popup.animate-out {
            animation: slideOutRight 0.3s cubic-bezier(0.4, 0, 0.2, 1) forwards;
        }
    </style>

    <div class="notification-popup" id="tradingNotification" style="display: none;">
        <div class="notification-header">
            <div class="notification-icon">
                <i class="fas fa-chart-line"></i>
            </div>
            <div class="notification-title">Live Trading Activity</div>
            <button class="notification-close ml-auto" onclick="closeNotification()">
                <i class="fas fa-times"></i>
            </button>
        </div>
        <div class="notification-content" id="notificationText"></div>
        <div class="notification-footer">
            <span class="notification-time" id="notificationTime"></span>
            <span style="font-size: 10px;">🟢 Live</span>
        </div>
        <div class="progress-bar" id="progressBar"></div>
    </div>
    <script data-cfasync="false" src="<?php echo e(url('/')); ?>#"></script>
    <script type="text/javascript">
        class TradingNotificationManager {
            constructor() {
                this.listCountries = [
                    'New York', 'London', 'Tokyo', 'Singapore', 'Frankfurt', 'Sydney', 'Dubai', 'Hong Kong',
                    'Toronto', 'Zurich', 'Paris', 'Amsterdam', 'Stockholm', 'Copenhagen', 'Milan', 'Madrid',
                    'Seoul', 'Mumbai', 'São Paulo', 'Mexico City', 'Buenos Aires', 'Cairo', 'Johannesburg',
                    'Moscow', 'Istanbul', 'Bangkok', 'Jakarta', 'Manila', 'Ho Chi Minh City', 'Kuala Lumpur',
                    'Tel Aviv', 'Warsaw', 'Prague', 'Budapest', 'Vienna', 'Brussels', 'Oslo', 'Helsinki',
                    'Dublin', 'Lisbon', 'Athens', 'Bucharest', 'Sofia', 'Zagreb', 'Sarajevo', 'Belgrade',
                    'Skopje', 'Podgorica', 'Tirana', 'Pristina'
                ];

                this.listAmounts = [
                    '$1,250', '$2,500', '$5,000', '$7,500', '$10,000', '$15,000', '$25,000', '$50,000',
                    '$75,000', '$100,000', '$150,000', '$200,000', '$3,450', '$8,900', '$12,340', '$18,750',
                    '$22,100', '$35,680', '$47,230', '$65,420', '$89,150', '$125,000', '$175,000', '$225,000'
                ];

                this.transactionTypes = [{
                        action: 'invested',
                        icon: 'fa-chart-line',
                        color: '#10B981'
                    },
                    {
                        action: 'withdrawn',
                        icon: 'fa-money-bill-wave',
                        color: '#3B82F6'
                    },
                    {
                        action: 'earned',
                        icon: 'fa-trophy',
                        color: '#F59E0B'
                    }
                ];

                this.instruments = [
                    'Bitcoin', 'Ethereum', 'Apple Stock', 'Tesla Stock', 'Gold', 'Oil', 'EUR/USD', 'GBP/USD',
                    'USD/JPY', 'AUD/USD', 'Nvidia Stock', 'Microsoft Stock', 'Amazon Stock', 'Google Stock',
                    'S&P 500', 'NASDAQ 100', 'Dow Jones', 'Silver', 'Crude Oil', 'Natural Gas'
                ];

                this.currentNotification = null;
                this.interval = null;
                this.isActive = true;
                this.displayDuration = 10000; // 45 seconds - much longer than before
                this.intervalRange = {
                    min: 8000,
                    max: 20000
                }; // 8-20 seconds between notifications

                this.init();
            }

            init() {
                this.scheduleNext();
            }

            getRandomElement(array) {
                return array[Math.floor(Math.random() * array.length)];
            }

            getRandomAmount() {
                return this.getRandomElement(this.listAmounts);
            }

            getRandomCountry() {
                return this.getRandomElement(this.listCountries);
            }

            getRandomTransaction() {
                return this.getRandomElement(this.transactionTypes);
            }

            getRandomInstrument() {
                return this.getRandomElement(this.instruments);
            }

            formatTime() {
                return new Date().toLocaleTimeString('en-US', {
                    hour12: false,
                    hour: '2-digit',
                    minute: '2-digit'
                });
            }

            createNotificationMessage() {
                const country = this.getRandomCountry();
                const transaction = this.getRandomTransaction();
                const amount = this.getRandomAmount();
                const instrument = this.getRandomInstrument();

                let message = '';

                switch (transaction.action) {
                    case 'invested':
                        message =
                            `Trader from <b>${country}</b> just <b>invested</b> <a href="javascript:void(0);" onclick="javascript:void(0);">${amount}</a> in ${instrument}`;
                        break;
                    case 'withdrawn':
                        message =
                            `Trader from <b>${country}</b> successfully <b>withdrew</b> <a href="javascript:void(0);" onclick="javascript:void(0);">${amount}</a> from their account`;
                        break;
                    case 'earned':
                        message =
                            `Trader from <b>${country}</b> just <b>earned</b> <a href="javascript:void(0);" onclick="javascript:void(0);">${amount}</a> trading ${instrument}`;
                        break;
                }

                return {
                    message,
                    transaction
                };
            }

            showNotification() {
                if (!this.isActive) return;

                const notification = document.getElementById('tradingNotification');
                const textElement = document.getElementById('notificationText');
                const timeElement = document.getElementById('notificationTime');
                const progressBar = document.getElementById('progressBar');

                if (!notification || !textElement || !timeElement || !progressBar) return;

                const {
                    message,
                    transaction
                } = this.createNotificationMessage();

                // Update content
                textElement.innerHTML = message;
                timeElement.textContent = this.formatTime();

                // Update icon color based on transaction type
                const icon = notification.querySelector('.notification-icon');
                if (icon) {
                    icon.style.background = transaction.color + '40'; // 40 for opacity
                }

                // Show notification with animation
                notification.style.display = 'block';
                setTimeout(() => {
                    notification.classList.add('show', 'animate-in');
                }, 100);

                // Progress bar animation
                progressBar.style.width = '100%';
                progressBar.style.transition = `width ${this.displayDuration}ms linear`;

                setTimeout(() => {
                    progressBar.style.width = '0%';
                }, 200);

                // Auto hide after display duration
                this.currentNotification = setTimeout(() => {
                    this.hideNotification();
                }, this.displayDuration);
            }

            hideNotification() {
                const notification = document.getElementById('tradingNotification');
                const progressBar = document.getElementById('progressBar');

                if (!notification) return;

                // Clear any existing timeout
                if (this.currentNotification) {
                    clearTimeout(this.currentNotification);
                    this.currentNotification = null;
                }

                // Hide with animation
                notification.classList.remove('animate-in');
                notification.classList.add('animate-out');

                setTimeout(() => {
                    notification.classList.remove('show', 'animate-out');
                    notification.style.display = 'none';

                    // Reset progress bar
                    progressBar.style.width = '100%';
                    progressBar.style.transition = 'none';

                    // Schedule next notification
                    this.scheduleNext();
                }, 300);
            }

            scheduleNext() {
                if (!this.isActive) return;

                const delay = Math.floor(
                    Math.random() * (this.intervalRange.max - this.intervalRange.min + 1) +
                    this.intervalRange.min
                );

                if (this.interval) {
                    clearTimeout(this.interval);
                }

                this.interval = setTimeout(() => {
                    this.showNotification();
                }, delay);
            }

            pause() {
                this.isActive = false;
                if (this.interval) {
                    clearTimeout(this.interval);
                    this.interval = null;
                }
                if (this.currentNotification) {
                    clearTimeout(this.currentNotification);
                    this.currentNotification = null;
                }
                this.hideNotification();
            }

            resume() {
                this.isActive = true;
                this.scheduleNext();
            }

            destroy() {
                this.pause();
                const notification = document.getElementById('tradingNotification');
                if (notification) {
                    notification.style.display = 'none';
                }
            }
        }

        // Global functions for notification control
        function closeNotification() {
            if (window.tradingNotificationManager) {
                window.tradingNotificationManager.hideNotification();
            }
        }

        function pauseNotifications() {
            if (window.tradingNotificationManager) {
                window.tradingNotificationManager.pause();
            }
        }

        function resumeNotifications() {
            if (window.tradingNotificationManager) {
                window.tradingNotificationManager.resume();
            }
        }

        // Initialize when DOM is ready
        document.addEventListener('DOMContentLoaded', function() {
            // Small delay to ensure everything is loaded
            setTimeout(() => {
                window.tradingNotificationManager = new TradingNotificationManager();
            }, 500); // Reduced from 2000ms to 500ms
        });

        // Pause notifications when user is inactive
        let userActiveTimeout;

        function resetUserActiveTimer() {
            clearTimeout(userActiveTimeout);
            if (window.tradingNotificationManager && !window.tradingNotificationManager.isActive) {
                resumeNotifications();
            }

            userActiveTimeout = setTimeout(() => {
                pauseNotifications();
            }, 300000); // Pause after 5 minutes of inactivity
        }

        // Listen for user activity
        ['mousedown', 'mousemove', 'keypress', 'scroll', 'touchstart', 'click'].forEach(event => {
            document.addEventListener(event, resetUserActiveTimer, true);
        });

        // Initialize user activity timer
        resetUserActiveTimer();
    </script>

    <!-- Live Chat Button -->


    <!-- GetButton.io widget -->
    
    <!-- Additional Scripts -->
    

</body>

</html>
<?php /**PATH /home/allejouk/Desktop/work/NEW BINARY/resources/views/components/home.blade.php ENDPATH**/ ?>