<?php if($paginator->hasPages()): ?>
    <ul class="flex items-center gap-0.5 sm:flex">
        
        <?php if($paginator->onFirstPage()): ?>
            <li class="opacity-50 cursor-not-allowed">
                <span class="flex h-10 w-10 items-center justify-center rounded-lg text-gray-500">‹</span>
            </li>
        <?php else: ?>
            <li>
                <a href="<?php echo e($paginator->previousPageUrl()); ?>"
                    class="flex h-10 w-10 items-center justify-center rounded-lg text-gray-700 hover:bg-brand-500/[0.08] hover:text-brand-500 dark:text-gray-400 dark:hover:text-brand-500">‹</a>
            </li>
        <?php endif; ?>

        
        <?php $__currentLoopData = $elements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $element): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php if(is_string($element)): ?>
                <li><span
                        class="flex h-10 w-10 items-center justify-center rounded-lg text-gray-400"><?php echo e($element); ?></span>
                </li>
            <?php endif; ?>

            <?php if(is_array($element)): ?>
                <?php $__currentLoopData = $element; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page => $url): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php if($page == $paginator->currentPage()): ?>
                        <li>
                            <span
                                class="bg-brand-500/[0.08] text-brand-500 flex h-10 w-10 items-center justify-center rounded-lg font-medium">
                                <?php echo e($page); ?>

                            </span>
                        </li>
                    <?php else: ?>
                        <li>
                            <a href="<?php echo e($url); ?>"
                                class="text-theme-sm hover:bg-brand-500/[0.08] hover:text-brand-500 dark:hover:text-brand-500 flex h-10 w-10 items-center justify-center rounded-lg font-medium text-gray-700 dark:text-gray-400">
                                <?php echo e($page); ?>

                            </a>
                        </li>
                    <?php endif; ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endif; ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

        
        <?php if($paginator->hasMorePages()): ?>
            <li>
                <a href="<?php echo e($paginator->nextPageUrl()); ?>"
                    class="flex h-10 w-10 items-center justify-center rounded-lg text-gray-700 hover:bg-brand-500/[0.08] hover:text-brand-500 dark:text-gray-400 dark:hover:text-brand-500">›</a>
            </li>
        <?php else: ?>
            <li class="opacity-50 cursor-not-allowed">
                <span class="flex h-10 w-10 items-center justify-center rounded-lg text-gray-500">›</span>
            </li>
        <?php endif; ?>
    </ul>
<?php endif; ?>
<?php /**PATH /home/allejouk/Desktop/work/NEW BINARY/resources/views/vendor/pagination/custom.blade.php ENDPATH**/ ?>