<?php if (isset($component)) { $__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.user','data' => ['title' => $pageTitle]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($pageTitle)]); ?>
    <div class="content flex-grow lg:px-4">
        <div class="px-2 py-4 max-w-7xl mx-auto">
            <div class="px-4 lg:px-8 pt-4 pb-4 flex flex-col sm:flex-row sm:items-center mb-4">
                <div class="flex-grow mb-3 sm:mb-0">
                    <h2 class="flex text-2xl font-semibold mb-1 text-black dark:text-white gap-2">
                        <svg xmlns="http://www.w3.org/2000/svg" width="30" height="30" viewBox="0 0 48 48">
                            <path fill="#00bcd4"
                                d="M37 18h6v24h-6zm-8 8h6v16h-6zm-8-4h6v20h-6zm-8 10h6v10h-6zm-8-4h6v14H5z" />
                            <g fill="#3f51b5">
                                <circle cx="8" cy="16" r="3" />
                                <circle cx="16" cy="18" r="3" />
                                <circle cx="24" cy="11" r="3" />
                                <circle cx="32" cy="13" r="3" />
                                <circle cx="40" cy="9" r="3" />
                                <path d="m39.1 7.2l-7.3 3.7l-8.3-2.1l-8 7l-7-1.7l-1 3.8l9 2.3l8-7l7.7 1.9l8.7-4.3z" />
                            </g>
                        </svg> Investment Plans
                    </h2>
                    <p>Upgrade your account with our high-yield investment opportunities</p>
                </div>
            </div>

            <!--:Page Header:-->
            <div class="px-4 lg:px-8 py-4">
                <h2 class="text-xl mb-2">All Plans</h2>
            </div>

            <!--:Page content:-->
            <div class="content flex flex-col flex-grow px-4 lg:px-8">
                <!--:Card:-->
                <div class="grid grid-cols-1 md:grid-cols-3 gap-6">
                    <?php $__currentLoopData = $invest; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div
                            class="rounded-lg overflow-hidden shadow-card border-zinc-800 dark:border-zinc-800 border transition-all hover:-translate-y-1 transform group">
                            <div class="px-4 py-1 text-center justify-center bg-sky-500/10">
                                <h2 class="text-2xl mt-3 mb-3"><?php echo e($plan->name); ?></h2>
                                <div class="mb-5">
                                    <p class="price-monthly text-3xl font-semibold">$<?php echo e($plan->min_amount); ?> <span
                                            class="text-sm">
                                            Minimum</span></p>
                                </div>
                            </div>
                            <div class="p-4 md:px-8 flex flex-col">
                                <ul class="mt-4 space-y-5 text-left mb-6 flex-grow">
                                    <li class="flex flex-wrap items-center gap-3"><span
                                            class="icon-[lucide--check] text-xl text-muted"></span> Min Investment:
                                        $<?php echo e($plan->min_amount); ?> </li>
                                    <li class="flex flex-wrap items-center gap-3"><span
                                            class="icon-[lucide--check] text-xl text-muted"></span> Max Investment:
                                        $<?php echo e($plan->max_amount); ?> </li>
                                    <li class="flex flex-wrap items-center gap-3"><span
                                            class="icon-[lucide--check] text-xl text-muted"></span> Interest Return:
                                        <span
                                            class="badge shrink-0 bg-green-500/10 text--500"><?php echo e($plan->interest_rate); ?>%
                                            <?php echo e($plan->interest_type); ?></span>
                                    </li>
                                    <li class="flex flex-wrap items-center gap-3"><span
                                            class="icon-[lucide--check] text-xl text-muted"></span> Duration:
                                        <?php echo e($plan->duration_in_days); ?> days
                                    </li>
                                </ul>
                                <form action="<?php echo e(route('storeuser.invest', $plan->id)); ?>" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <div class="w-full mb-4 investment-block"
                                        data-interest-type="<?php echo e($plan->interest_type); ?>"
                                        data-interest-rate="<?php echo e($plan->interest_rate); ?>"
                                        data-duration="<?php echo e($plan->duration); ?>">

                                        <label class="mb-1 block">Investment Amount</label>

                                        <div class="relative">
                                            <span
                                                class="absolute left-4 top-1/2 -translate-y-1/2 pointer-events-none opacity-75">$</span>
                                            <input type="number" name="amount"
                                                class="amount-input input !pl-7 mt-2 w-full" required
                                                min="<?php echo e($plan->min_amount); ?>" max="<?php echo e($plan->max_amount); ?>"
                                                value="<?php echo e($plan->min_amount); ?>" step="any">
                                        </div>

                                        <!-- 💸 Range Slider -->
                                        <input type="range"
                                            class="amount-range w-full mt-3 accent-gray-600 cursor-pointer"
                                            min="<?php echo e($plan->min_amount); ?>" max="<?php echo e($plan->max_amount); ?>" step="1"
                                            value="<?php echo e($plan->min_amount); ?>">

                                        <!-- 📊 Min/Max display -->
                                        <div class="flex justify-between text-sm text-gray-500 dark:text-gray-400 mt-1">
                                            <span>Min: $<?php echo e(number_format($plan->min_amount, 0)); ?></span>
                                            <span>Max: $<?php echo e(number_format($plan->max_amount, 0)); ?></span>
                                        </div>

                                        <div class="mb-2 text-center justify-center">
                                            <!-- 💰 Return + Profit display -->
                                            <div
                                                class="mt-3 text-sm text-green-600 dark:text-green-400 font-medium potential-return">
                                                Potential Return: $0.00
                                            </div>
                                            <div
                                                class="text-sm text-emerald-400 dark:text-emerald-300 potential-profit">
                                                Expected Profit: $0.00
                                            </div>
                                        </div>

                                        <?php if (isset($component)) { $__componentOriginalf94ed9c5393ef72725d159fe01139746 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf94ed9c5393ef72725d159fe01139746 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-error','data' => ['messages' => $errors->get('amount'),'class' => 'mt-2']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['messages' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors->get('amount')),'class' => 'mt-2']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $attributes = $__attributesOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__attributesOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $component = $__componentOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__componentOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
                                    </div>

                                    <script>
                                        document.addEventListener('DOMContentLoaded', function() {
                                            const blocks = document.querySelectorAll('.investment-block');

                                            blocks.forEach(block => {
                                                const input = block.querySelector('.amount-input');
                                                const range = block.querySelector('.amount-range');
                                                const returnEl = block.querySelector('.potential-return');
                                                const profitEl = block.querySelector('.potential-profit');

                                                const rate = parseFloat(block.dataset.interestRate);
                                                const duration = parseFloat(block.dataset.duration);
                                                const type = block.dataset.interestType;

                                                // ✅ Format numbers like PHP number_format
                                                const formatNumber = (num) => {
                                                    return Number(num).toLocaleString('en-US', {
                                                        minimumFractionDigits: 2,
                                                        maximumFractionDigits: 2
                                                    });
                                                };

                                                // 🧮 Calculate return & profit
                                                const calcReturn = (amount) => {
                                                    const principal = parseFloat(amount);
                                                    if (isNaN(principal) || principal <= 0) return {
                                                        total: 0,
                                                        profit: 0
                                                    };

                                                    let profit = 0;

                                                    // handle interest type
                                                    if (['daily', 'weekly', 'monthly'].includes(type)) {
                                                        profit = principal * (rate / 100) * duration;
                                                    }

                                                    const total = principal + profit;
                                                    return {
                                                        total,
                                                        profit
                                                    };
                                                };

                                                // 🪄 Update display
                                                const updateDisplay = (val) => {
                                                    const {
                                                        total,
                                                        profit
                                                    } = calcReturn(val);
                                                    returnEl.textContent = `Potential Return: $${formatNumber(total)}`;
                                                    profitEl.textContent = `Expected Profit: $${formatNumber(profit)}`;
                                                };

                                                // Initialize
                                                input.value = range.value;
                                                updateDisplay(range.value);

                                                // Slider → Input
                                                range.addEventListener('input', () => {
                                                    input.value = range.value;
                                                    updateDisplay(range.value);
                                                });

                                                // Input → Slider
                                                input.addEventListener('input', () => {
                                                    let v = parseFloat(input.value);
                                                    if (isNaN(v)) return;

                                                    const min = parseFloat(range.min);
                                                    const max = parseFloat(range.max);
                                                    if (v < min) v = min;
                                                    if (v > max) v = max;

                                                    range.value = v;
                                                    updateDisplay(v);
                                                });
                                            });
                                        });
                                    </script>
                                    <div class="relative">
                                        <button
                                            class="w-full btn btn-lg border border-sky-500/10 text-sky-500 hover:text-white hover:bg-primary"><svg
                                                xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                                viewBox="0 0 24 24">
                                                <path fill="currentColor"
                                                    d="M14 9a.5.5 0 0 1 .5-.5H18a.5.5 0 0 1 .5.5v3.5a.5.5 0 0 1-1 0v-2.293l-5.146 5.147a.5.5 0 0 1-.708 0L9 12.707l-2.646 2.647a.5.5 0 0 1-.708-.708l3-3a.5.5 0 0 1 .708 0L12 14.293L16.793 9.5H14.5A.5.5 0 0 1 14 9" />
                                            </svg> Join
                                            <?php echo e($plan->name); ?> Plan</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1)): ?>
<?php $attributes = $__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1; ?>
<?php unset($__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1)): ?>
<?php $component = $__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1; ?>
<?php unset($__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1); ?>
<?php endif; ?>
<?php /**PATH /home/allejouk/Desktop/work/NEW BINARY/resources/views/user/investment.blade.php ENDPATH**/ ?>