<?php if (isset($component)) { $__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.user','data' => ['title' => $pageTitle]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($pageTitle)]); ?>
    <div class="content flex-grow pt-4 lg:px-2">
        <div class="px-1 mb-4 lg:py-2 rounded-b-md bg-gradient-to-t from-zinc-900 dark:from-zinc-900">
            <div class="rounded-xl shadow-card p-4 sm:p-6 text-center">
                <div class="flex justify-center mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" width="60" height="60" viewBox="0 0 24 24">
                        <g fill="currentColor" fill-rule="evenodd" clip-rule="evenodd">
                            <path
                                d="M15.81 19.398a4 4 0 0 0-.71-.4c-1.53-.6-1.38-.15-.62-.74c2.429-1.859 2.109-6.438-1.11-7.068a.34.34 0 0 0-.4.26c-.13.6.79.21 1.67 1.33c1.38 1.78.34 6.099-4.14 5.059c-3.449-.7-2.999-6.769 1.71-6.459a.3.3 0 0 0 .36-.387a.3.3 0 0 0-.3-.203a4.24 4.24 0 0 0-2.83 7.879c-2.189.89-3.998 2.669-3.669 4.998a.3.3 0 0 0 .6 0a3.6 3.6 0 0 1 .81-1.82a12.8 12.8 0 0 1 2.22-2.219c.94-.57.89-.53.95-.61q.495.1 1 .13a8.14 8.14 0 0 0-.08 3.94a.13.13 0 0 0 0 .06a.29.29 0 0 0 .38.22a.27.27 0 0 0 .269-.2a.3.3 0 0 0 0-.09c.189-.989.273-1.994.25-3c-.17-1-.15-.8-.14-.9a4.4 4.4 0 0 0 1.1-.18q1.039.578 2 1.28c.93.953 1.636 2.1 2.069 3.36a.338.338 0 0 0 .409.303a.34.34 0 0 0 .25-.444a5.82 5.82 0 0 0-2.049-4.099" />
                            <path
                                d="M11.19 13.94a4.3 4.3 0 0 1-2.38.64a.3.3 0 0 0-.05.59c2 .38 2.77 0 4.41-1.07c.62.62 1.18 1.41 1.54 1a.34.34 0 0 0 0-.48c-.85-.89-.93-1.87-1.81-1.62q-.881.42-1.71.94m-1.12-8.498c-.49.93-1.7 2.71-.65 2.999c.89.26 1.82-.76 2.42-1.45c0 0 .21-.14.36-.27c.24.25.5.5.77.73a5.5 5.5 0 0 0 1.74 1c1.07.1.64-1.78.45-2.85l-.16-.22c.76-.37 2.109-.999 2.049-1.869c-.07-1-1.51-.9-2.62-1h-.29L13.12.632c-.72-.899-1.549-.739-1.999.16l-.67 1.48c0 .06-.15.19-.18.28a6.2 6.2 0 0 0-2.27.29c-.489.28-.469.89-.059 1.34a8.8 8.8 0 0 0 2.13 1.26m0-2c.19 0 .41.14.71 0s.39-.55 1.29-2.3q.109.075.2.17c.15.2.84 1.75 1.14 2.08a.8.8 0 0 0 .41.22q1.01.021 2 .23q-.818.45-1.7.75a.68.68 0 0 0-.27.71q.289.926.4 1.89a7.6 7.6 0 0 1-1.75-1.41c-.81-.83-1.69 1.79-2.75 2a1 1 0 0 1 0-.19c.11-.54.81-1.68 1-2.23c0 .14.11-.45-.28-.45l-.92-.45c-.16-.12-1-.59-1.14-.84c.12-.03 1.59-.2 1.68-.21zm13.925 2.959c-.1-1-1.48-.83-2.56-.94a1.7 1.7 0 0 0-.36 0l-.999-1.679c-.67-.78-1.37-.63-1.75.14l-.64 1.39a.34.34 0 0 0 .61.3c.91-1.83.81-1.74 1.13-1.31c.13.17.83 1.67 1.1 2s.66.18.82.21c.47.07 1.29 0 1.61.11c0 0-1.67.74-1.79.8a.65.65 0 0 0-.28.72c.17.54.29 1.096.36 1.659c-2-1.05-1.64-2.32-3-.59c-.16.19-.92 1.24-1.35 1.31a5 5 0 0 1 0-1.86a.3.3 0 1 0-.559-.22a6.1 6.1 0 0 0-.21 2c.07.87.7 1 1.42.58a6.7 6.7 0 0 0 1.35-1.3l.32-.23a7.1 7.1 0 0 0 1.619 1.28c.51.27 1 .56 1.36.17s0-2-.07-2.81c.7-.34 1.94-.96 1.87-1.73M1.872 8.181q-.19.961-.25 1.94a1.1 1.1 0 0 0 .18.88c.39.39.85.1 1.36-.17a7.1 7.1 0 0 0 1.62-1.29l.32.23A7 7 0 0 0 6.452 11c.71.4 1.349.3 1.419-.58a6 6 0 0 0-.21-2a.3.3 0 0 0-.56.22a5 5 0 0 1 0 1.86c-.44-.07-1.21-1.14-1.35-1.31c-1.37-1.73-1-.46-2.999.59a9.7 9.7 0 0 1 .36-1.66a.65.65 0 0 0-.28-.72c-.12-.07-1.78-.82-1.79-.8c.32-.08 1.14 0 1.61-.11c.16 0 .58 0 .82-.21s1.19-2.279 1.37-2.229s.19.16.89 1.56a.34.34 0 0 0 .61-.3l-.64-1.39c-.38-.77-1.08-.92-1.7-.14l-1 1.68a1.7 1.7 0 0 0-.36 0c-1.15.16-2.54.01-2.64.99c-.07.77 1.17 1.38 1.87 1.73" />
                        </g>
                    </svg>
                </div>
                <h4 class="text-xl lg:text-2xl mb-2">Copy Trading Dashboard</h4>
                <p class="text-white mb-6">
                    Manage your Copied Trades portfolio and track Performances
                </p>
                <div class="flex items-center flex-wrap justify-center gap-4">
                    <a href="<?php echo e(url('user/copy_experts')); ?>" type="button"
                        class="btn bg-zinc-700 text-white hover:bg-primary-deep gap-2">
                        <span class="icon-[lucide--users]"></span> Browse Experts</a>
                    <a href="<?php echo e(url('user/copy_trading')); ?>" type="button"
                        class="btn bg-zinc-700 text-white hover:bg-primary-deep gap-2">
                        Refresh
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24">
                            <path fill="currentColor"
                                d="M6.545 8.163a.75.75 0 0 1-.487-1.044l1.66-3.535a.75.75 0 0 1 1.36.002l.732 1.569l.08-.027a8.15 8.15 0 1 1-5.8 5.903a.75.75 0 1 1 1.456.364a6.65 6.65 0 1 0 4.907-4.862l.74 1.583a.75.75 0 0 1-.872 1.043z" />
                        </svg>
                    </a>
                </div>
            </div>
        </div>
    </div>
    <?php
        $activeCopy = \App\Models\UserCopyTrade::where('user_id', auth()->id())
            ->where('status', 'active')
            ->first();
    ?>

    <!--:Page content:-->

    <div class="content flex-grow px-2 lg:px-8">
        <div class="mb-4 grid grid-cols-1 md:grid-cols-4 gap-4">
            <!--:Card:-->
            <div class="rounded-xl p-4 bg-white dark:bg-zinc-900 shadow-card flex items-center">
                <div class="shrink-0 w-3/5">
                    <p class="mb-2">Active Copies</p>
                    <h4 class="text-2xl mb-1"><?php echo e($activeCount); ?></h4>
                    <span class="text-sm">
                        <span class="text-muted">Experts Being Copied</span></span>
                </div>
                <div class="ps-3 w-2/5 flex justify-end">
                    <!--:Progress Circle:-->
                    <div class="relative w-16 h-16" data-progress="82" data-show-value="true">
                        <!-- Background circle -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 24 24">
                            <path fill="currentColor"
                                d="M14 12.25a3.75 3.75 0 1 1 3.75-3.75A3.75 3.75 0 0 1 14 12.25m0-6a2.25 2.25 0 1 0 2.25 2.25A2.25 2.25 0 0 0 14 6.25m7 13a.76.76 0 0 1-.75-.75c0-1.95-1.06-3.25-6.25-3.25s-6.25 1.3-6.25 3.25a.75.75 0 0 1-1.5 0c0-4.75 5.43-4.75 7.75-4.75s7.75 0 7.75 4.75a.76.76 0 0 1-.75.75M8.32 13.06H8a3 3 0 1 1 .58-6a.75.75 0 1 1-.15 1.49a1.46 1.46 0 0 0-1.09.34a1.47 1.47 0 0 0-.54 1a1.49 1.49 0 0 0 1.35 1.64a1.53 1.53 0 0 0 .93-.22a.75.75 0 0 1 .79 1.28a3 3 0 0 1-1.55.47M3 18.5a.76.76 0 0 1-.75-.75c0-2.7.72-4.5 4.25-4.5a.75.75 0 0 1 0 1.5c-2.35 0-2.75.75-2.75 3a.76.76 0 0 1-.75.75" />
                        </svg>
                    </div>
                </div>
            </div>
            <!--:Card:-->
            <div class="rounded-xl p-4 bg-white dark:bg-zinc-900 shadow-card flex items-center">
                <div class="shrink-0 w-3/5">
                    <p class="mb-2">Total Invested</p>
                    <h4 class="text-2xl mb-1">$<?php echo e(number_format($totalInvested, 2)); ?></h4>
                    <span class="text-sm">
                        <span class="text-muted">Capital Deployed</span></span>
                </div>
                <div class="ps-3 w-2/5 flex justify-end">
                    <!--:Progress Circle:-->
                    <div class="relative w-16 h-16" data-progress="82" data-show-value="true">
                        <!-- Background circle -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 24 24">
                            <path fill="currentColor"
                                d="M7 15h2c0 1.08 1.37 2 3 2s3-.92 3-2c0-1.1-1.04-1.5-3.24-2.03C9.64 12.44 7 11.78 7 9c0-1.79 1.47-3.31 3.5-3.82V3h3v2.18C15.53 5.69 17 7.21 17 9h-2c0-1.08-1.37-2-3-2s-3 .92-3 2c0 1.1 1.04 1.5 3.24 2.03C14.36 11.56 17 12.22 17 15c0 1.79-1.47 3.31-3.5 3.82V21h-3v-2.18C8.47 18.31 7 16.79 7 15" />
                        </svg>
                    </div>
                </div>
            </div>
            <!--:Card:-->
            <div class="rounded-xl p-4 bg-white dark:bg-zinc-900 shadow-card flex items-center">
                <div class="shrink-0 w-3/5">
                    <p class="mb-2">Capital Value</p>
                    <h4 class="text-2xl mb-1">$<?php echo e(number_format($totalCurrentValue, 2)); ?></h4>
                    <span class="text-sm">
                        <span class="text-muted">Capital Deployed</span></span>
                </div>
                <div class="ps-3 w-2/5 flex justify-end">
                    <!--:Progress Circle:-->
                    <div class="relative w-16 h-16" data-progress="82" data-show-value="true">
                        <!-- Background circle -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 24 24">
                            <g fill="none" stroke="currentColor" stroke-width="1">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M6 8h4" />
                                <path stroke-width="1.5"
                                    d="M20.833 9h-2.602C16.446 9 15 10.343 15 12s1.447 3 3.23 3h2.603c.084 0 .125 0 .16-.002c.54-.033.97-.432 1.005-.933c.002-.032.002-.071.002-.148v-3.834c0-.077 0-.116-.002-.148c-.036-.501-.465-.9-1.005-.933C20.959 9 20.918 9 20.834 9Z" />
                                <path stroke-width="1.5"
                                    d="M20.965 9c-.078-1.872-.328-3.02-1.137-3.828C18.657 4 16.771 4 13 4h-3C6.229 4 4.343 4 3.172 5.172S2 8.229 2 12s0 5.657 1.172 6.828S6.229 20 10 20h3c3.771 0 5.657 0 6.828-1.172c.809-.808 1.06-1.956 1.137-3.828"
                                    opacity="0.4" />
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17.991 12H18"
                                    opacity="0.5" />
                            </g>
                        </svg>
                    </div>
                </div>
            </div>
            <!--:Card:-->
            <div class="rounded-xl p-4 bg-white dark:bg-zinc-900 shadow-card flex items-center">
                <div class="shrink-0 w-3/5">
                    <p class="mb-2">Total P&L</p>
                    <p
                        class="text-2xl font-semibold
                <?php echo e($pnlSign === 'positive' ? 'text-green-500' : 'text-red-500'); ?>">
                        <?php echo e($pnlSign === 'positive' ? '+' : '-'); ?>$<?php echo e(number_format(abs($totalPnL), 2)); ?>

                    </p>
                    <span class="text-sm">
                        <p
                            class="text-lg font-semibold
                <?php echo e($totalROI >= 0 ? 'text-green-500' : 'text-red-500'); ?>">
                            <?php echo e($totalROI >= 0 ? '+' : '-'); ?><?php echo e(number_format(abs($totalROI), 2)); ?>%
                        </p>
                    </span>
                </div>
                <div class="ps-3 w-2/5 flex justify-end">
                    <!--:Progress Circle:-->
                    <div class="relative w-16 h-16" data-progress="82" data-show-value="true">
                        <!-- Background circle -->
                        <svg xmlns="http://www.w3.org/2000/svg" width="55" height="55" viewBox="0 0 48 48">
                            <path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                d="M5.504 41.251H42.5V28.153M7.434 37.688L22.424 22.7l5.108 5.108L42.5 12.84v11.056M31.359 12.839H42.5"
                                stroke-width="1" />
                            <rect width="13.13" height="11.358" x="5.5" y="12.402" fill="none"
                                stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" rx="2.181"
                                stroke-width="1" />
                            <path fill="none" stroke="currentColor" stroke-linecap="round"
                                stroke-linejoin="round" d="M8.562 16.188h10.067M5.5 19.974h10.067" stroke-width="1" />
                            <circle cx="12.056" cy="8.589" r="1.84" fill="none" stroke="currentColor"
                                stroke-linecap="round" stroke-linejoin="round" stroke-width="1" />
                        </svg>
                    </div>
                </div>
            </div>
        </div>
        <?php if($activeCopy): ?>
            <div
                class="rounded-lg overflow-hidden mb-3 shadow-card bg-white dark:bg-zinc-950 border-zinc-200 dark:border-zinc-800 border">
                <div
                    class="px-4 py-2.5 bg-sky-500/10 dark:bg-sky-500/10 rounded-2xl shadow-lg bborder-zinc-200 dark:border-zinc-800 borderlg:px-8 pt-4 pb-4 flex flex-col sm:flex-row sm:items-center">
                    <div class="flex-grow mb-3 sm:mb-0">
                        <h2 class="text-lg font-semibold mb-1 text-black dark:text-white flex items-center gap-2">
                            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22"
                                viewBox="0 0 48 48" class="shrink-0">
                                <path fill="#00bcd4"
                                    d="M37 18h6v24h-6zm-8 8h6v16h-6zm-8-4h6v20h-6zm-8 10h6v10h-6zm-8-4h6v14H5z" />
                                <g fill="#3f51b5">
                                    <circle cx="8" cy="16" r="3" />
                                    <circle cx="16" cy="18" r="3" />
                                    <circle cx="24" cy="11" r="3" />
                                    <circle cx="32" cy="13" r="3" />
                                    <circle cx="40" cy="9" r="3" />
                                    <path
                                        d="m39.1 7.2l-7.3 3.7l-8.3-2.1l-8 7l-7-1.7l-1 3.8l9 2.3l8-7l7.7 1.9l8.7-4.3z" />
                                </g>
                            </svg>
                            <span>Active Copy Positions</span>
                        </h2>

                        <p>You're viewing the main digital marketing summary</p>
                    </div>
                    <div class="shrink-0">
                        <span class="ms-auto"
                            style="display:inline-flex;align-items:center;gap:6px;font-weight:600;font-family:sans-serif;">

                            <span class="ms-auto badge bg-sky-500/10 text-white gap-2"><span
                                    style="
                                    position:relative;
                                    width:10px;height:10px;
                                    border-radius:50%;
                                    background:#22c55e;
                                    display:inline-block;
                                    animation:pulse 1.4s infinite;
                                "></span>Live</span>
                        </span>
                    </div>
                </div>
                <div class="p-4">
                    <div class="mb-4 grid grid-cols-1 md:grid-cols-3 gap-4">
                        <!--:Card:-->
                        <?php $__empty_2 = true; $__currentLoopData = $copiedExperts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                            <div x-data="{ openModal: false }"
                                class="flex flex-col h-full rounded-md bg-white dark:bg-zinc-900 shadow-card p-4 lg:p-6 relative">
                                <div class="flex items-start justify-between mb-3">
                                    <div class="flex items-center space-x-5">
                                        <div class="flex items-center gap-2">
                                            <img src="<?php echo e(asset('upload/experts/' . $item->expert->image)); ?>"
                                                alt="img"
                                                class="w-10 h-10 object-contain rounded-md border border-gray-200 dark:border-zinc-700">
                                            <div>
                                                <h6 class="leading-tight"><?php echo e($item->expert->name); ?></h6>
                                                <p class="text-sm text-gray-500 dark:text-gray-400">
                                                    <?php echo e($item->expert->title); ?>

                                                </p>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="flex flex-col items-end space-y-1">
                                        <span
                                            class="inline-flex items-center px-3 py-1 badge bg-green-500/10 text-green-600 rounded-full text-xs font-medium">
                                            <?php echo e(ucfirst($item->status)); ?>

                                        </span>
                                        <span class="text-xs text-gray-500 dark:text-gray-400">
                                            <?php echo e($item->created_at->diffForHumans()); ?>

                                        </span>
                                    </div>
                                </div>

                                <ul
                                    class="divide-y divide-zinc-200 dark:divide-zinc-800 whitespace-nowrap overflow-x-auto">
                                    <hr class="border-zinc-200 dark:border-zinc-800 mb-3 border-dashed my-1">

                                    <!-- Investment -->
                                    <li
                                        class="flex items-start mb-4 py-2.5 p-2 rounded-md border dark:border-zinc-800">
                                        <div class="flex items-center flex-grow px-3">Investment</div>
                                        <div class="flex items-center space-x-2 shrink-0">
                                            <span class="text-sky-500">$<?php echo e(number_format($item->amount, 2)); ?></span>
                                        </div>
                                    </li>

                                    <!-- Current Value -->
                                    <li
                                        class="flex items-start mb-4 py-2.5 p-2 rounded-md border dark:border-zinc-800">
                                        <div class="flex items-center flex-grow px-3">Current Value</div>
                                        <div class="flex items-center space-x-2 shrink-0">
                                            <span
                                                class="text-sky-500">$<?php echo e(number_format($item->current_value, 2)); ?></span>
                                        </div>
                                    </li>

                                    <!-- P&L -->
                                    <?php
                                        $difference = $item->current_value - $item->amount;
                                        $isProfit = $difference >= 0;
                                        $sign = $isProfit ? '+' : '-';
                                        $color = $isProfit ? 'text-green-500' : 'text-red-500';
                                    ?>
                                    <li
                                        class="flex items-start mb-4 py-2.5 p-2 rounded-md border dark:border-zinc-800">
                                        <div class="flex items-center flex-grow px-3">P&amp;L</div>
                                        <div class="flex items-center space-x-2 shrink-0">
                                            <span
                                                class="<?php echo e($color); ?>"><?php echo e($sign); ?>$<?php echo e(number_format(abs($difference), 2)); ?></span>
                                        </div>
                                    </li>

                                    <!-- ROI -->
                                    <?php
                                        $roi = $item->roi_percentage ?? 0;
                                        $roiSign = $roi >= 0 ? '+' : '-';
                                        $roiColor = $roi >= 0 ? 'text-green-500' : 'text-red-500';
                                    ?>
                                    <li
                                        class="flex items-start mb-4 py-2.5 p-2 rounded-md border dark:border-zinc-800">
                                        <div class="flex items-center flex-grow px-3">ROI</div>
                                        <div class="flex items-center space-x-2 shrink-0">
                                            <span
                                                class="<?php echo e($roiColor); ?>"><?php echo e($roiSign); ?><?php echo e(number_format(abs($roi), 2)); ?>%</span>
                                        </div>
                                    </li>
                                </ul>

                                <!-- Buttons -->
                                <div class="flex flex-row justify-between pt-5 gap-2">
                                    <!-- View Details -->
                                    <button @click="openModal = true" type="button"
                                        class="btn bg-primary hover:bg-primary-deep text-white flex items-center justify-center gap-2 w-8/12 py-2 rounded-md">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                            viewBox="0 0 50 50">
                                            <path fill="currentColor"
                                                d="M18 36h-2V26h-4v10h-2V24h8zm10 0h-2V20h-4v16h-2V18h8zm10 0h-2V14h-4v22h-2V12h8zM8 36h32v2H8z" />
                                        </svg>
                                        View Details
                                    </button>

                                    <!-- Stop Copying -->
                                    <form action="<?php echo e(route('user.copytrade.stop', $item->id)); ?>" method="POST"
                                        class="w-4/12">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('POST'); ?>
                                        <button type="submit"
                                            class="btn border border-red-500 hover:border-red-600 text-red-500 hover:bg-red-500 hover:text-white flex items-center justify-center gap-2 w-full py-2 rounded-md">
                                            <svg xmlns="http://www.w3.org/2000/svg" width="20" height="20"
                                                viewBox="0 0 48 48">
                                                <g fill="currentColor" fill-rule="evenodd" clip-rule="evenodd">
                                                    <path
                                                        d="M21 11v.17A3 3 0 0 0 17 14v1.17A3 3 0 0 0 13 18v11.525C13 35.31 17.69 40 23.475 40c3.637 0 7.014-1.887 8.92-4.985l5.736-9.32a3.006 3.006 0 0 0-4.92-3.436L31 25.063V14a3 3 0 0 0-4-2.83V11a3 3 0 1 0-6 0m4 0a1 1 0 1 0-2 0v12h-2v-9a1 1 0 1 0-2 0v11h-2v-7a1 1 0 1 0-2 0v11.525a8.475 8.475 0 0 0 15.692 4.442l5.736-9.32a1.006 1.006 0 0 0-1.647-1.15l-2.21 2.804c-1.175 1.49-3.571.66-3.571-1.238V14a1 1 0 1 0-2 0v9h-2z" />
                                                    <path
                                                        d="M24 4c11.046 0 20 8.954 20 20s-8.954 20-20 20S4 35.046 4 24S12.954 4 24 4m18 20c0-9.941-8.059-18-18-18S6 14.059 6 24s8.059 18 18 18s18-8.059 18-18" />
                                                </g>
                                            </svg>
                                            Stop
                                        </button>
                                    </form>

                                </div>

                                <!-- Modal -->
                                <div x-show="openModal" x-cloak x-transition.opacity
                                    @keydown.escape.window="openModal = false"
                                    class="fixed inset-0 flex items-start justify-center bg-black/50 z-50 overflow-y-auto p-1"
                                    style="display:none">
                                    <!-- Click-away closes -->
                                    <div @click.away="openModal = false"
                                        class="w-full max-w-4xl mx-auto bg-white dark:bg-zinc-900 rounded-md shadow-xl relative my-8
               max-h-[calc(100vh-4rem)] overflow-y-auto
               p-4 sm:p-6">
                                        <!-- Sticky close button (always visible) -->
                                        

                                        <h2 class="text-lg font-semibold mb-4 text-gray-800 dark:text-white pr-10">
                                            Copied Trade Details
                                        </h2>

                                        <!-- Expert Info -->
                                        <div class="flex items-center gap-3 mb-4">
                                            <img src="<?php echo e(asset('upload/experts/' . $item->expert->image)); ?>"
                                                class="w-10 h-10 rounded-md border border-gray-300 dark:border-zinc-700 object-cover"
                                                alt="expert">
                                            <div>
                                                <p class="font-semibold"><?php echo e($item->expert->name); ?></p>
                                                <p class="text-xs text-gray-500"><?php echo e($item->expert->title); ?></p>
                                            </div>
                                        </div>

                                        <!-- Basic Stats -->
                                        <ul class="divide-y divide-gray-200 dark:divide-zinc-800 text-sm mb-4">
                                            <li class="flex justify-between py-2">
                                                <span>Investment:</span>
                                                <span
                                                    class="text-sky-500">$<?php echo e(number_format($item->amount, 2)); ?></span>
                                            </li>
                                            <li class="flex justify-between py-2">
                                                <span>Current Value:</span>
                                                <span
                                                    class="text-sky-500">$<?php echo e(number_format($item->current_value, 2)); ?></span>
                                            </li>
                                            <li class="flex justify-between py-2">
                                                <span>Status:</span>
                                                <span class="text-green-500"><?php echo e(ucfirst($item->status)); ?></span>
                                            </li>
                                            <li class="flex justify-between py-2">
                                                <span>Copied:</span>
                                                <span
                                                    class="text-gray-500"><?php echo e($item->created_at->diffForHumans()); ?></span>
                                            </li>
                                        </ul>

                                        <!-- Trade Logs -->
                                        <?php
                                            $logs = \App\Models\CopyTradeLog::where('user_id', auth()->id())
                                                ->where('trade_expert_id', $item->trade_expert_id)
                                                ->orderByDesc('created_at')
                                                ->get();
                                        ?>

                                        <div class="mt-4">
                                            <h3
                                                class="text-base font-semibold mb-2 text-gray-800 dark:text-white flex items-center gap-2">
                                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                                    viewBox="0 0 24 24">
                                                    <path fill="currentColor" d="M5 4v3h5.5v12h3V7H19V4z" />
                                                </svg>
                                                Trade Log History
                                            </h3>

                                            <?php if($logs->count()): ?>
                                                <div
                                                    class="overflow-x-auto border border-gray-200 dark:border-zinc-700 rounded-md">
                                                    <table class="min-w-full text-sm">
                                                        <thead class="bg-gray-100 dark:bg-zinc-800 sticky top-0">
                                                            <tr>
                                                                <th
                                                                    class="px-3 py-2 text-left text-gray-700 dark:text-gray-300">
                                                                    Date</th>
                                                                <th
                                                                    class="px-3 py-2 text-left text-gray-700 dark:text-gray-300">
                                                                    Profit ($)</th>
                                                                <th
                                                                    class="px-3 py-2 text-left text-gray-700 dark:text-gray-300">
                                                                    % Change</th>
                                                                <th
                                                                    class="px-3 py-2 text-left text-gray-700 dark:text-gray-300">
                                                                    Note</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody class="divide-y divide-gray-200 dark:divide-zinc-800">
                                                            <?php $__currentLoopData = $logs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                <tr>
                                                                    <td
                                                                        class="px-3 py-2 text-gray-600 dark:text-gray-300">
                                                                        <?php echo e($log->created_at->format('d M, Y h:i A')); ?>

                                                                    </td>
                                                                    <td
                                                                        class="px-3 py-2 <?php echo e($log->profit_amount >= 0 ? 'text-green-500' : 'text-red-500'); ?>">
                                                                        <?php echo e($log->profit_amount >= 0 ? '+' : '-'); ?>$<?php echo e(number_format(abs($log->profit_amount), 2)); ?>

                                                                    </td>
                                                                    <td
                                                                        class="px-3 py-2 <?php echo e($log->percent_change >= 0 ? 'text-green-500' : 'text-red-500'); ?>">
                                                                        <?php echo e($log->percent_change >= 0 ? '+' : '-'); ?><?php echo e(number_format(abs($log->percent_change), 2)); ?>%
                                                                    </td>
                                                                    <td
                                                                        class="px-3 py-2 text-gray-600 dark:text-gray-400">
                                                                        <?php echo e($log->note ?? '—'); ?>

                                                                    </td>
                                                                </tr>
                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                        </tbody>
                                                    </table>
                                                </div>
                                            <?php else: ?>
                                                <p class="text-gray-500 dark:text-gray-400 text-sm text-center py-3">
                                                    No trade logs found for this expert.
                                                </p>
                                            <?php endif; ?>
                                        </div>

                                        <!-- Footer -->
                                        <div class="mt-5 text-right">
                                            <button @click="openModal = false"
                                                class="px-4 py-2 bg-gray-200 dark:bg-zinc-700 text-gray-800 dark:text-gray-200 rounded-md hover:bg-gray-300">
                                                Close
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                            <p class="text-center text-gray-500 dark:text-gray-400">No copied experts found.</p>
                        <?php endif; ?>
                    </div>
                </div>
            </div>

            <div class="gap-4 mb-4">
                <div class="md:col-span-8">
                    <!--:Card:-->

                    <div class="mb-4">
                        <div
                            class="rounded-md shadow-card mb-4 overflow-hidden border-zinc-700 dark:border-zinc-700 border">
                            <div class="flex justify-between items-center px-4 py-4">
                                <h5 class="text-lg">
                                    Copy Trading History
                                </h5>
                            </div>
                            <div class="hidden lg:block overflow-x-auto">
                                <div class="overflow-x-auto px-4">
                                    <table class="table-default">
                                        <thead class="border-t border-zinc-500/10 dark:border-zinc-800">
                                            <tr>
                                                <th>Expert</th>
                                                <th>Investment</th>
                                                <th>Final Value</th>
                                                <th>P&L</th>
                                                <th>ROI</th>
                                                <th>Duration</th>
                                                <th>Status</th>
                                            </tr>
                                        </thead>
                                        <tbody
                                            class="divide-y divide-zinc-200 dark:divide-zinc-900 border-t border-zinc-200 dark:border-zinc-800">
                                            <?php $__empty_2 = true; $__currentLoopData = $tradelog; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                                <tr>
                                                    <td class="whitespace-nowrap">
                                                        <div class="flex items-center gap-2">
                                                            <img alt=""
                                                                src="<?php echo e(asset('upload/experts/' . $log->expert->image)); ?>"
                                                                class="size-8 rounded-full me-2 shrink-0">
                                                            <div>
                                                                <h6 class="leading-tight"><?php echo e($log->expert->name); ?>

                                                                </h6>
                                                                <p class="text-sm"><?php echo e($log->expert->title); ?></p>
                                                            </div>
                                                        </div>
                                                    </td>
                                                    <td class="whitespace-nowrap">$<?php echo e($log->amount); ?></td>
                                                    <td class="whitespace-nowrap"><?php echo e($log->current_value); ?></td>
                                                    <td class="whitespace-nowrap"><?php echo e($log->profit_loss); ?></td>
                                                    <td class="whitespace-nowrap"><?php echo e($log->roi_percentage); ?></td>
                                                    <td class="whitespace-nowrap"><?php echo e($log->days_running); ?></td>
                                                    <td class="whitespace-nowrap">
                                                        <span
                                                            class="badge !inline-flex items-center bg-zinc-500/50 text-gray-500 gap-1">
                                                            <?php echo e($log->status); ?>

                                                        </span>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                                <p class="text-center text-gray-500 dark:text-gray-400">No closed trade
                                                    found.</p>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <!-- Mobile Table -->
                            <div class="block lg:hidden space-y-4 mb-4">
                                <?php $__currentLoopData = $tradelog; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $log): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="overflow-x-auto px-2">
                                        <div
                                            class="rounded-xl p-4 border-zinc-200 dark:border-zinc-800 border transition-colors duration-300">
                                            <div class="flex items-start justify-between mb-3">
                                                <!-- Logo and Amount Section -->
                                                <div class="flex items-center space-x-5">
                                                    <!-- Gateway Logo -->
                                                    <div class="flex items-center gap-2">
                                                        <?php if($log->expert->image && $log->expert->image): ?>
                                                            <img src="<?php echo e(asset('upload/experts/' . $log->expert->image)); ?>"
                                                                alt="<?php echo e($log->expert->name); ?>"
                                                                class="w-10 h-10 object-contain rounded-md border border-gray-200 dark:border-zinc-700">
                                                        <?php else: ?>
                                                            <div
                                                                class="w-8 h-8 bg-gray-700 flex items-center justify-center text-xs text-white rounded-md">
                                                                N/A
                                                            </div>
                                                        <?php endif; ?>
                                                        <div>
                                                            <h6 class="leading-tight">
                                                                $<?php echo e(number_format($log->amount, 2)); ?>

                                                            </h6>
                                                            <p class="text-sm"><?php echo e($log->expert->name); ?></p>
                                                        </div>
                                                    </div>
                                                </div>

                                                <!-- Status Badge -->
                                                <span
                                                    class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium
                    <?php if($log->status === 'stopped'): ?> badge bg-red-500/10 text-red-500
                    <?php elseif($log->status === 'active'): ?> badge bg-green-500/10 text-green-500
                    <?php elseif($log->status === 'rejected'): ?> badge bg-red-500/10 text-red-500
                    <?php else: ?> bg-gray-900/30 text-gray-400 <?php endif; ?>">
                                                    <div
                                                        class="w-1.5 h-1.5 rounded-full mr-1.5
                        <?php if($log->status === 'pending'): ?> bg-amber-500
                        <?php elseif($log->status === 'approved'): ?> bg-emerald-500
                        <?php elseif($log->status === 'rejected'): ?> bg-red-500
                        <?php else: ?> bg-gray-500 <?php endif; ?>">
                                                    </div>
                                                    <?php echo e(ucfirst($log->status)); ?>

                                                </span>
                                            </div>

                                            <!-- Payment Mode -->
                                            <div class="flex justify-between items-center text-sm">
                                            </div>

                                            <!-- Date -->
                                            <div class="mt-2 text-sm text-slate-500">
                                                <?php echo e($log->created_at->format('M d, Y \a\t h:i A')); ?>

                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>


                </div>
            </div>
        <?php else: ?>
            <!-- 🚫 No active copy -->
            <div class="gap-4 mb-4" styles="height:350px;">
                <!-- :Card: -->
                <div class="rounded-xl bg-white dark:bg-zinc-900 shadow-card p-6 text-center">
                    <div class="flex justify-center items-center mb-4">
                        <svg xmlns="http://www.w3.org/2000/svg" width="70" height="70" viewBox="0 0 24 24"
                            class="text-primary">
                            <g fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"
                                stroke-width="1.5">
                                <path
                                    d="M19.4 20H9.6a.6.6 0 0 1-.6-.6V9.6a.6.6 0 0 1 .6-.6h9.8a.6.6 0 0 1 .6.6v9.8a.6.6 0 0 1-.6.6" />
                                <path d="M15 9V4.6a.6.6 0 0 0-.6-.6H4.6a.6.6 0 0 0-.6.6v9.8a.6.6 0 0 0 .6.6H9" />
                            </g>
                        </svg>
                    </div>

                    <h5 class="text-xl mb-2 font-semibold text-gray-800 dark:text-white">Start Copy Trading</h5>
                    <p class="text-gray-500 dark:text-gray-400 mb-6">
                        You haven't started copying any traders yet. Browse our expert traders and start copying their
                        winning strategies to earn profits automatically.
                    </p>
                    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-4 justify-center mb-4">
                        <!-- Card 1 -->
                        <a
                            class="w-72 rounded-xl bg-sky-500/10 shadow-card hover:shadow-xl p-4 transition-all transform hover:-translate-y-1 text-center block mx-auto break-words">

                            <!-- :Icon: -->
                            <div
                                class="w-14 h-14 mx-auto mb-3 flex items-center justify-center bg-primary rounded-full">
                                <span class="icon-[lucide--users] text-2xl text-white"></span>
                            </div>

                            <h5 class="text-base font-semibold mb-1 text-gray-800 dark:text-white">
                                Expert Traders
                            </h5>
                            <p class="text-sm text-gray-600 dark:text-gray-400 mb-2">
                                Copy from verified professional traders with proven track records.
                            </p>
                        </a>

                        <!-- Card 2 -->
                        <a
                            class="w-72 rounded-xl bg-green-500/10 shadow-card hover:shadow-xl p-4 transition-all transform hover:-translate-y-1 text-center block mx-auto break-words">

                            <!-- :Icon: -->
                            <div
                                class="w-14 h-14 mx-auto mb-3 flex items-center justify-center bg-primary rounded-full">
                                <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28"
                                    viewBox="0 0 24 24">
                                    <g fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="1.5">
                                        <path d="M20 13V8h-5" />
                                        <path
                                            d="m20 8l-5 5c-.883.883-1.324 1.324-1.865 1.373q-.135.012-.27 0c-.541-.05-.982-.49-1.865-1.373s-1.324-1.324-1.865-1.373a1.5 1.5 0 0 0-.27 0c-.541.05-.982.49-1.865 1.373l-3 3" />
                                    </g>
                                </svg>
                            </div>

                            <h5 class="text-base font-semibold mb-1 text-gray-800 dark:text-white">Auto Trading</h5>
                            <p class="text-sm text-gray-600 dark:text-gray-400 mb-2">
                                Trades are executed automatically when experts make moves.
                            </p>
                        </a>

                        <!-- Card 3 -->
                        <a
                            class="w-72 rounded-xl bg-primary/10 shadow-card hover:shadow-xl p-4 transition-all transform hover:-translate-y-1 text-center block mx-auto break-words">

                            <!-- :Icon: -->
                            <div
                                class="w-14 h-14 mx-auto mb-3 flex items-center justify-center bg-primary rounded-full">
                                <svg xmlns="http://www.w3.org/2000/svg" width="35" height="35"
                                    viewBox="0 0 24 24">
                                    <path fill="currentColor"
                                        d="M12 20.962q-3.014-.895-5.007-3.651T5 11.1V5.692l7-2.615l7 2.615V11.1q0 3.454-1.993 6.21T12 20.963m0-1.062q2.6-.825 4.3-3.3t1.7-5.5V6.375l-6-2.23l-6 2.23V11.1q0 3.025 1.7 5.5t4.3 3.3m0-7.88" />
                                </svg>
                            </div>

                            <h5 class="text-base font-semibold mb-1 text-gray-800 dark:text-white">Risk Management</h5>
                            <p class="text-sm text-gray-600 dark:text-gray-400 mb-2">
                                Set your own risk limits and stop-loss parameters to protect your portfolio against
                                market volatility.
                            </p>
                        </a>
                    </div>


                    <div class="flex items-center mt-4 flex-wrap justify-center gap-4">
                        <a href="<?php echo e(url('user/copy_experts')); ?>" type="button"
                            class="btn btn-lg bg-primary text-white hover:bg-primary-deep gap-2">
                            <span class="icon-[lucide--users]"></span> Browse Experts</a>
                        <button type="button" class="text-primary py-4 cursor-pointer flex items-center gap-2"
                            data-bs-toggle="modal" data-bs-target="#modalCenter">
                            Learn more about <span class="icon-[lucide--external-link]"></span>
                        </button>
                    </div>
                </div>
            </div>

        <?php endif; ?>
    </div>

    <!--:Modal Center + scroll:-->
    <div id="modalCenter" role="dialog"
        class="modal fixed w-full h-full left-0 top-0 z-[60] hidden items-center justify-center bg-black/50 backdrop-blur-sm [&.show]:flex"
        tabindex="-1">

        <div
            class="modal-dialog relative flex items-center justify-center m-4 h-[calc(100vh-2rem)] pointer-events-none">
            <!-- Modal content -->
            <div
                class="modal-content overflow-hidden max-w-[30rem] mx-auto bg-white dark:bg-zinc-900 rounded-xl w-full max-h-[90vh] overflow-y-auto shadow-2xl border border-zinc-200 dark:border-zinc-800 pointer-events-auto">

                <!-- Header -->
                <div
                    class="sticky top-0 z-10 p-4 border-b border-zinc-100 dark:border-zinc-800 flex items-center justify-between bg-white dark:bg-zinc-900 rounded-t-xl">
                    <h5 class="text-lg font-semibold">How Copy Trading Works</h5>
                    <button type="button"
                        class="btn btn-default !p-0 !rounded-full size-8 flex items-center justify-center"
                        data-bs-dismiss="modal">
                        <span class="icon-[lucide--x] text-xl"></span>
                    </button>
                </div>

                <!-- Scrollable content -->
                <div class="p-4 overflow-y-auto flex-1">
                    <div class="gap-4">
                        <div class="md:col-span-6">
                            <ul class="px-4 py-1 divide-y flex flex-col divide-zinc-500/10 dark:divide-zinc-800">
                                <li class="flex items-center gap-3.5 py-3">
                                    <div
                                        class="items-center justify-center mb-1 size-10 flex rounded-full shrink-0 bg-primary/10 text-white">
                                        1
                                    </div>
                                    <div class="flex-grow">
                                        <h6 class="truncate">Choose an Expert</h6>
                                        <p class="text-muted">Browse through our verified expert traders and select one
                                            based on their performance, strategy, and risk profile.</p>
                                    </div>
                                </li>
                                <li class="flex items-center gap-3.5 py-3">
                                    <div
                                        class="items-center justify-center mb-1 size-10 flex rounded-full shrink-0 bg-green-500/10 text-white">
                                        2
                                    </div>
                                    <div class="flex-grow">
                                        <h6 class="truncate">Set Your Investment</h6>
                                        <p class="text-muted">Decide how much you want to invest and set your risk
                                            parameters including stop-loss and take-profit levels.</p>
                                    </div>
                                </li>
                                <li class="flex items-center gap-3.5 py-3">
                                    <div
                                        class="items-center justify-center mb-1 size-10 flex rounded-full shrink-0 bg-primary text-white">
                                        3
                                    </div>
                                    <div class="flex-grow">
                                        <h6 class="truncate">Auto-Copy Trades</h6>
                                        <p class="text-muted">Our system automatically copies the expert's trades to
                                            your
                                            account in real-time, proportional to your investment.</p>
                                    </div>
                                </li>
                                <li class="flex items-center gap-3.5 py-3">
                                    <div
                                        class="items-center justify-center mb-1 size-10 flex rounded-full shrink-0 bg-amber-500/10 text-white">
                                        4
                                    </div>
                                    <div class="flex-grow">
                                        <h6 class="truncate">Monitor & Profit</h6>
                                        <p class="text-muted">Track your performance in real-time and watch your
                                            investment grow as the expert trader makes profitable trades.</p>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1)): ?>
<?php $attributes = $__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1; ?>
<?php unset($__attributesOriginalaafc7cae133d9c6cc95e5de00a30e9b1); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1)): ?>
<?php $component = $__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1; ?>
<?php unset($__componentOriginalaafc7cae133d9c6cc95e5de00a30e9b1); ?>
<?php endif; ?>
<?php /**PATH /home/allejouk/Desktop/work/NEW BINARY/resources/views/user/copy_trading.blade.php ENDPATH**/ ?>