<!--
* Customized from Tabular template for Meadow Stone Estate
-->
<!DOCTYPE html
    PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:v="urn:schemas-microsoft-com:vml"
    xmlns:o="urn:schemas-microsoft-com:office:office" lang="en">

<head>
    <meta charset="UTF-8" />
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Email Verification - Meadow Stone Estate</title>

    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@500;600;700&display=swap" rel="stylesheet"
        type="text/css" />

    <style type="text/css">
        body {
            margin: 0;
            padding: 0;
            background-color: #f9f9f9;
            font-family: 'Inter', Arial, sans-serif;
            color: #333;
        }

        .container {
            max-width: 420px;
            margin: 40px auto;
            background-color: #ffffff;
            border-radius: 20px;
            border: 1px solid #ddd;
            padding: 50px 40px;
        }

        h1 {
            font-size: 24px;
            font-weight: 600;
            color: #111;
            text-align: center;
        }

        p {
            font-size: 15px;
            line-height: 22px;
            text-align: center;
            color: #424040;
        }

        .code {
            display: inline-block;
            background-color: #2563eb;
            color: #ffffff;
            font-size: 28px;
            letter-spacing: 5px;
            padding: 12px 20px;
            border-radius: 8px;
            margin: 20px 0;
        }

        .footer {
            margin-top: 30px;
            font-size: 13px;
            color: #84828E;
            background-color: #f2f2f2;
            padding: 15px;
            border-radius: 8px;
        }

        @media (max-width: 480px) {
            .container {
                padding: 30px 20px;
                border-radius: 10px;
            }
        }
    </style>
</head>

<body>
    <div class="container">
        <div style="text-align:center; margin-bottom:20px;">
            <img src="<?php echo e(asset('upload/' . $websiteSettings->site_logo)); ?>" alt="Meadow Stone Estate Logo" width="60"
                height="60" />
        </div>

        <h1>Hello <?php echo e($name); ?> 👋</h1>

        <p>Thank you for registering with <strong><?php echo e($websiteSettings->site_name); ?></strong>.</p>
        <p>Please verify your email using the code below:</p>

        <div style="text-align:center;">
            <span class="code"><?php echo e($code); ?></span>
        </div>

        <p>Enter this code on the verification page to activate your account.</p>

        <p style="margin-top: 30px;">If you didn’t sign up for <?php echo e($websiteSettings->site_name); ?>, you can safely ignore
            this email.
        </p>

        <div class="footer">
            — The <?php echo e($websiteSettings->site_name); ?> Support Team
        </div>
    </div>
</body>

</html><?php /**PATH /home/allejouk/Desktop/work/NEW BINARY/resources/views/emails/verify_code.blade.php ENDPATH**/ ?>