<!DOCTYPE html>
<html lang="en" x-data="{ darkMode: localStorage.getItem('theme') === 'light' ? false : true }" :class="{ 'dark': darkMode }" class="dark bg-gray-300 h-full">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="wivA4MyFouig0kGM80BoALBDN6KeIjdkkinmpiPV">
    <title><?php echo e($websiteSettings->site_name); ?> - Sign In</title>

    <!-- Favicon -->
    <link href="<?php echo e(asset('upload/' . $websiteSettings->site_favicon)); ?>" rel="icon" type="image/x-icon" />

    <!-- Inter Font -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <script>
        // Set dark mode as default if no preference is stored
        if (!localStorage.getItem('theme')) {
            localStorage.setItem('theme', 'dark');
            document.documentElement.classList.add('dark');
        }

        tailwind.config = {
            darkMode: 'class',
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Inter', 'sans-serif'],
                    },
                    colors: {
                        primary: {
                            50: '#eef2ff',
                            100: '#e0e7ff',
                            200: '#c7d2fe',
                            300: '#a5b4fc',
                            400: '#818cf8',
                            500: '#6366f1',
                            600: '#4f46e5',
                            700: '#4338ca',
                            800: '#3730a3',
                            900: '#312e81',
                        },
                        'glass': 'rgba(255, 255, 255, 0.05)',
                    },
                    backdropBlur: {
                        'xs': '2px',
                    },
                    animation: {
                        'gradient-x': 'gradient-x 15s ease infinite',
                        'gradient-y': 'gradient-y 15s ease infinite',
                        'gradient-xy': 'gradient-xy 15s ease infinite',
                        'pulse-slow': 'pulse 4s cubic-bezier(0.4, 0, 0.6, 1) infinite',
                        'float': 'float 6s ease-in-out infinite',
                    },
                    keyframes: {
                        'gradient-y': {
                            '0%, 100%': {
                                'background-size': '400% 400%',
                                'background-position': 'center top'
                            },
                            '50%': {
                                'background-size': '200% 200%',
                                'background-position': 'center center'
                            }
                        },
                        'gradient-x': {
                            '0%, 100%': {
                                'background-size': '200% 200%',
                                'background-position': 'left center'
                            },
                            '50%': {
                                'background-size': '200% 200%',
                                'background-position': 'right center'
                            }
                        },
                        'gradient-xy': {
                            '0%, 100%': {
                                'background-size': '400% 400%',
                                'background-position': 'left center'
                            },
                            '50%': {
                                'background-size': '200% 200%',
                                'background-position': 'right center'
                            }
                        },
                        'float': {
                            '0%, 100%': {
                                transform: 'translateY(0)'
                            },
                            '50%': {
                                transform: 'translateY(-10px)'
                            }
                        }
                    }
                }
            }
        }
    </script>

    <!-- Alpine.js -->
    <script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>

    <!-- Lucide Icons -->
    <script src="https://unpkg.com/lucide@latest/dist/umd/lucide.js"></script>


    <!-- Latest compiled and minified CSS -->
    <!-- <link href="404.html" rel="stylesheet" /> -->

    <title><?php echo e($websiteSettings->site_name); ?></title>
    <meta name="theme-color" content="#4D7DE6">
    <meta name="msapplication-navbutton-color" content="#4D7DE6">
    <!-- iOS Safari -->
    <meta name="apple-mobile-web-app-status-bar-style" content="#4D7DE6">


    <meta name="theme-color" content="#4D7DE6">
    <meta name="msapplication-navbutton-color" content="#4D7DE6">
    <!-- iOS Safari -->
    <meta name="apple-mobile-web-app-status-bar-style" content="#4D7DE6">

    <link href="<?php echo e(asset('upload/' . $websiteSettings->site_favicon)); ?>" rel="icon" type="image/x-icon" />

    <meta name="keywords" content="<?php echo e($websiteSettings->site_name); ?>" />
    <meta property="og:image" content="<?php echo e(asset('upload/' . $websiteSettings->site_favicon)); ?>" />

    <link rel="apple-touch-icon-precomposed" href="<?php echo e(asset('upload/' . $websiteSettings->site_favicon)); ?>">
    <link rel="apple-touch-icon-precomposed" sizes="114x114"
        href="<?php echo e(asset('upload/' . $websiteSettings->site_favicon)); ?>" />
    <link rel="apple-touch-icon-precomposed" sizes="144x144"
        href="<?php echo e(asset('upload/' . $websiteSettings->site_favicon)); ?>" />


    <meta property="og:site_name" content="<?php echo e($websiteSettings->site_name); ?>">
    <meta property="og:title" content="Trading With <?php echo e($websiteSettings->site_name); ?>" />
    <meta name="description"
        content="<?php echo e($websiteSettings->site_name); ?> LIMITED???
INVEST IN A LEADING
TRADE AND INVESTMENT
COMPANY, OPERATING IN
THE UK.
SERVICES INCLUDE: FOREX TRADING
CRYPTOCURRENCIES, STOCKS & COMMODITIES INVESTMENTS. OIL & GAS, REAL ESTATE INVESTMENTS, MARKET
RESEARCH AND ANALYSIS:
ASSISTING BOTH INDIVIDUALS & COMPANIES INVEST IN THE
COMMERCIAL MARKET.TRAINING CLIENTS & INVESTORS TO BECOME
EXPERTISE.???">
    <meta property="og:description"
        content="<?php echo e($websiteSettings->site_name); ?> LIMITED???
INVEST IN A LEADING
TRADE AND INVESTMENT
COMPANY, OPERATING IN
THE UK.
SERVICES INCLUDE: FOREX TRADING
CRYPTOCURRENCIES, STOCKS & COMMODITIES INVESTMENTS. OIL & GAS, REAL ESTATE INVESTMENTS, MARKET
RESEARCH AND ANALYSIS:
ASSISTING BOTH INDIVIDUALS & COMPANIES INVEST IN THE
COMMERCIAL MARKET.TRAINING CLIENTS & INVESTORS TO BECOME
EXPERTISE.???">
    <meta property="og:type" content="website" />


    <!-- <link href="404" rel="stylesheet" /> -->

</head>


<style>
    body {
        overflow-x: hidden;
    }

    [x-cloak] {
        display: none !important;
    }

    .glass-effect {
        background: rgba(255, 255, 255, 0.03);
        backdrop-filter: blur(20px);
        -webkit-backdrop-filter: blur(20px);
        border: 1px solid rgba(255, 255, 255, 0.05);
        box-shadow: 0 8px 32px 0 rgba(0, 0, 0, 0.37);
    }

    .trading-card {
        background: rgba(17, 24, 39, 0.95);
        backdrop-filter: blur(20px);
        border: 1px solid rgba(75, 85, 99, 0.2);
        box-shadow:
            0 10px 25px -5px rgba(0, 0, 0, 0.3),
            0 20px 25px -5px rgba(0, 0, 0, 0.1),
            inset 0 1px 0 rgba(255, 255, 255, 0.05);
    }

    .light .trading-card {
        background: rgba(255, 255, 255, 0.95);
        border: 1px solid rgba(229, 231, 235, 0.3);
        box-shadow:
            0 10px 25px -5px rgba(0, 0, 0, 0.1),
            0 20px 25px -5px rgba(0, 0, 0, 0.04),
            inset 0 1px 0 rgba(255, 255, 255, 0.1);
    }

    .step-indicator {
        position: relative;
        z-index: 1;
    }

    .step-indicator::before {
        content: '';
        position: absolute;
        top: 50%;
        left: 0;
        right: 0;
        height: 2px;
        background: linear-gradient(90deg, transparent 0%, rgba(79, 70, 229, 0.3) 50%, transparent 100%);
        transform: translateY(-50%);
        z-index: -1;
    }

    .skiptranslate {
        display: none !important;
    }

    body {
        top: 0 !important;
    }
</style>
</head>

<body class="h-full bg-gray-300 font-sans antialiased transition-colors duration-300 text-gray-900"
    x-data="{ darkMode: localStorage.theme === 'dark' || !localStorage.theme }" :class="{ 'dark': darkMode }" x-cloak>


    <!-- Theme Toggle (Hidden but accessible) -->

    <!-- Main Content Wrapper -->
    <div class="relative min-h-screen overflow-hidden">
        <!-- Content -->
        <div class="relative z-10">

            <!-- Fintech Trading Platform Login -->
            <div class="min-h-screen bg-gray-900 relative overflow-hidden">
                <!-- Remove animated background elements and floating orbs -->

                <div class="relative z-10 flex min-h-screen items-center justify-center px-4 py-8 sm:px-6 lg:px-8">
                    <div class="w-full max-w-lg">
                        <!-- Trading Login Card -->
                        <div class="relative bg-gray-900 border border-gray-700 rounded-3xl p-8 sm:p-10 shadow-2xl">
                            <!-- Remove glow effect -->

                            <div class="relative">
                                <!-- Status Alert -->

                                <!-- Header Section -->
                                <div class="text-center mb-8">
                                    <!-- Logo -->
                                    <div class="flex items-center justify-center mb-6">
                                        <div class="relative">
                                            <!-- Remove glow effect -->
                                            <img src="<?php echo e(asset('upload/' . $websiteSettings->site_logo)); ?>"
                                                class="relative h-16 w-auto" alt="<?php echo e($websiteSettings->site_name); ?>" />
                                        </div>
                                    </div>

                                    <!-- Title -->
                                    <h1 class="text-2xl sm:text-3xl font-bold text-white mb-2">
                                        Welcome Back
                                    </h1>
                                    <h2 class="text-lg sm:text-xl font-semibold mb-3">
                                        <span
                                            class="text-transparent bg-clip-text bg-gradient-to-r from-blue-400 to-cyan-400"><?php echo e($websiteSettings->site_name); ?></span>
                                    </h2>
                                    <p class="text-gray-300 text-sm sm:text-base">
                                        Access your trading dashboard
                                    </p>

                                    <!-- Trading Stats -->
                                    <div class="flex items-center justify-center gap-6 mt-6 text-xs sm:text-sm">
                                        <div class="text-center">
                                            <div class="flex items-center justify-center gap-1 text-green-400 mb-1">
                                                <div class="w-2 h-2 bg-green-400 rounded-full animate-pulse"></div>
                                                <span class="font-medium">Live</span>
                                            </div>
                                            <div class="text-gray-400">24/7 Markets</div>
                                        </div>
                                        <div class="w-px h-10 bg-white/20"></div>
                                        <div class="text-center">
                                            <div class="flex items-center justify-center gap-1 text-blue-400 mb-1">
                                                <i data-lucide="zap" class="w-3 h-3"></i>
                                                <span class="font-medium">Fast</span>
                                            </div>
                                            <div class="text-gray-400">Execution</div>
                                        </div>
                                        <div class="w-px h-10 bg-white/20"></div>
                                        <div class="text-center">
                                            <div class="flex items-center justify-center gap-1 text-cyan-400 mb-1">
                                                <i data-lucide="shield" class="w-3 h-3"></i>
                                                <span class="font-medium">Secure</span>
                                            </div>
                                            <div class="text-gray-400">Platform</div>
                                        </div>
                                    </div>
                                </div>
                                <!-- Error Messages -->

                                <!-- Login Form -->
                                <form action="<?php echo e(route('login')); ?>" method="post" class="space-y-6">
                                    <?php echo csrf_field(); ?>
                                    <!-- Email Field -->
                                    <div class="space-y-2">
                                        <label for="email" class="block text-sm font-semibold text-gray-200">
                                            Email Address or Username
                                        </label>
                                        <div class="relative group">
                                            <div class="absolute inset-y-0 left-0 flex items-center pl-4">
                                                <i data-lucide="mail"
                                                    class="h-5 w-5 text-gray-400 group-focus-within:text-blue-400 transition-colors duration-200"></i>
                                            </div>
                                            <input type="text" name="login" id="email" required
                                                class="block w-full rounded-2xl border border-gray-600 bg-gray-900 pl-12 pr-4 py-4 text-white placeholder-gray-400 focus:border-blue-400 focus:ring-2 focus:ring-blue-400/20 focus:bg-gray-800 transition-all duration-200 text-sm font-medium"
                                                placeholder="Username or Email Address" value="">
                                        </div>
                                        <?php if (isset($component)) { $__componentOriginalf94ed9c5393ef72725d159fe01139746 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf94ed9c5393ef72725d159fe01139746 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-error','data' => ['messages' => $errors->get('login'),'class' => 'mt-2']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['messages' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors->get('login')),'class' => 'mt-2']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $attributes = $__attributesOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__attributesOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $component = $__componentOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__componentOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
                                    </div>

                                    <!-- Password Field -->
                                    <div class="space-y-2">
                                        <label for="password" class="block text-sm font-semibold text-gray-200">
                                            Password
                                        </label>
                                        <div class="relative group" x-data="{ showPassword: false }">
                                            <div class="absolute inset-y-0 left-0 flex items-center pl-4">
                                                <i data-lucide="lock"
                                                    class="h-5 w-5 text-gray-400 group-focus-within:text-blue-400 transition-colors duration-200"></i>
                                            </div>
                                            <input type="password" name="password" id="password" required
                                                :type="showPassword ? 'text' : 'password'"
                                                class="block w-full rounded-2xl border border-gray-600 bg-gray-900 pl-12 pr-12 py-4 text-white placeholder-gray-400 focus:border-blue-400 focus:ring-2 focus:ring-blue-400/20 focus:bg-gray-800 transition-all duration-200 text-sm font-medium"
                                                placeholder="Enter your password">
                                            <button type="button" @click="showPassword = !showPassword"
                                                class="absolute inset-y-0 right-0 flex items-center pr-4 text-gray-400 hover:text-blue-400 transition-colors">
                                                <i data-lucide="eye" class="h-5 w-5" x-show="!showPassword"></i>
                                                <i data-lucide="eye-off" class="h-5 w-5" x-show="showPassword"
                                                    x-cloak></i>
                                            </button>
                                        </div>
                                        <?php if (isset($component)) { $__componentOriginalf94ed9c5393ef72725d159fe01139746 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf94ed9c5393ef72725d159fe01139746 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-error','data' => ['messages' => $errors->get('password'),'class' => 'mt-2']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['messages' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors->get('password')),'class' => 'mt-2']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $attributes = $__attributesOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__attributesOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $component = $__componentOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__componentOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
                                    </div>

                                    <!-- Remember Me & Forgot Password -->
                                    <div class="flex items-center justify-between text-sm">
                                        <div class="flex items-center">
                                            <input type="checkbox" name="remember" id="remember"
                                                class="h-4 w-4 rounded border-gray-600 bg-gray-900 text-blue-500 focus:ring-2 focus:ring-blue-400/20 transition-colors">
                                            <label for="remember" class="ml-3 text-gray-300 font-medium">
                                                Remember me
                                            </label>
                                        </div>
                                        <a href="<?php echo e(url('forgot-password')); ?>"
                                            class="text-blue-400 hover:text-blue-300 transition-colors underline underline-offset-2">
                                            Forgot password?
                                        </a>
                                    </div>

                                    <!-- Login Button -->
                                    <div class="mt-8">
                                        <button type="submit"
                                            class="group relative flex w-full justify-center items-center gap-3 rounded-2xl bg-gradient-to-r from-blue-500 to-cyan-500 hover:from-blue-600 hover:to-cyan-600 px-6 py-4 text-base font-bold text-white transition-all duration-200 shadow-lg hover:shadow-xl transform hover:-translate-y-0.5 focus:outline-none focus:ring-2 focus:ring-blue-400/50 disabled:opacity-50 disabled:cursor-not-allowed">
                                            <i data-lucide="log-in" class="h-5 w-5"></i>
                                            <span>Access Dashboard</span>
                                            <i data-lucide="arrow-right"
                                                class="h-4 w-4 group-hover:translate-x-1 transition-transform"></i>
                                        </button>
                                    </div>
                                </form>

                                <!-- Biometric Login Methods -->
                                <div class="mt-8">
                                    <div class="relative">
                                        <div class="absolute inset-0 flex items-center">
                                            <div class="w-full border-t border-white/20"></div>
                                        </div>
                                        <div class="relative flex justify-center text-sm">
                                            <span class="bg-gray-900 px-4 text-gray-300 font-medium">Quick
                                                Access</span>
                                        </div>
                                    </div>

                                    <div class="mt-6 flex justify-center space-x-4">
                                        <button type="button" x-data="{ hover: false }" @mouseenter="hover = true"
                                            @mouseleave="hover = false"
                                            class="group relative inline-flex items-center justify-center w-14 h-14 rounded-2xl border border-gray-600 bg-gray-800 hover:bg-gray-700 hover:border-blue-400/50 transition-all duration-200 shadow-lg hover:shadow-xl">
                                            <i data-lucide="fingerprint"
                                                class="h-6 w-6 text-blue-400 group-hover:text-blue-300 group-hover:scale-110 transition-all duration-200"></i>
                                            <div
                                                class="absolute -bottom-12 left-1/2 transform -translate-x-1/2 bg-gray-900/90 text-white text-xs px-2 py-1 rounded opacity-0 group-hover:opacity-100 transition-opacity duration-200 whitespace-nowrap">
                                                Fingerprint
                                            </div>
                                        </button>
                                        <button type="button" x-data="{ hover: false }" @mouseenter="hover = true"
                                            @mouseleave="hover = false"
                                            class="group relative inline-flex items-center justify-center w-14 h-14 rounded-2xl border border-gray-600 bg-gray-800 hover:bg-gray-700 hover:border-cyan-400/50 transition-all duration-200 shadow-lg hover:shadow-xl">
                                            <i data-lucide="scan-face"
                                                class="h-6 w-6 text-cyan-400 group-hover:text-cyan-300 group-hover:scale-110 transition-all duration-200"></i>
                                            <div
                                                class="absolute -bottom-12 left-1/2 transform -translate-x-1/2 bg-gray-900/90 text-white text-xs px-2 py-1 rounded opacity-0 group-hover:opacity-100 transition-opacity duration-200 whitespace-nowrap">
                                                Face ID
                                            </div>
                                        </button>
                                        <button type="button" x-data="{ hover: false }" @mouseenter="hover = true"
                                            @mouseleave="hover = false"
                                            class="group relative inline-flex items-center justify-center w-14 h-14 rounded-2xl border border-gray-600 bg-gray-800 hover:bg-gray-700 hover:border-green-400/50 transition-all duration-200 shadow-lg hover:shadow-xl">
                                            <i data-lucide="qr-code"
                                                class="h-6 w-6 text-green-400 group-hover:text-green-300 group-hover:scale-110 transition-all duration-200"></i>
                                            <div
                                                class="absolute -bottom-12 left-1/2 transform -translate-x-1/2 bg-gray-900/90 text-white text-xs px-2 py-1 rounded opacity-0 group-hover:opacity-100 transition-opacity duration-200 whitespace-nowrap">
                                                QR Code
                                            </div>
                                        </button>
                                    </div>
                                </div>

                                <!-- Footer -->
                                <div class="mt-10 text-center space-y-6">
                                    <!-- Register Link -->
                                    <div class="text-sm">
                                        <span class="text-gray-300">New to trading? </span>
                                        <a href="<?php echo e(url('register')); ?>"
                                            class="font-semibold text-blue-400 hover:text-blue-300 transition-colors underline underline-offset-2">
                                            Create your account
                                        </a>
                                    </div>

                                    <!-- Security Badges -->
                                    <div class="flex items-center justify-center gap-6 py-4 text-xs text-gray-400">
                                        <div class="flex items-center gap-1">
                                            <i data-lucide="shield-check" class="w-3 h-3 text-green-400"></i>
                                            <span>SSL Secured</span>
                                        </div>
                                        <div class="flex items-center gap-1">
                                            <i data-lucide="lock" class="w-3 h-3 text-blue-400"></i>
                                            <span>256-bit Encryption</span>
                                        </div>
                                        <div class="flex items-center gap-1">
                                            <i data-lucide="award" class="w-3 h-3 text-cyan-400"></i>
                                            <span>Regulated</span>
                                        </div>
                                    </div>

                                    <!-- Copyright -->
                                    <p class="text-xs text-gray-500">
                                        ©
                                        <script>
                                            document.write(new Date().getFullYear())
                                        </script> <?php echo e($websiteSettings->site_name); ?>. All rights
                                        reserved.
                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <script>
                document.addEventListener('DOMContentLoaded', function() {
                    // Auto-focus email field
                    const emailField = document.getElementById('email');
                    if (emailField) {
                        emailField.focus();
                    }

                    // Initialize Lucide icons
                    if (typeof lucide !== 'undefined') {
                        lucide.createIcons();
                    }
                });

                // Re-initialize icons after Alpine updates
                document.addEventListener('alpine:updated', () => {
                    if (typeof lucide !== 'undefined') {
                        lucide.createIcons();
                    }
                });
            </script>

        </div>
    </div>

    <!-- Professional Trading Ticker -->
    

    <!-- Initialize Scripts -->
    <script>
        // Set dark mode as default if no preference is stored
        if (!localStorage.getItem('theme')) {
            localStorage.setItem('theme', 'dark');
            document.documentElement.classList.add('dark');
        }

        // Initialize theme
        document.addEventListener('alpine:init', () => {
            Alpine.store('theme', {
                init() {
                    // Default to dark if no preference is set
                    this.darkMode = localStorage.getItem('theme') === 'dark' || !localStorage.getItem(
                        'theme');
                    this.updateTheme();
                },
                darkMode: true, // Set default to true
                toggle() {
                    this.darkMode = !this.darkMode;
                    this.updateTheme();
                },
                updateTheme() {
                    localStorage.setItem('theme', this.darkMode ? 'dark' : 'light');
                    document.documentElement.classList.toggle('dark', this.darkMode);
                }
            });
        });

        // Initialize Lucide icons
        document.addEventListener('DOMContentLoaded', () => {
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
            }
        });

        // Re-initialize icons after Alpine updates
        document.addEventListener('alpine:updated', () => {
            if (typeof lucide !== 'undefined') {
                lucide.createIcons();
            }
        });
    </script>


    <!-- Language Selector -->
    <div class="gtranslate_wrapper"></div>
    <script>
        window.gtranslateSettings = {
            default_language: "en",
            alt_flags: {
                "en": "usa"
            },
            wrapper_selector: ".gtranslate_wrapper",
            flag_style: "3d",
        };
    </script>
    <script src="https://cdn.gtranslate.net/widgets/latest/float.js" defer></script>
</body>

</html>
<?php /**PATH /home/allejouk/Desktop/work/NEW BINARY/resources/views/auth/login.blade.php ENDPATH**/ ?>