<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>New Deposit Alert</title>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@500;600;700&display=swap" rel="stylesheet" />
    <style>
        body {
            background: #f5f7fa;
            font-family: 'Inter', Arial, sans-serif;
            color: #333;
            margin: 0;
            padding: 0;
        }

        .container {
            max-width: 480px;
            margin: 40px auto;
            background: #fff;
            border-radius: 20px;
            border: 1px solid #ddd;
            padding: 40px;
        }

        h1 {
            color: #111;
            font-size: 20px;
            text-align: center;
            margin-bottom: 10px;
        }

        p {
            font-size: 15px;
            line-height: 22px;
            color: #444;
        }

        .details {
            background: #f3f4f6;
            border-radius: 10px;
            padding: 15px;
            margin-top: 15px;
        }

        .footer {
            margin-top: 25px;
            text-align: center;
            font-size: 13px;
            color: #777;
        }
    </style>
</head>

<body>
    <div class="container">
        <h1>💰 New Deposit Alert</h1>
        <p>A user has submitted a new deposit for review.</p>

        <div class="details">
            <p><strong>User:</strong> <?php echo e($user->firstname); ?> <?php echo e($user->lastname); ?> (<?php echo e($user->email); ?>)</p>
            <p><strong>Amount:</strong> $<?php echo e($amount); ?></p>
            <p><strong>Gateway:</strong> <?php echo e($gateway); ?></p>
            <p><strong>Date:</strong> <?php echo e($date); ?></p>
            <p><strong>Remark:</strong> <?php echo e($remark); ?></p>
        </div>

        <div class="footer">
            — <?php echo e(config('app.name')); ?> Admin Notification
        </div>
    </div>
</body>

</html><?php /**PATH /home/allejouk/Desktop/work/NEW BINARY/resources/views/emails/deposits/admin_alert.blade.php ENDPATH**/ ?>