<?php if (isset($component)) { $__componentOriginaldc6c47b2dbde2c874161740878d1c990 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaldc6c47b2dbde2c874161740878d1c990 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.admin','data' => ['title' => $pageTitle]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['title' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($pageTitle)]); ?>

    <div class="mx-auto max-w-(--breakpoint-2xl) px-5 py-4 md:p-6">
        <div>
            <!-- Breadcrumb Start -->
            <div x-data="{ pageName: `<?php echo e($pageTitle); ?>` }">
                <div class="flex flex-wrap items-center justify-between gap-3 pb-6">
                    <h2 class="text-xl font-semibold text-gray-800 dark:text-white/90" x-text="pageName"></h2>
                    <nav>
                        <ol class="flex items-center gap-1.5">
                            <li>
                                <a class="inline-flex items-center gap-1.5 text-sm text-gray-500 dark:text-gray-400"
                                    href="<?php echo e(url('admin/dashboard')); ?>">
                                    Home
                                    <svg class="stroke-current" width="17" height="16" viewBox="0 0 17 16" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path d="M6.0765 12.667L10.2432 8.50033L6.0765 4.33366" stroke=""
                                            stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                </a>
                            </li>
                            <li class="text-sm text-gray-800 dark:text-white/90" x-text="pageName"></li>
                        </ol>
                    </nav>
                </div>
            </div>
            <!-- Breadcrumb End -->

            <!-- Content Start -->
            <div class="col-span-12">
                <!-- Table Five -->
                <div class="rounded-2xl border border-gray-200 bg-white pt-4 dark:border-gray-800 dark:bg-white/[0.03]">
                    <div class="flex flex-col justify-between gap-5 px-6 py-5 sm:flex-row sm:items-start">
                        <div>
                            <h3 class="text-base font-medium text-gray-800 dark:text-white/90">
                                User Investments
                            </h3>
                        </div>
                    </div>

                    <div class="custom-scrollbar max-w-full overflow-x-auto overflow-y-visible px-5 sm:px-6">
                        <table class="min-w-full">
                            <thead class="border-y border-gray-100 py-3 dark:border-gray-800">
                                <th class="py-3 pr-5 font-normal whitespace-nowrap sm:pr-6">
                                    <div class="flex items-center">
                                        <p class="text-theme-sm text-gray-500 dark:text-gray-400">User Name</p>
                                    </div>
                                </th>
                                <th class="px-5 py-3 font-normal whitespace-nowrap sm:px-6">
                                    <div class="flex items-center">
                                        <p class="text-theme-sm text-gray-500 dark:text-gray-400">Asset Name</p>
                                    </div>
                                </th>
                                <th class="px-5 py-3 font-normal whitespace-nowrap sm:px-6">
                                    <div class="flex items-center">
                                        <Entry class="text-theme-sm text-gray-500 dark:text-gray-400">Entry Price</p>
                                    </div>
                                </th>
                                <th class="px-5 py-3 font-normal whitespace-nowrap sm:px-6">
                                    <div class="flex items-center">
                                        <Entry class="text-theme-sm text-gray-500 dark:text-gray-400">Amount Traded</p>
                                    </div>
                                </th>
                                <th class="px-5 py-3 font-normal whitespace-nowrap sm:px-6">
                                    <div class="flex items-center">
                                        <p class="text-theme-sm text-gray-500 dark:text-gray-400">
                                            Current Value
                                        </p>
                                    </div>
                                </th>
                                <th class="px-5 py-3 font-normal whitespace-nowrap sm:px-6">
                                    <div class="flex items-center">
                                        <p class="text-theme-sm text-gray-500 dark:text-gray-400">
                                            Duration
                                        </p>
                                    </div>
                                </th>
                                <th class="px-5 py-3 font-normal whitespace-nowrap sm:px-6">
                                    <div class="flex items-center">
                                        <p class="text-theme-sm text-gray-500 dark:text-gray-400">
                                            Profit / Loss
                                        </p>
                                    </div>
                                </th>
                                <th class="px-5 py-3 font-normal whitespace-nowrap sm:px-6">
                                    <div class="flex items-center">
                                        <p class="text-theme-sm text-gray-500 dark:text-gray-400">Status</p>
                                    </div>
                                </th>
                            </thead>
                            <tbody class="divide-y divide-gray-100 dark:divide-gray-800">
                                <?php $__empty_1 = true; $__currentLoopData = $invest; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td class="py-3 pr-5 whitespace-nowrap sm:pr-5">
                                            <div class="col-span-3 flex items-center">
                                                <div class="flex items-center gap-3">
                                                    <div class="h-8 w-8">
                                                        <?php if(!empty($item->user->image)): ?>
                                                            <img src="<?php echo e(url('upload/profile/' . $item->user->image)); ?>"
                                                                alt="brand" />
                                                        <?php else: ?>
                                                            <img src="<?php echo e(asset('admin/src/images/brand/brand-08.svg')); ?>"
                                                                alt="brand" />
                                                        <?php endif; ?>
                                                    </div>

                                                    <div>
                                                        <span
                                                            class="text-theme-sm block font-medium text-gray-700 dark:text-gray-400">
                                                            <?php echo e($item->user->firstname); ?>

                                                            <?php echo e($item->user->lastname); ?>

                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                        <td class="px-5 py-3 whitespace-nowrap sm:px-6">
                                            <div class="flex items-center">
                                                <p class="text-theme-sm text-gray-700 dark:text-gray-400">
                                                    <?php echo e($item->asset_name); ?> - <?php echo e($item->symbol); ?> - <?php echo e($item->market_type); ?> -
                                                    <?php echo e($item->side); ?>

                                                </p>
                                            </div>
                                        </td>
                                        <td class="px-5 py-3 whitespace-nowrap sm:px-6">
                                            <div class="flex items-center">
                                                <p class="text-theme-sm text-gray-700 dark:text-gray-400">
                                                    $<?php echo e(number_format($item->entry_price, 2)); ?>

                                                </p>
                                            </div>
                                        </td>
                                        <td class="px-5 py-3 whitespace-nowrap sm:px-6">
                                            <div class="flex items-center">
                                                <p class="text-theme-sm text-gray-700 dark:text-gray-400">
                                                    $<?php echo e(number_format($item->amount, 2)); ?>

                                                </p>
                                            </div>
                                        </td>
                                        <td class="px-5 py-3 whitespace-nowrap sm:px-6">
                                            <div class="flex items-center">
                                                <span
                                                    class="<?php echo e($item->current_value >= 0 ? 'text-success-500' : 'text-error-500'); ?>">
                                                    $<?php echo e(number_format($item->current_value, 2)); ?>

                                                </span>
                                            </div>
                                        </td>
                                        <td class="px-5 py-3 whitespace-nowrap sm:px-6">
                                            <div class="flex items-center">
                                                <p class="text-theme-sm text-gray-700 dark:text-gray-400">
                                                    <?php echo e($item->expiration); ?>

                                                </p>
                                            </div>
                                        </td>
                                        <td class="px-5 py-3 whitespace-nowrap sm:px-6">
                                            <div class="flex items-center">
                                                <p
                                                    class="<?php echo e($item->profit_loss >= 0 ? 'text-success-500' : 'text-error-500'); ?>">
                                                    $<?php echo e($item->profit_loss ?? 'N/A'); ?>

                                                </p>
                                            </div>
                                        </td>
                                        <td class="px-5 py-3 whitespace-nowrap sm:px-6">
                                            <div class="flex items-center">
                                                <?php if($item->status === 'open'): ?>
                                                    <span
                                                        class="inline-flex items-center px-2 py-1 text-xs font-medium text-white bg-success-800 rounded-full
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                dark:bg-amber-500/10 dark:text-green-400">
                                                        Running
                                                    </span>
                                                <?php elseif($item->status === 'completed'): ?>
                                                    <span
                                                        class="inline-flex items-center px-2 py-1 text-xs font-medium text-white bg-gray-800 rounded-full
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                dark:bg-blue-500/10 dark:text-blue-400">
                                                        Completed
                                                    </span>
                                                <?php elseif($item->status === 'closed'): ?>
                                                    <span
                                                        class="inline-flex items-center px-2 py-1 text-xs font-medium text-white bg-error-500 rounded-full
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                dark:bg-red-500/10 dark:text-red-400">
                                                        Closed
                                                    </span>
                                                <?php else: ?>
                                                    <span
                                                        class="inline-flex items-center px-2 py-1 text-xs font-medium text-gray-700 bg-gray-100 rounded-full
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                dark:bg-gray-500/10 dark:text-gray-400">
                                                        Unknown
                                                    </span>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                    <div class="border-t border-gray-200 px-6 py-4 dark:border-gray-800">
                        <div class="flex items-center justify-between">
                            <?php echo e($invest->links('vendor.pagination.custom')); ?>

                        </div>
                    </div>

                </div>
                <!-- Table Five -->
            </div>
            <!-- Content End -->
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaldc6c47b2dbde2c874161740878d1c990)): ?>
<?php $attributes = $__attributesOriginaldc6c47b2dbde2c874161740878d1c990; ?>
<?php unset($__attributesOriginaldc6c47b2dbde2c874161740878d1c990); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaldc6c47b2dbde2c874161740878d1c990)): ?>
<?php $component = $__componentOriginaldc6c47b2dbde2c874161740878d1c990; ?>
<?php unset($__componentOriginaldc6c47b2dbde2c874161740878d1c990); ?>
<?php endif; ?><?php /**PATH /home/allejouk/Desktop/work/NEW BINARY/resources/views/admin/live/trade.blade.php ENDPATH**/ ?>